/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.ReservedByServiceApplication;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;

public class ReservedByAction
extends AbstractAction {
    private static final long serialVersionUID = 4886769327146667025L;
    private MainWindowController myMwc = null;
    private AbstractViewElement myElement = null;
    int tryes = 0;
    int exceptions = 0;

    public ReservedByAction(String action, AbstractViewElement element, MainWindowController mwc) {
        this.myElement = element;
        this.myMwc = mwc;
        Object properties = null;
        this.putValue("Name", action);
    }

    public void actionPerformed(ActionEvent event) {
        if (null == this.myElement) {
            return;
        }
        this.findAllReservedByReferences();
    }

    public void findAllReservedByReferences() {
        Vector reservedByVector = new Vector();
        Object[] allObjects = this.myElement.getAllRelevantMOs();
        if (allObjects != null && allObjects.length > 0) {
            int i;
            MOProxy[] tmp = new MOProxy[allObjects.length];
            for (i = 0; i < allObjects.length; ++i) {
                tmp[i] = (MOProxy)allObjects[i];
            }
            for (i = 0; i < tmp.length; ++i) {
                Vector tmpVector = this.getReservingMOs(tmp[i]);
                for (int j = 0; j < tmpVector.size(); ++j) {
                    if (reservedByVector.indexOf(tmpVector.elementAt(j)) != -1) continue;
                    reservedByVector.add(tmpVector.elementAt(j));
                }
            }
        } else {
            String myDN = this.myElement.getDN();
            if (!myDN.equals("")) {
                reservedByVector = this.getReservingMOs(new MOProxy(myDN));
            }
        }
        if (reservedByVector.size() == 0) {
            Object[] exceptionMessage = new Object[]{""};
            this.myMwc.showMessageDialog(this.exceptions != this.tryes ? "RESERVEDBY_NOT_RESERVED" : "RESERVEDBY_NOT_RESERVABLE", null, "INFORMATION_MESSAGE_BOX_TITLE", exceptionMessage, -1, null);
            return;
        }
        this.showReservers(reservedByVector);
    }

    private Vector getReservingMOs(MOProxy myMO) {
        int index = 0;
        Vector<String> reserversVector = new Vector<String>();
        StringBuffer viewReservedByTypes = new StringBuffer(this.myElement.getReservedByTypes());
        if (viewReservedByTypes.toString().equals("")) {
            viewReservedByTypes.append("reservedBy");
        } else {
            viewReservedByTypes.append(",reservedBy");
        }
        StringTokenizer st = new StringTokenizer(viewReservedByTypes.toString(), ",");
        while (st.hasMoreTokens()) {
            String reserverType = st.nextToken();
            try {
                ++this.tryes;
                Object obj = myMO.getAttribute(reserverType);
                MOProxy[] reservedByArray = null;
                if (obj != null && obj instanceof Object[]) {
                    reservedByArray = (MOProxy[])obj;
                    if (reservedByArray.length == 0) {
                        continue;
                    }
                } else {
                    if (obj == null || !(obj instanceof Object) || ((MOProxy)obj).toString() == null) continue;
                    reservedByArray = new MOProxy[]{(MOProxy)obj};
                }
                if (reservedByArray != null && reservedByArray[0] != null && reservedByArray.length > 0) {
                    reserversVector.ensureCapacity(reserversVector.size() + reservedByArray.length);
                    while (index < reservedByArray.length) {
                        if (reservedByArray[index] != null) {
                            reserversVector.add(index, reservedByArray[index].getDN());
                        }
                        ++index;
                    }
                    continue;
                }
                Object[] exceptionMessage = new Object[]{""};
                this.myElement.showMessageDialog("RESERVEDBY_NOT_RESERVED", null, "INFORMATION_MESSAGE_BOX_TITLE", exceptionMessage, -1, null);
            }
            catch (CSException e) {
                ++this.exceptions;
            }
        }
        return reserversVector;
    }

    private void showReservers(Vector reservers) {
        Object[][] douleArray = new Object[1][2];
        douleArray[0][0] = "reservers";
        douleArray[0][1] = reservers;
        ReservedByServiceApplication reserversViewer = (ReservedByServiceApplication)this.myMwc.startApplication("se.ericsson.cello.support.gui.ReservedByServiceApplication", douleArray, true);
    }
}

