/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class ShowLDNAction
extends AbstractAction {
    private static final long serialVersionUID = 6825427595230339468L;
    private AbstractViewElement myElement = null;
    private ResourceBundle myLanguageBundle = null;
    private static ArrayList allOpenLDNWindows = new ArrayList();

    public ShowLDNAction(String action, AbstractViewElement element, ResourceBundle bundle) {
        this.myElement = element;
        this.myLanguageBundle = bundle;
        this.putValue("Name", action);
    }

    public void actionPerformed(ActionEvent event) {
        if (null == this.myElement) {
            return;
        }
        String ldn = this.myElement.getDN();
        this.showLdnDialog(ldn);
    }

    private void showLdnDialog(String ldn) {
        String title = null;
        MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
        Icon icon = IconHelper.createIcon(null);
        if (null != this.myLanguageBundle) {
            title = this.myLanguageBundle.getString("LDN_TITLE");
        }
        if (title == null) {
            title = "LDN";
        }
        JTextArea txt = new JTextArea(ldn);
        txt.setEditable(false);
        txt.setBackground(refMainWindowController.getView().getBackground());
        txt.setFont(refMainWindowController.getView().getFont());
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(txt, 20, 31);
        scrollPane.setPreferredSize(new Dimension(600, 70));
        String closeString = this.myLanguageBundle.getString("CLOSE");
        if (null == closeString) {
            closeString = "Close";
        }
        Object[] options = new String[]{closeString};
        JOptionPane pane = new JOptionPane(scrollPane, -1, -1, null, options, options[0]);
        JDialog dialog = pane.createDialog(refMainWindowController.getView(), title);
        dialog.setResizable(true);
        dialog.setModal(false);
        dialog.show();
        allOpenLDNWindows.add(dialog);
    }

    public static void closeAllLDNWindows() {
        try {
            if (allOpenLDNWindows != null) {
                int numberOfWindows = allOpenLDNWindows.size();
                for (int i = 0; i < numberOfWindows; ++i) {
                    JDialog tempDialog = (JDialog)allOpenLDNWindows.get(i);
                    tempDialog.hide();
                    tempDialog.dispose();
                }
                allOpenLDNWindows.clear();
            }
        }
        catch (Exception e) {
            Log.logError("CloseAllLDNWindows" + e);
        }
    }
}

