/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Color;
import se.ericsson.cello.support.gui.gengui.EntryField;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class GenIntegerField
extends EntryField {
    private static final long serialVersionUID = -6465002047836745359L;
    protected Integer integerValue = null;
    private int minValue = 0;
    private int maxValue = 0;
    boolean checkMinValue = false;
    boolean checkMaxValue = false;

    public GenIntegerField(String translations, String tag, Integer length) {
        super(translations, tag, length);
        Log.trace("Constructor()");
        this.textField.setHorizontalAlignment(4);
    }

    public GenIntegerField(String tag, Integer length) {
        super(tag, length);
        Log.trace("GenIntegerField()");
        this.textField.setHorizontalAlignment(4);
    }

    public boolean setValue(Integer setvalue) {
        Log.trace("setValue()");
        if (this.isValidSyntax(setvalue)) {
            this.textField.setForeground(Color.black);
            this.textField.setText(String.valueOf(setvalue));
            this.integerValue = setvalue;
            this.faultyValueEntered = false;
            return true;
        }
        return false;
    }

    public Integer getValue() {
        Log.trace("getValue()");
        if (this.textField.getText().equals("") || this.isValidSyntax()) {
            this.fillInValue(this.textField.getText());
            this.faultyValueEntered = false;
            this.textField.setForeground(Color.black);
        } else {
            this.integerValue = null;
            this.faultyValueEntered = true;
            this.textField.setForeground(this.myRedColor);
        }
        return this.integerValue;
    }

    public void setMinimumValue(Integer min) {
        Log.trace("setMinimumValue()");
        this.checkMinValue = true;
        this.minValue = min;
        if (this.checkMaxValue) {
            this.textField.setToolTipText("[" + this.minValue + "," + (this.minValue + 1) + ",...," + this.maxValue + "]");
        } else {
            this.textField.setToolTipText("[" + this.minValue + "," + (this.minValue + 1) + ",...]");
        }
    }

    public void setMaximumValue(Integer max) {
        Log.trace("setMaximumValue()");
        this.checkMaxValue = true;
        this.maxValue = max;
        if (this.checkMinValue) {
            this.textField.setToolTipText("[" + this.minValue + "," + (this.minValue + 1) + ",...," + this.maxValue + "]");
        } else {
            this.textField.setToolTipText("[...," + (this.maxValue - 1) + "," + this.maxValue + "]");
        }
    }

    protected boolean isValidSyntax() {
        Log.trace("isValixSyntax()");
        boolean check = false;
        try {
            int filledInValue = Integer.parseInt(this.textField.getText());
            if (!(this.checkMinValue && filledInValue < this.minValue || this.checkMaxValue && filledInValue > this.maxValue)) {
                check = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return check;
    }

    protected String getTag() {
        return null;
    }

    protected boolean fillInValue(String text) {
        int newValue;
        Log.trace("FillInValue()");
        if (text.equals("")) {
            if (this.integerValue == null) {
                return false;
            }
            this.integerValue = null;
            return true;
        }
        try {
            newValue = Integer.parseInt(text);
        }
        catch (NumberFormatException exep) {
            if (null == this.integerValue) {
                return false;
            }
            this.integerValue = null;
            return true;
        }
        if (this.integerValue != null && this.integerValue == newValue) {
            return false;
        }
        this.integerValue = new Integer(newValue);
        return true;
    }

    private boolean isValidSyntax(Integer setValue) {
        Log.trace("isValixSyntax()");
        boolean check = false;
        try {
            if (!(this.checkMinValue && setValue < this.minValue || this.checkMaxValue && setValue > this.maxValue)) {
                check = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return check;
    }
}

