/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.Translatable;

public class GenMenuItem
extends JMenuItem
implements Translatable {
    private static final long serialVersionUID = 3412241566085482097L;
    private String myTag = null;
    private String myBundle = null;
    static final char MNEMONIC_INDICATOR = '&';
    static final char SHORTCUT_INDICATOR = '|';

    public GenMenuItem(String translations, String tag, ActionListener aListener, String aCommand) {
        Log.trace("Constructor()");
        this.myTag = tag;
        this.setName(tag);
        this.myBundle = translations;
        this.setActionListener(aListener, aCommand);
    }

    public GenMenuItem(String translations, String tag) {
        Log.trace("Constructor()");
        this.myTag = tag;
        this.setName(tag);
        this.myBundle = translations;
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        if (aListener != null) {
            this.addActionListener(aListener);
        }
        this.setActionCommand(aCommand);
    }

    public void translate(ResourceBundle bundle, Locale locale) {
        Log.trace("translate()");
        ResourceBundle rb = GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader());
        try {
            String label = rb.getString(this.myTag);
            Character amp = this.getMnemonic(label);
            if (amp != null) {
                this.setMnemonic(amp.charValue());
            } else {
                this.setMnemonic('\u0000');
            }
            this.setText(this.stripString(label));
        }
        catch (MissingResourceException mre) {
            this.setText(this.myTag);
        }
    }

    private String stripString(String str) {
        int ctrlIndex = str.lastIndexOf(124);
        String tmpStr = str;
        if (ctrlIndex != -1) {
            tmpStr = str.substring(0, ctrlIndex);
        }
        String tmpStr2 = tmpStr;
        int ampIndex = tmpStr.indexOf(38);
        if (ampIndex != -1) {
            char amp = tmpStr.charAt(ampIndex + 1);
        }
        tmpStr2 = "";
        if (ampIndex > 0) {
            tmpStr2 = tmpStr.substring(0, ampIndex);
        }
        if (tmpStr.length() > ampIndex + 1) {
            tmpStr2 = tmpStr2 + tmpStr.substring(ampIndex + 1);
        }
        return tmpStr2;
    }

    private Character getMnemonic(String str) {
        Character amp = null;
        int ampIndex = str.indexOf(38);
        if (ampIndex != -1) {
            amp = new Character(str.charAt(ampIndex + 1));
        }
        return amp;
    }
}

