/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.comp;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;

public class Log {
    public static final int MIN_LOG_LEVEL = 0;
    public static final int MAX_LOG_LEVEL = 7;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int NOTIFY = 3;
    public static final int PARAM = 4;
    public static final int TRACE_FLOW = 5;
    public static final int TRACE = 6;
    public static String[] LOG_LEVEL_KEYS = new String[]{"GSL_MIN_LOG_LEVEL", "GSL_ERROR", "GSL_WARNING", "GSL_NOTIFY", "GSL_PARAM", "GSL_TRACE_FLOW", "GSL_TRACE", "GSL_MAX_LOG_LEVEL"};
    public static int[] LOG_LEVEL_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final String NEW_LINE = System.getProperty("line.separator", "'\n''\r'");
    private static final char FIRST_NEW_LINE_CHAR = NEW_LINE.charAt(0);
    private static int logLevel = 3;
    private static int logCount = 0;
    private static boolean lineNumberInfo = true;
    private static PrintStream logger;
    private static SimpleDateFormat dateFormatter;
    private static boolean logToStdOut;
    private static boolean logToFile;
    private static String logFileNamePrefix;
    private static String logFileNameSuffix;
    private static String logFileName;
    private static String logFilePath;
    private static String logFilePathAndName;
    private static ByteArrayOutputStream exceptionStream;
    private static PrintWriter exceptionWriter;
    private static Hashtable currentMeasurements;
    private static boolean measurementInfoOn;
    private static boolean garbageCollectAtMeasure;

    private Log() {
    }

    public static void assertion(boolean assertion, String msg) {
        if (!assertion) {
            throw new RuntimeException("Assertion failed: " + msg);
        }
    }

    public static final void setLogLevel(int level) {
        if (level >= 0 && level <= 7) {
            logLevel = level;
            Log.trace("logLevel was set to: " + logLevel);
        } else {
            logLevel = 2;
            Log.logWarning("Illegal log level: " + level + "(using default: logLevel=WARNING)");
        }
    }

    public static final int getLogLevel() {
        return logLevel;
    }

    public static final void setLogToStdOut(boolean aLogToStdOut) {
        logToStdOut = aLogToStdOut;
        Log.trace("logToStdOut was set to: " + logToStdOut);
    }

    public static final boolean getLogToStdOut() {
        return logToStdOut;
    }

    public static final void setLogToFile(boolean aLogToFile) {
        logToFile = aLogToFile;
        Log.trace("logToFile was set to: " + logToFile);
    }

    public static final boolean getLogToFile() {
        return logToFile;
    }

    public static final void setLogFileNamePrefix(String aLogFileNamePrefix) {
        if (!logFileNamePrefix.equals(aLogFileNamePrefix)) {
            logFileNamePrefix = aLogFileNamePrefix;
            logFileNameSuffix = null;
            Log.trace("logFileNamePrefix was set to: " + logFileNamePrefix);
        }
    }

    public static final String getLogFileNamePrefix() {
        return logFileNamePrefix;
    }

    public static final String getLogFilePathAndName() {
        return logFilePathAndName;
    }

    public static final void setLineNumberInfo(boolean lnInfo) {
        lineNumberInfo = lnInfo;
    }

    public static final void traceFlow() {
        if (logLevel < 5) {
            return;
        }
        StringBuffer buf = new StringBuffer(logCount++).append(" TRACE_FLOW ").append(Log.getLineNumber(Log.getStackTrace(new Throwable())));
        Log.println(buf.toString());
    }

    public static final void trace(String msg) {
        if (logLevel < 6) {
            return;
        }
        Log.log("TRACE", msg, null);
    }

    public static final void logNotify(String msg) {
        if (logLevel < 3) {
            return;
        }
        Log.log("NOTIFY", msg, null);
    }

    public static final void logWarning(String msg) {
        if (logLevel < 2) {
            return;
        }
        Log.log("WARNING", msg, null);
    }

    public static final void logError(String msg) {
        if (logLevel < 1) {
            return;
        }
        Log.log("ERROR", msg, null);
    }

    public static final void logError(String msg, Throwable t) {
        if (logLevel < 1) {
            return;
        }
        Log.log("ERROR", msg, t);
    }

    public static final void log(int level, String msg) {
        if (logLevel < level) {
            return;
        }
        Log.log(null, msg, null);
    }

    public static final void log(int level, String msg, Throwable t) {
        if (logLevel < level) {
            return;
        }
        Log.log(null, msg, t);
    }

    private static final void log(int level, String prefix, String msg, Throwable t) {
        if (logLevel < level) {
            return;
        }
        Log.log(prefix, msg, t);
    }

    private static final void log(String prefix, String msg, Throwable t) {
        StringBuffer buf = new StringBuffer();
        buf.append(logCount++).append(" ");
        if (prefix != null) {
            buf.append(prefix).append(" ");
        }
        if (msg != null) {
            buf.append(msg);
        }
        if (lineNumberInfo) {
            buf.append(" AT LINE: ").append(Log.getLineNumber(Log.getStackTrace(new Throwable())));
        }
        Log.println(buf.toString());
        if (t != null) {
            Log.println("Exception: " + t);
            Log.println(Log.getStackTrace(t));
            if (t instanceof InvocationTargetException) {
                Throwable target = ((InvocationTargetException)t).getTargetException();
                Log.println("Target Exception: " + target);
                Log.println(Log.getStackTrace(target));
            }
        }
    }

    private static void println(String str) {
        if (logToStdOut) {
            Log.getLogger().println(str);
        }
        if (logToFile) {
            Log.writeToFile(str);
        }
    }

    private static void writeToFile(String text) {
        try {
            if (logFileNameSuffix == null) {
                logFilePath = System.getProperty("user.home");
                Date theCurrentDate = new Date();
                logFileNameSuffix = dateFormatter.format(theCurrentDate);
                logFileName = logFileNamePrefix + "_" + logFileNameSuffix + ".txt";
                logFilePathAndName = logFilePath + System.getProperty("file.separator") + logFileName;
                Log.logNotify("Creating log file: " + logFilePathAndName);
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(logFilePathAndName, true));
            bw.write(text);
            bw.newLine();
            bw.close();
        }
        catch (IOException e) {
            Log.logError("Cannot write to file : ", e);
        }
    }

    public static final void flush() {
        Log.getLogger().flush();
    }

    public static void setMeasurementInfoOn(boolean inFlag) {
        measurementInfoOn = inFlag;
        Log.trace("measurementInfoOn was set to: " + measurementInfoOn);
    }

    public static void setGarbageCollectAtMeasure(boolean inFlag) {
        garbageCollectAtMeasure = inFlag;
    }

    public static void measure(Object key, boolean start) {
        Log.measure(key, start, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void measure(Object key, boolean start, String msg) {
        if (!measurementInfoOn) return;
        Class<Measurement> clazz = Measurement.class;
        synchronized (Measurement.class) {
            Stack<Measurement> measurements = (Stack<Measurement>)currentMeasurements.get(key);
            if (start) {
                if (measurements == null) {
                    measurements = new Stack<Measurement>();
                    currentMeasurements.put(key, measurements);
                }
                Measurement measurement = new Measurement(key, msg);
                measurement.setMeasureTime(true);
                measurement.setMeasureMemory(false);
                measurements.push(measurement);
            } else if (measurements == null || measurements.isEmpty()) {
                Log.logWarning("Can't stop measurement before it has started.");
            } else {
                int count;
                Measurement measurement = (Measurement)measurements.pop();
                measurement.stop();
                if (msg != null) {
                    measurement.setMessage(msg);
                }
                if ((count = measurements.size()) > 0) {
                    measurement.setCount(count + 1);
                }
                Log.log(3, "MEASUREMENT", measurement.toString(), null);
                if (!measurements.isEmpty()) return;
                currentMeasurements.remove(key);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void measure() {
        Log.measure(null);
    }

    public static void measure(String msg) {
        if (measurementInfoOn) {
            Measurement measurement = new Measurement("measure", msg);
            measurement.setMeasureMemory(false);
            measurement.stop();
            Log.log(3, measurement.toString());
        }
    }

    private static final PrintStream getLogger() {
        if (logger == null) {
            logger = System.out;
        }
        return logger;
    }

    private static final String getLineNumber(String stackTrace) {
        int index = stackTrace.lastIndexOf("guilib.comp.Log.log(");
        if (index == -1) {
            return null;
        }
        index = stackTrace.indexOf("at ", index + 1);
        if ((index = stackTrace.indexOf("at ", index + 1)) == -1) {
            return null;
        }
        int endIndex = stackTrace.indexOf(FIRST_NEW_LINE_CHAR, index + 1);
        String lineNumber = stackTrace.substring(index + 3, endIndex);
        return lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = exceptionStream;
        synchronized (byteArrayOutputStream) {
            exceptionStream.reset();
            throwable.printStackTrace(exceptionWriter);
            return exceptionStream.toString();
        }
    }

    static {
        dateFormatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        logToStdOut = true;
        logToFile = false;
        logFileNamePrefix = "log_GUILIB";
        logFileNameSuffix = null;
        logFileName = "nameless";
        exceptionStream = new ByteArrayOutputStream(1200);
        exceptionWriter = new PrintWriter(exceptionStream, true);
        currentMeasurements = new Hashtable(10);
        measurementInfoOn = false;
        garbageCollectAtMeasure = false;
    }

    private static class Measurement {
        private long startTime;
        private long stopTime;
        private Object src;
        private String msg = "";
        private int count;
        private long allocatedMemory;
        private long allocatedMemoryAfterGC;
        private static NumberFormat numberFormatter;
        private boolean measureTimeFlag = false;
        private boolean measureMemoryFlag = false;

        public Measurement(Object src, String msg) {
            this.src = src;
            this.setMessage(msg);
            if (numberFormatter == null) {
                numberFormatter = NumberFormat.getInstance();
                numberFormatter.setMaximumFractionDigits(1);
                numberFormatter.setGroupingUsed(false);
            }
            this.startTime = System.currentTimeMillis();
        }

        public void setMessage(String msg) {
            this.msg = msg == null ? "" : msg;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setMeasureTime(boolean inFlag) {
            this.measureTimeFlag = inFlag;
        }

        public void setMeasureMemory(boolean inFlag) {
            this.measureMemoryFlag = inFlag;
        }

        public long getDifference() {
            long stopTime = this.stopTime == 0L ? System.currentTimeMillis() : this.stopTime;
            long difference = stopTime - this.startTime;
            return difference;
        }

        public long getAllocatedMemory() {
            long allocatedMemory = this.allocatedMemory;
            if (this.allocatedMemory == 0L) {
                allocatedMemory = this.calculateAllocatedMemory();
            }
            return allocatedMemory;
        }

        public long getAllocatedMemoryAfterGarbageCollect() {
            long allocatedMemory = this.allocatedMemoryAfterGC;
            if (this.allocatedMemoryAfterGC == 0L) {
                Runtime.getRuntime().gc();
                Thread.yield();
                allocatedMemory = this.calculateAllocatedMemory();
            }
            return allocatedMemory;
        }

        private long calculateAllocatedMemory() {
            Runtime r = Runtime.getRuntime();
            return r.totalMemory() - r.freeMemory();
        }

        public void stop() {
            if (this.measureTimeFlag) {
                this.stopTime = System.currentTimeMillis();
            }
            if (this.measureMemoryFlag) {
                this.allocatedMemory = this.getAllocatedMemory();
                if (garbageCollectAtMeasure) {
                    this.allocatedMemoryAfterGC = this.getAllocatedMemoryAfterGarbageCollect();
                }
            }
        }

        public String toString() {
            String output = this.msg;
            if (this.measureTimeFlag) {
                output = output + " : " + this.getDifference() + " ms ";
            }
            if (this.measureMemoryFlag) {
                long allocatedMemory = this.getAllocatedMemory();
                double allocatedKB = (double)allocatedMemory / 1000.0;
                String allocatedKBString1 = numberFormatter.format(allocatedKB);
                String allocatedKBString2 = "";
                if (garbageCollectAtMeasure) {
                    allocatedMemory = this.getAllocatedMemoryAfterGarbageCollect();
                    allocatedKB = (double)allocatedMemory / 1000.0;
                    allocatedKBString2 = " (" + numberFormatter.format(allocatedKB) + ")";
                }
                output = output + " : " + allocatedKBString1 + allocatedKBString2 + " kB";
            }
            return output;
        }
    }
}

