/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Cursor;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.omg.CORBA.ORB;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.cello.support.gui.guilib.infra.Resources;

public abstract class AbstractApplication
implements Application,
Resources {
    private ApplicationManager applicationManager;
    private JApplet applet;
    private Properties environment;
    private Locale locale;
    static final String SHOW_APPLICATION_IN_APPLET = "gsl.showapplicationinapplet";
    private ApplicationPresenter applicationPresenter;

    public abstract String getApplicationViewClassName();

    public abstract String getApplicationControllerClassName();

    public abstract String getLanguageBundleName();

    public abstract String getEnvironmentBundleName();

    public abstract String getToolTipBundleName();

    public abstract String getHelpBundleName();

    void init(ApplicationManager applicationManager, Locale locale, Properties env) {
        this.applicationManager = applicationManager;
        this.locale = locale;
        String bundleName = this.getEnvironmentBundleName();
        if (bundleName != null) {
            ApplicationManager.loadBundle(bundleName, locale, env);
        }
        this.setEnvironment(env);
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    protected JApplet getApplet() {
        return this.applet;
    }

    void setApplet(JApplet applet) {
        this.applet = applet;
    }

    ApplicationPresenter getApplicationPresenter() {
        return this.applicationPresenter;
    }

    void setApplicationPresenter(ApplicationPresenter applicationPresenter) {
        this.applicationPresenter = applicationPresenter;
    }

    public AbstractHelp getHelp() {
        if (this.applicationPresenter != null) {
            return this.applicationPresenter.getHelp();
        }
        return null;
    }

    public void stopApplication() {
        ToolTipManager.sharedInstance().setEnabled(false);
        this.applicationManager.stopApplication(this);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolTipManager.sharedInstance().setEnabled(true);
                }
            });
        }
        catch (Exception e) {
            Log.trace("GuiLib exception in when re-enabling tooltip");
            e.printStackTrace();
        }
    }

    public void stopApplicationNoCheck() {
        this.applicationManager.stopApplicationNoCheck(this);
    }

    public Object getParameter(String key) {
        return this.applicationPresenter.getParameter(key);
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public ORB getORB() {
        return this.applicationManager.getCorbaNameResolver().initORB();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.applicationPresenter.updateLocale(locale);
    }

    public ResourceBundle getLanguageBundle() {
        return this.applicationPresenter.getLanguageManager().getLanguageBundle();
    }

    public ResourceBundle getToolTipBundle() {
        return this.applicationPresenter.getLanguageManager().getToolTipBundle();
    }

    public String getTitle() {
        return this.applicationPresenter.getTitle();
    }

    public String getUserId() {
        String userId = "Undefined User";
        try {
            userId = System.getProperty("user.name");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return userId;
    }

    public void setTitle(String titleKey, Object[] titleArgs) {
        this.applicationPresenter.setTitle(titleKey, titleArgs);
    }

    public String getStatus() {
        return this.applicationPresenter.getStatus();
    }

    public void setStatus(String statusKey, Object[] statusArgs) {
        this.applicationPresenter.setStatus(statusKey, statusArgs);
    }

    public void setStatus(String statusString) {
        this.applicationPresenter.setStatus(statusString);
    }

    public void setCursor(Cursor cursor) {
        this.applicationPresenter.setCursor(cursor, true);
    }

    public boolean isVisible() {
        return this.applicationPresenter.isVisible();
    }

    public void setVisible(boolean visible) {
        this.applicationPresenter.setVisible(visible);
    }

    public void bringToFront() {
        this.applicationPresenter.bringToFront();
    }

    public void setEnabled(boolean enabled) {
        this.applicationPresenter.setEnabled(enabled, true);
    }

    public boolean isEnabled() {
        return this.applicationPresenter.isEnabled();
    }

    public boolean isSingleton() {
        return false;
    }
}

