/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import javax.swing.Icon;
import javax.swing.JPanel;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;

public abstract class AbstractView
extends JPanel {
    private static final long serialVersionUID = 580951678907441635L;
    private AbstractPresenter presenter;

    void init(AbstractPresenter presenter) {
        this.presenter = presenter;
        this.putClientProperty("HELP_KEY", "GSL_DEFAULTMENU_HELPMENU_ONWINDOW");
    }

    AbstractPresenter getPresenter() {
        return this.presenter;
    }

    protected abstract void init();

    void dispose() {
        this.presenter = null;
        this.removeComponents(this);
    }

    private void removeComponents(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] components = container.getComponents();
            container.removeAll();
            for (int i = 0; i < components.length; ++i) {
                this.removeComponents(components[i]);
            }
        }
    }

    public AbstractApplication getApplication() {
        return this.presenter.getApplication();
    }

    public void setCursor(Cursor cursor) {
        this.presenter.setCursor(cursor, false);
    }

    public void setEnabled(boolean enabled) {
        this.presenter.setEnabled(enabled, false);
    }

    public boolean isEnabled() {
        return this.presenter.isEnabled();
    }

    public String getProperty(String key) {
        return this.presenter.getApplication().getEnvironment().getProperty(key);
    }

    public Icon createIcon(String name) {
        return IconHelper.createIcon(name);
    }

    public boolean isResizable() {
        return true;
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        this.presenter.getViewContainer().setHorizontalScrollBarPolicy(policy);
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.presenter.getViewContainer().setVerticalScrollBarPolicy(policy);
    }
}

