/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationDefaultView;

class ApplicationToolBar
extends JToolBar {
    private static final long serialVersionUID = -9078303809178736802L;
    private ToolBarComponent[] compArray;
    private ApplicationDefaultView defaultView;

    void dispose() {
        this.defaultView = null;
    }

    ApplicationToolBar(ApplicationDefaultView defaultView) {
        this.defaultView = defaultView;
        this.setBorderPainted(true);
        this.setBorder(new EtchedBorder());
        JComponent[] toolBarComponents = defaultView.getToolBarComponents();
        if (toolBarComponents.length > 0) {
            this.compArray = new ToolBarComponent[toolBarComponents.length];
            for (int i = 0; i < toolBarComponents.length; ++i) {
                this.compArray[i] = new ToolBarComponent(toolBarComponents[i], true);
            }
        }
        this.buildToolBar();
    }

    void setComponentsVisible(JComponent[] comps, boolean visible) {
        block0: for (int i = 0; i < comps.length; ++i) {
            for (int j = 0; j < this.compArray.length; ++j) {
                ToolBarComponent component = this.compArray[j];
                if (component.getComponent() != comps[i]) continue;
                component.setVisible(visible);
                continue block0;
            }
        }
        this.buildToolBar();
    }

    private void buildToolBar() {
        if (this.compArray == null) {
            return;
        }
        this.removeAll();
        for (int i = 0; i < this.compArray.length; ++i) {
            if (!this.compArray[i].isVisible()) continue;
            this.compArray[i].getComponent().setRequestFocusEnabled(false);
            this.add(this.compArray[i].getComponent());
        }
    }

    JComponent getCutButton() {
        return this.defaultView.getCutButton();
    }

    JComponent getCopyButton() {
        return this.defaultView.getCopyButton();
    }

    JComponent getPasteButton() {
        return this.defaultView.getPasteButton();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    private static class ToolBarComponent {
        private JComponent comp;
        private boolean visible;

        public ToolBarComponent(JComponent comp, boolean visible) {
            this.comp = comp;
            this.visible = visible;
        }

        public JComponent getComponent() {
            return this.comp;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

