/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;

class DialogViewContainer
extends JDialog
implements ViewContainer {
    private static final long serialVersionUID = -8324253716510843746L;
    private AbstractPresenter presenter;
    private boolean visible;
    private boolean beenVisible;
    private WinAdapter winAdapter = new WinAdapter();
    private JPanel viewPane;

    public DialogViewContainer(Frame frame, boolean modal) {
        super(frame, modal);
    }

    public DialogViewContainer(Dialog dialog, boolean modal) {
        super(dialog, modal);
    }

    public void init(AbstractPresenter presenter) {
        this.presenter = presenter;
        this.getContentPane().setLayout(new BorderLayout());
        this.viewPane = new JPanel();
        this.viewPane.setLayout(new BoxLayout(this.viewPane, 1));
        this.getContentPane().add((Component)this.viewPane, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.winAdapter);
    }

    public void setView(AbstractView view) {
        this.viewPane.removeAll();
        this.viewPane.add(view);
        this.setResizable(view.isResizable());
    }

    public void setViewResizable(boolean resizable) {
        this.setResizable(resizable);
    }

    public void setToolBar(ApplicationToolBar applicationToolBar) {
    }

    public void setMenuBar(ApplicationMenuBar applicationMenuBar) {
    }

    public Window getWindow() {
        return this;
    }

    public Component getComponent() {
        return this;
    }

    public void setStatus(String status) {
    }

    public void setVisible(boolean visible) {
        if (this.isModal()) {
            if (!visible) {
                this.visible = visible;
            } else {
                if (this.isVisible() != this.visible) {
                    Log.logWarning("Modal dialog visibility out of sync Dialog: " + this.isVisible() + " Container: " + this.visible);
                }
                if (!this.isVisible()) {
                    this.setVisibleImpl(visible);
                }
            }
        } else {
            this.setVisibleImpl(visible);
        }
    }

    private void setVisibleImpl(boolean visible) {
        if (visible && !this.beenVisible) {
            this.pack();
            if (this.isModal()) {
                this.centerOnScreen();
            } else {
                this.centerOnOwner();
            }
        }
        this.visible = visible;
        if (visible) {
            SwingUtilities.invokeLater(new DoSetVisible());
        } else {
            this.setVisibleSuper(visible);
        }
    }

    private void setVisibleSuper(boolean visible) {
        super.setVisible(visible);
    }

    public void setEnabled(boolean enabled) {
        if (this.presenter.isDefaultEnabling()) {
            super.setEnabled(enabled);
        }
    }

    public void bringToFront() {
        this.toFront();
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public void setMaximized() {
    }

    public void setMinimized() {
    }

    public void setRestored() {
    }

    public void doValidate() {
        this.validate();
        this.repaint();
    }

    public void dispose() {
        if (this.presenter != null) {
            this.getContentPane().removeAll();
            this.removeWindowListener(this.winAdapter);
            this.winAdapter = null;
        }
        super.dispose();
    }

    private void centerOnOwner() {
        Window owner = this.getOwner();
        Rectangle bounds = owner.getBounds();
        if (bounds.x <= 0 || bounds.y <= 0) {
            this.centerOnScreen();
        } else {
            this.setLocation((bounds.width - this.getSize().width) / 2 + bounds.x, (bounds.height - this.getSize().height) / 2 + bounds.y);
        }
    }

    private void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
    }

    public void setHorizontalScrollBarPolicy(int policy) {
    }

    public void setVerticalScrollBarPolicy(int policy) {
    }

    private class DoSetVisible
    implements Runnable {
        private DoSetVisible() {
        }

        public void run() {
            if (DialogViewContainer.this.visible) {
                DialogViewContainer.this.setVisibleSuper(true);
            }
        }
    }

    private class WinAdapter
    extends WindowAdapter {
        private WinAdapter() {
        }

        public void windowOpened(WindowEvent e) {
            if (!DialogViewContainer.this.beenVisible) {
                DialogViewContainer.this.beenVisible = true;
                if (DialogViewContainer.this.isModal()) {
                    DialogViewContainer.this.presenter.getController().afterVisible();
                }
            }
        }

        public void windowClosing(WindowEvent e) {
            if (DialogViewContainer.this.presenter.isEnabled()) {
                DialogViewContainer.this.presenter.getController().viewClosing();
            }
        }
    }
}

