/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHandler;
import se.ericsson.cello.support.gui.guilib.infra.EditListeners;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;
import se.ericsson.cello.support.gui.guilib.infra.MenuToolbarHandler;
import se.ericsson.cello.support.gui.guilib.infra.ResourceBundleDelegator;
import se.ericsson.cello.support.gui.guilib.infra.Resources;
import se.ericsson.cello.support.gui.guilib.infra.Translatable;
import se.ericsson.cello.support.gui.guilib.table.ColumnGroup;
import se.ericsson.cello.support.gui.guilib.table.GroupableTableHeader;

class LanguageManager
extends AbstractHandler {
    static final char MNEMONIC_INDICATOR = '&';
    static final char SHORTCUT_INDICATOR = '|';
    static final String SUPPORTED_LOCALES = "gsl.language.supportedlocales";
    static final Locale EMPTY_LOCALE = new Locale("", "");
    static final String DEFAULT_LANGUAGE_BUNDLE_NAME_KEY = "gsl.language.default.bundle.name";
    static final String DEFAULT_TOOLTIP_BUNDLE_NAME_KEY = "gsl.tooltip.default.bundle.name";
    static final String SYSTEM_LANGUAGE_BUNDLE_NAME_KEY = "gsl.language.system.bundle.name";
    static final String SYSTEM_TOOLTIP_BUNDLE_NAME_KEY = "gsl.tooltip.system.bundle.name";
    static final String UI_STRINGS_BUNDLE_NAME_KEY = "gsl.ui.strings.bundle.name";
    static final String UI_MNEMONICS_BUNDLE_NAME_KEY = "gsl.ui.mnemonics.bundle.name";
    static final String KEY = "gsl.lanaguage.key";
    static final String TOOLTIPKEY = "gsl.tooltip.key";
    private Vector languageComponents = new Vector();
    private static UILanguageHandler uiLanguageHandler;
    private ResourceBundleDelegator languageBundle;
    private ResourceBundleDelegator toolTipBundle;
    private ResourceBundle uiStrings;
    private ResourceBundle uiMnemonics;
    private boolean stripShortcut = false;
    private Locale locale;

    LanguageManager() {
    }

    private void addBundle(String bundleName, ResourceBundleDelegator delegator) {
        Log.log(4, "Trying to load bundle:" + bundleName);
        ResourceBundle bundle = this.getBundle(bundleName);
        if (bundle != null) {
            delegator.add(bundle);
        } else {
            Log.logWarning("Not able to load bundle:" + bundleName);
        }
    }

    public void dispose() {
        Enumeration enume = this.languageComponents.elements();
        while (enume.hasMoreElements()) {
            ((AbstractLanguageHandler)enume.nextElement()).dispose();
        }
        this.languageComponents.clear();
    }

    public boolean handleComponent(JComponent comp) {
        return this.handleComponent_Impl(comp);
    }

    private boolean handleComponent_Impl(JComponent aComponent) {
        String languageControlled = (String)aComponent.getClientProperty("LANGUAGE_CONTROLLED");
        if (languageControlled != null) {
            if (aComponent instanceof LocaleChangeListener) {
                this.presenter.addLocaleChangeListener((LocaleChangeListener)((Object)aComponent));
            }
            if (languageControlled.equals("NT")) {
                return true;
            }
            if (languageControlled.equals("NA")) {
                return false;
            }
        } else if (aComponent instanceof Translatable) {
            new TranslatableLanguageHandler(aComponent);
        } else if (aComponent instanceof JButton) {
            new AbstractButtonLanguageHandler(aComponent);
        } else if (aComponent instanceof JColorChooser) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JComboBox) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JFileChooser) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JLabel) {
            new JLabelLanguageHandler(aComponent);
        } else if (aComponent instanceof JList) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JMenuBar) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JMenuItem) {
            new JMenuItemLanguageHandler(aComponent);
        } else if (aComponent instanceof JOptionPane) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JPanel) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JPopupMenu) {
            new JPopupMenuLanguageHandler(aComponent);
        } else if (aComponent instanceof JPopupMenu.Separator) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JProgressBar) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JScrollBar) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JScrollPane) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JSeparator) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JSlider) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JSplitPane) {
            new JComponentLanguageHandler(aComponent);
        } else if (aComponent instanceof JTabbedPane) {
            new JTabbedPaneLanguageHandler(aComponent);
        } else {
            if (aComponent instanceof JTable) {
                new JTableLanguageHandler(aComponent);
                return false;
            }
            if (aComponent instanceof JTextComponent) {
                new JTextComponentLanguageHandler(aComponent);
            } else if (aComponent instanceof JToggleButton) {
                new AbstractButtonLanguageHandler(aComponent);
            } else if (aComponent instanceof JToolBar) {
                new JComponentLanguageHandler(aComponent);
            } else if (aComponent instanceof JToolBar.Separator) {
                new JComponentLanguageHandler(aComponent);
            } else if (aComponent instanceof JToolTip) {
                new JComponentLanguageHandler(aComponent);
            } else if (aComponent instanceof JViewport) {
                new JComponentLanguageHandler(aComponent);
            } else if (aComponent instanceof AbstractButton) {
                new AbstractButtonLanguageHandler(aComponent);
            } else if (!(aComponent instanceof JRootPane)) {
                if (aComponent instanceof JLayeredPane) {
                    new JComponentLanguageHandler(aComponent);
                } else if (aComponent instanceof JSplitPane) {
                    new JComponentLanguageHandler(aComponent);
                } else {
                    if (aComponent instanceof JTree) {
                        new JComponentLanguageHandler(aComponent);
                        return false;
                    }
                    if (!(aComponent instanceof JTableHeader)) {
                        if (aComponent instanceof JComponent) {
                            new JComponentLanguageHandler(aComponent);
                            return false;
                        }
                        new JComponentLanguageHandler(aComponent);
                        Log.logWarning("Unknown component " + aComponent.getClass());
                    }
                }
            }
        }
        return true;
    }

    private ResourceBundle getBundle(String bundleName) {
        ResourceBundle bundle = null;
        if (bundleName != null) {
            Log.assertion(!bundleName.equals(""), "Not allowed to specify empty string as bundle name");
            try {
                bundle = GuilibResourceBundle.getBundle(bundleName, this.locale, this.getClass().getClassLoader());
            }
            catch (Throwable t) {
                String msg = "Could not load bundle named: " + bundleName;
                Log.logError(msg, t);
                Log.assertion(false, msg);
            }
        }
        return bundle;
    }

    ResourceBundle getLanguageBundle() {
        return this.languageBundle;
    }

    private Character getMnemonic(String str) {
        Character amp = null;
        int ampIndex = str.indexOf(38);
        if (ampIndex != -1) {
            amp = new Character(str.charAt(ampIndex + 1));
        }
        return amp;
    }

    String getString(String key, boolean strip) {
        Log.trace("LanguageManager.getString(): key    = " + key);
        String str = this.lookupString(this.languageBundle, key);
        if (str == null) {
            str = "UNRESOLVED MESSAGE: " + key;
        }
        if (strip) {
            str = this.stripString(str);
        }
        Log.trace("LanguageManager.getString(): string = " + str);
        return str;
    }

    ResourceBundle getToolTipBundle() {
        return this.toolTipBundle;
    }

    private String getToolTipString(String key) {
        if (key.startsWith("[")) {
            return key;
        }
        String str = this.lookupString(this.toolTipBundle, key);
        if (str == null) {
            str = "UNRESOLVED MESSAGE: " + key;
        }
        return str;
    }

    public void init() {
        uiLanguageHandler = new UILanguageHandler();
        this.locale = this.getApplication().getLocale();
        Properties environment = this.getApplication().getEnvironment();
        Resources resources = this.getResources();
        Log.measure("getBundles", true, "LanguageManager.getBundles in init()");
        this.languageBundle = new ResourceBundleDelegator();
        this.addBundle(environment.getProperty(DEFAULT_LANGUAGE_BUNDLE_NAME_KEY), this.languageBundle);
        this.addBundle(environment.getProperty(SYSTEM_LANGUAGE_BUNDLE_NAME_KEY), this.languageBundle);
        this.addBundle(resources.getLanguageBundleName(), this.languageBundle);
        this.toolTipBundle = new ResourceBundleDelegator();
        this.addBundle(environment.getProperty(DEFAULT_TOOLTIP_BUNDLE_NAME_KEY), this.toolTipBundle);
        this.addBundle(environment.getProperty(SYSTEM_TOOLTIP_BUNDLE_NAME_KEY), this.toolTipBundle);
        this.addBundle(resources.getToolTipBundleName(), this.toolTipBundle);
        this.uiStrings = null;
        this.uiMnemonics = null;
        if (!this.locale.equals(EMPTY_LOCALE) && !this.locale.getLanguage().equals(new Locale("en", "", "").getLanguage())) {
            this.uiStrings = this.getBundle(environment.getProperty(UI_STRINGS_BUNDLE_NAME_KEY));
            this.uiMnemonics = this.getBundle(environment.getProperty(UI_MNEMONICS_BUNDLE_NAME_KEY));
        }
        Log.measure("getBundles", false);
    }

    private String lookupString(ResourceBundle bundle, String key) {
        String str = null;
        try {
            str = bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return str;
    }

    private String stripString(String str) {
        int ctrlIndex = str.lastIndexOf(124);
        String tmpStr = str;
        if (ctrlIndex != -1) {
            tmpStr = str.substring(0, ctrlIndex);
        }
        String tmpStr2 = tmpStr;
        int ampIndex = tmpStr.indexOf(38);
        if (ampIndex != -1) {
            char amp = tmpStr.charAt(ampIndex + 1);
        }
        tmpStr2 = "";
        if (ampIndex > 0) {
            tmpStr2 = tmpStr.substring(0, ampIndex);
        }
        if (tmpStr.length() > ampIndex + 1) {
            tmpStr2 = tmpStr2 + tmpStr.substring(ampIndex + 1);
        }
        return tmpStr2;
    }

    void stripShortCut(boolean stripShortcut) {
        this.stripShortcut = stripShortcut;
    }

    public void updateLocale(Locale locale) {
        Log.measure("updateLocale", true, "LanguageManager.updateLocale");
        if (!this.locale.equals(locale)) {
            Log.logNotify("LanguageManager: Locale changed: " + locale);
            this.locale = locale;
            Properties environment = this.getApplication().getEnvironment();
            Resources resources = this.getResources();
            this.languageBundle = new ResourceBundleDelegator();
            this.addBundle(environment.getProperty(DEFAULT_LANGUAGE_BUNDLE_NAME_KEY), this.languageBundle);
            this.addBundle(environment.getProperty(SYSTEM_LANGUAGE_BUNDLE_NAME_KEY), this.languageBundle);
            this.addBundle(resources.getLanguageBundleName(), this.languageBundle);
            this.toolTipBundle = new ResourceBundleDelegator();
            this.addBundle(environment.getProperty(DEFAULT_TOOLTIP_BUNDLE_NAME_KEY), this.toolTipBundle);
            this.addBundle(environment.getProperty(SYSTEM_TOOLTIP_BUNDLE_NAME_KEY), this.toolTipBundle);
            this.addBundle(resources.getToolTipBundleName(), this.toolTipBundle);
            this.uiStrings = null;
            this.uiMnemonics = null;
            if (!locale.equals(EMPTY_LOCALE) && !locale.getLanguage().equals(new Locale("en", "", "").getLanguage())) {
                this.uiStrings = this.getBundle(environment.getProperty(UI_STRINGS_BUNDLE_NAME_KEY));
                this.uiMnemonics = this.getBundle(environment.getProperty(UI_MNEMONICS_BUNDLE_NAME_KEY));
            }
        }
        Log.logNotify("LanguageManager: Updating language on components");
        for (int i = 0; i < this.languageComponents.size(); ++i) {
            ((AbstractLanguageHandler)this.languageComponents.elementAt(i)).updateLanguage();
        }
        Log.measure("updateLocale", false);
    }

    private class JMenuItemLanguageHandler
    extends AbstractButtonLanguageHandler {
        public JMenuItemLanguageHandler(JComponent aComponent) {
            super(aComponent);
        }

        public void updateLanguage() {
            String label;
            int ctrlIndex;
            if (this.labelKey != null && this.labelKey != "" && !(this.myComponent instanceof JMenu) && (ctrlIndex = (label = LanguageManager.this.getString(this.labelKey, false)).lastIndexOf(124)) != -1) {
                String tmpLabel = label.substring(ctrlIndex + 1);
                if (!LanguageManager.this.stripShortcut) {
                    ((JMenuItem)this.myComponent).setAccelerator(KeyStroke.getKeyStroke(tmpLabel));
                }
            }
            super.updateLanguage();
        }
    }

    private class JLabelLanguageHandler
    extends JComponentLanguageHandler {
        private String labelKey;

        public JLabelLanguageHandler(JComponent aComponent) {
            super(aComponent);
            this.labelKey = ((JLabel)this.myComponent).getText();
            if (this.labelKey == null) {
                Log.logWarning("JLabelLanguageHandler Text is missing!");
            }
        }

        public void updateLanguage() {
            if (this.labelKey != null && this.labelKey != "") {
                String label = LanguageManager.this.getString(this.labelKey, false);
                Character amp = LanguageManager.this.getMnemonic(label);
                if (amp != null) {
                    ((JLabel)this.myComponent).setDisplayedMnemonic(amp.charValue());
                }
                ((JLabel)this.myComponent).setText(LanguageManager.this.stripString(label));
            }
            super.updateLanguage();
        }
    }

    private class JPopupMenuLanguageHandler
    extends JComponentLanguageHandler {
        private String labelKey;

        public JPopupMenuLanguageHandler(JComponent aComponent) {
            super(aComponent);
            this.labelKey = ((JPopupMenu)this.myComponent).getLabel();
        }

        public void updateLanguage() {
            if (this.labelKey != null) {
                ((JPopupMenu)this.myComponent).setLabel(LanguageManager.this.getString(this.labelKey, true));
            }
            super.updateLanguage();
        }
    }

    private class JTableLanguageHandler
    extends JComponentLanguageHandler
    implements PropertyChangeListener {
        private Object[][] labelKeys;
        private Object[][] headerToolTipKeys;
        private Object[][] columnToolTipKeys;
        private Vector columnGroups;

        public JTableLanguageHandler(JComponent aComponent) {
            super(aComponent);
            this.columnGroups = null;
            this.init();
            aComponent.addPropertyChangeListener(this);
            LanguageManager.this.languageComponents.addElement(this);
        }

        private void init() {
            JTableHeader tableHeader = ((JTable)this.myComponent).getTableHeader();
            if (tableHeader != null) {
                TableColumnModel columnModel = tableHeader.getColumnModel();
                this.labelKeys = new Object[columnModel.getColumnCount()][2];
                this.headerToolTipKeys = new Object[columnModel.getColumnCount()][2];
                this.columnToolTipKeys = new Object[columnModel.getColumnCount()][2];
                for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                    TableColumn column = columnModel.getColumn(i);
                    this.labelKeys[i][0] = column;
                    this.labelKeys[i][1] = column.getHeaderValue().toString();
                    TableCellRenderer headerRenderer = column.getHeaderRenderer();
                    if (headerRenderer instanceof JComponent) {
                        this.headerToolTipKeys[i][0] = headerRenderer;
                        this.headerToolTipKeys[i][1] = ((JComponent)((Object)headerRenderer)).getToolTipText();
                    } else {
                        this.headerToolTipKeys[i][0] = null;
                        this.headerToolTipKeys[i][1] = null;
                    }
                    TableCellRenderer columnRenderer = column.getCellRenderer();
                    if (columnRenderer instanceof JComponent) {
                        this.columnToolTipKeys[i][0] = columnRenderer;
                        this.columnToolTipKeys[i][1] = ((JComponent)((Object)columnRenderer)).getToolTipText();
                    } else {
                        this.columnToolTipKeys[i][0] = null;
                        this.columnToolTipKeys[i][1] = null;
                    }
                    if (!(tableHeader instanceof GroupableTableHeader)) continue;
                    this.columnGroups = ((GroupableTableHeader)tableHeader).getAllColumnGroups();
                }
            }
        }

        public void updateLanguage() {
            if (this.labelKeys != null) {
                for (int i = 0; i < this.labelKeys.length; ++i) {
                    ((TableColumn)this.labelKeys[i][0]).setHeaderValue(LanguageManager.this.getString((String)this.labelKeys[i][1], true));
                    if (this.headerToolTipKeys[i][1] != null) {
                        ((JComponent)this.headerToolTipKeys[i][0]).setToolTipText(LanguageManager.this.getToolTipString((String)this.headerToolTipKeys[i][1]));
                    }
                    if (this.columnToolTipKeys[i][1] != null) {
                        ((JComponent)this.columnToolTipKeys[i][0]).setToolTipText(LanguageManager.this.getToolTipString((String)this.columnToolTipKeys[i][1]));
                    }
                    if (this.columnGroups == null) continue;
                    for (int j = 0; j < this.columnGroups.size(); ++j) {
                        ColumnGroup cg = (ColumnGroup)this.columnGroups.elementAt(j);
                        cg.setHeaderValue(LanguageManager.this.getString(cg.getHeaderKey(), true));
                    }
                }
            }
            super.updateLanguage();
        }

        public void dispose() {
            this.myComponent.removePropertyChangeListener(this);
            super.dispose();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("model")) {
                this.init();
                this.updateLanguage();
                this.myComponent.revalidate();
                this.myComponent.repaint();
            }
        }
    }

    private class JTextComponentLanguageHandler
    extends JComponentLanguageHandler {
        public JTextComponentLanguageHandler(JComponent aComponent) {
            super(aComponent);
            MenuToolbarHandler menuTBHandler = LanguageManager.this.getApplication().getApplicationPresenter().getMenuToolBarHandler();
            if (menuTBHandler != null) {
                Action[] editActions = menuTBHandler.getApplicationDefaultView().getEditActions();
                new EditListeners(editActions, (JTextComponent)this.myComponent);
            }
        }
    }

    private class JTabbedPaneLanguageHandler
    extends JComponentLanguageHandler {
        private String[] labelKeys;

        public JTabbedPaneLanguageHandler(JComponent aComponent) {
            super(aComponent);
            JTabbedPane tabbedPane = (JTabbedPane)aComponent;
            this.labelKeys = new String[tabbedPane.getTabCount()];
            for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                this.labelKeys[i] = tabbedPane.getTitleAt(i);
            }
            LanguageManager.this.languageComponents.addElement(this);
        }

        public void updateLanguage() {
            for (int i = 0; i < this.labelKeys.length; ++i) {
                ((JTabbedPane)this.myComponent).setTitleAt(i, LanguageManager.this.getString(this.labelKeys[i], true));
            }
            super.updateLanguage();
        }
    }

    private class AbstractButtonLanguageHandler
    extends JComponentLanguageHandler {
        protected String labelKey;

        public AbstractButtonLanguageHandler(JComponent aComponent) {
            super(aComponent);
            AbstractButton button = (AbstractButton)this.myComponent;
            this.labelKey = button.getText();
            String key = (String)button.getClientProperty(LanguageManager.KEY);
            if (key == null) {
                button.putClientProperty(LanguageManager.KEY, this.labelKey);
            } else {
                this.labelKey = key;
            }
        }

        public void updateLanguage() {
            if (this.labelKey != null && this.labelKey != "") {
                String label = LanguageManager.this.getString(this.labelKey, false);
                Character amp = LanguageManager.this.getMnemonic(label);
                if (amp != null) {
                    ((AbstractButton)this.myComponent).setMnemonic(amp.charValue());
                }
                ((AbstractButton)this.myComponent).setText(LanguageManager.this.stripString(label));
            }
            super.updateLanguage();
        }
    }

    private class TranslatableLanguageHandler
    extends JComponentLanguageHandler {
        public TranslatableLanguageHandler(JComponent aComponent) {
            super(aComponent);
        }

        public void updateLanguage() {
            ((Translatable)((Object)this.myComponent)).translate(LanguageManager.this.languageBundle, LanguageManager.this.locale);
            super.updateLanguage();
        }
    }

    private class JComponentLanguageHandler
    extends AbstractLanguageHandler {
        private String toolTipKey;
        private String borderTitleKey;
        protected JComponent myComponent;

        public JComponentLanguageHandler(JComponent aComponent) {
            this.myComponent = aComponent;
            this.toolTipKey = this.myComponent.getToolTipText();
            TitledBorder titledBorder = this.findTitledBorder(this.myComponent.getBorder());
            if (titledBorder != null) {
                this.borderTitleKey = titledBorder.getTitle();
            }
            LanguageManager.this.languageComponents.addElement(this);
        }

        private TitledBorder findTitledBorder(Border border) {
            TitledBorder titledBorder = null;
            if (border != null) {
                if (border instanceof TitledBorder) {
                    titledBorder = (TitledBorder)border;
                } else if (border instanceof CompoundBorder && (titledBorder = this.findTitledBorder(((CompoundBorder)border).getOutsideBorder())) == null) {
                    titledBorder = this.findTitledBorder(((CompoundBorder)border).getInsideBorder());
                }
            }
            return titledBorder;
        }

        public void updateLanguage() {
            TitledBorder titledBorder;
            if (this.toolTipKey != null) {
                if (this.myComponent instanceof JMenuItem) {
                    AbstractButton button = (AbstractButton)this.myComponent;
                    String key = (String)button.getClientProperty(LanguageManager.TOOLTIPKEY);
                    if (key == null) {
                        button.putClientProperty(LanguageManager.TOOLTIPKEY, this.toolTipKey);
                    } else {
                        this.toolTipKey = key;
                    }
                }
                this.myComponent.setToolTipText(LanguageManager.this.getToolTipString(this.toolTipKey));
            }
            if (this.borderTitleKey != null && (titledBorder = this.findTitledBorder(this.myComponent.getBorder())) != null) {
                if (titledBorder instanceof Translatable) {
                    ((Translatable)((Object)titledBorder)).translate(LanguageManager.this.languageBundle, LanguageManager.this.locale);
                } else {
                    titledBorder.setTitle(LanguageManager.this.getString(this.borderTitleKey, true));
                }
            }
            this.myComponent.revalidate();
            this.myComponent.repaint();
        }
    }

    private class UILanguageHandler
    extends AbstractLanguageHandler {
        Hashtable savedUIDefaults;

        public UILanguageHandler() {
            LanguageManager.this.languageComponents.addElement(this);
        }

        public void updateLanguage() {
            if (LanguageManager.this.uiStrings != null) {
                boolean save;
                boolean bl = save = this.savedUIDefaults == null;
                if (save) {
                    this.savedUIDefaults = new Hashtable();
                }
                this.updateUIStrings(save);
                this.updateUIMnemonics(save);
            } else if (this.savedUIDefaults != null) {
                this.updateUIDefaults();
            }
        }

        private void updateUIDefaults() {
            UIDefaults defaults = UIManager.getDefaults();
            Enumeration keys = defaults.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                defaults.put(key, this.savedUIDefaults.get(key));
            }
        }

        private void updateUIStrings(boolean save) {
            UIDefaults defaults = UIManager.getDefaults();
            Enumeration<String> stringKeys = LanguageManager.this.uiStrings.getKeys();
            while (stringKeys.hasMoreElements()) {
                String key = stringKeys.nextElement();
                String keyString = LanguageManager.this.uiStrings.getString(key);
                if (keyString != null) {
                    Object value;
                    if (save && (value = defaults.get(key)) != null) {
                        this.savedUIDefaults.put(key, value);
                    }
                    defaults.put(key, keyString);
                    continue;
                }
                Log.logNotify("UILanguageHandler.updateStrings. Key string not found for: " + key);
            }
        }

        private void updateUIMnemonics(boolean save) {
            UIDefaults defaults = UIManager.getDefaults();
            Enumeration<String> mnemonicKeys = LanguageManager.this.uiMnemonics.getKeys();
            while (mnemonicKeys.hasMoreElements()) {
                String key = mnemonicKeys.nextElement();
                String keyString = LanguageManager.this.uiMnemonics.getString(key);
                if (keyString != null) {
                    Object value;
                    if (save && (value = defaults.get(key)) != null) {
                        this.savedUIDefaults.put(key, value);
                    }
                    defaults.put(key, new Integer(KeyStroke.getKeyStroke(keyString).getKeyCode()));
                    continue;
                }
                Log.logNotify("UILanguageHandler.updateMnemonics. Key string not found for: " + key);
            }
        }
    }

    private abstract class AbstractLanguageHandler {
        private AbstractLanguageHandler() {
        }

        public abstract void updateLanguage();

        public void dispose() {
        }
    }
}

