/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class PrintoutImpl
implements Printable {
    private Component component;
    private String title;
    private Vector tableHeaders = new Vector();
    private ArrayList firstLines;
    private int n_Col = 0;
    private int n_Row = 0;
    private int[] columnPositions;
    private int y_position = 0;
    private int wPage = 0;
    private int hPage = 0;
    private boolean printDetailsPane = false;
    Font headerFont = new Font("TimesRoman", 1, 9);
    Font titleFont = new Font("TimesRoman", 1, 14);
    Font tableFont = new Font("Courier", 0, 9);
    Object[] arrayToPrint;
    private static PrinterJob printerJob = PrinterJob.getPrinterJob();
    private static PageFormat pageFormat = printerJob.defaultPage();
    private boolean firstTimePrintInterfaceCalled = true;

    public PrintoutImpl(Component component, String title) {
        this.component = component;
        this.title = title;
        pageFormat.setOrientation(0);
    }

    private void setPageSize(PageFormat pageFormat, int headerHeight) {
        this.wPage = (int)pageFormat.getImageableWidth();
        this.hPage = (int)pageFormat.getImageableHeight() - headerHeight - 100;
    }

    public void changeComponent(Component newComponent) {
        this.component = newComponent;
    }

    public void setPrintDetailsPane(boolean printFromDetailsPane) {
        this.printDetailsPane = printFromDetailsPane;
    }

    public void pageLayout() {
        pageFormat.setOrientation(0);
        pageFormat = printerJob.pageDialog(pageFormat);
    }

    public void print() {
        printerJob.setPrintable(this, pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            return;
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.printDetailsPane) {
            int result = this.printDetailsPane(g, pageIndex, pageFormat);
            if (result == 1) {
                this.printDetailsPane = false;
            }
            return result;
        }
        if (this.component instanceof JTable) {
            boolean bool;
            JTable table = (JTable)this.component;
            int headerHeight = this.calculateHeaderHeight(g);
            if (this.firstTimePrintInterfaceCalled) {
                this.setPageSize(pageFormat, headerHeight);
                TableColumnModel colModel = table.getColumnModel();
                this.n_Col = colModel.getColumnCount();
                this.n_Row = table.getRowCount();
                g.setFont(this.headerFont);
                this.createTableHeaderVector(g, table);
                g.setFont(this.tableFont);
                this.firstLines = new ArrayList();
                this.createTableVector(g, table);
                this.arrayToPrint = this.firstLines.toArray();
            }
            g.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            this.y_position = 0;
            this.y_position = this.printTitle(g, this.y_position, table, pageIndex);
            if (this.firstTimePrintInterfaceCalled) {
                this.firstTimePrintInterfaceCalled = false;
            }
            if (bool = this.print(g, pageIndex, table)) {
                return 0;
            }
            this.firstTimePrintInterfaceCalled = true;
            return 1;
        }
        return this.printOther(g, pageIndex, pageFormat);
    }

    public void setTitle(String aTitle) {
        this.title = aTitle;
    }

    private int printTitle(Graphics g, int y_position, JTable table, int pageIndex) {
        g.setFont(this.titleFont);
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        g.drawString(this.title, 10, y_position += fm.getAscent());
        int x_pos = fm.charsWidth(this.title.toCharArray(), 0, this.title.length()) + 30;
        Font pageFont = new Font("TimesRoman", 0, 12);
        g.setFont(this.headerFont);
        g.drawString("page " + (pageIndex + 1), x_pos, y_position);
        return y_position += 20;
    }

    private int calculateHeaderHeight(Graphics g) {
        int headerHeight = 0;
        g.setFont(this.titleFont);
        headerHeight = g.getFontMetrics().getHeight();
        g.setFont(this.headerFont);
        headerHeight = headerHeight + g.getFontMetrics().getHeight() + 25;
        return headerHeight;
    }

    private int printDetailsPane(Graphics g, int pageIndex, PageFormat pageFormat) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(Color.black);
        int fontHeight = g2D.getFontMetrics().getHeight();
        int fontDescent = g2D.getFontMetrics().getDescent();
        double pageHigh = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWid = pageFormat.getImageableWidth();
        JTable table = (JTable)this.component;
        double tableWid = table.getColumnModel().getTotalColumnWidth();
        double scale = 1.0;
        if (tableWid >= pageWid) {
            scale = pageWid / tableWid;
        }
        double headerHighOnPage = (double)table.getTableHeader().getHeight() * scale;
        double tableWidOnPage = tableWid * scale;
        double oneRowHigh = (double)(table.getRowHeight() + table.getRowMargin()) * scale;
        int numOfRowsOnAPage = (int)((pageHigh - headerHighOnPage) / oneRowHigh);
        double pageHighForTable = oneRowHigh * (double)numOfRowsOnAPage;
        int totalNumPage = (int)Math.ceil((double)table.getRowCount() / (double)numOfRowsOnAPage);
        if (pageIndex >= totalNumPage) {
            return 1;
        }
        g2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2D.setFont(new Font("TimesRoman", 1, 24));
        g2D.drawString(this.title, 0, -10);
        g2D.setFont(new Font("TimesRoman", 1, 12));
        g2D.drawString("Page: " + (pageIndex + 1), (int)pageWid / 2 - 35, (int)(pageHigh + (double)fontHeight - (double)fontDescent));
        g2D.translate(0.0, headerHighOnPage);
        g2D.translate(0.0, (double)(-pageIndex) * pageHighForTable);
        this.setBounds(pageIndex, totalNumPage, numOfRowsOnAPage, table, g2D, pageHighForTable, tableWidOnPage, oneRowHigh);
        g2D.scale(scale, scale);
        table.paint(g2D);
        g2D.scale(1.0 / scale, 1.0 / scale);
        g2D.translate(0.0, (double)pageIndex * pageHighForTable);
        g2D.translate(0.0, -headerHighOnPage);
        g2D.setClip(0, 0, (int)Math.ceil(tableWidOnPage), (int)Math.ceil(headerHighOnPage));
        g2D.scale(scale, scale);
        table.getTableHeader().paint(g2D);
        return 0;
    }

    private void setBounds(int pageIndex, int totalNumPage, int numOfRowsOnAPage, JTable table, Graphics2D g2D, double pageHighForTable, double tableWidOnPage, double oneRowHigh) {
        if (pageIndex + 1 == totalNumPage) {
            int lastRowToPrinted = numOfRowsOnAPage * pageIndex;
            int numOfRowsLeft = table.getRowCount() - lastRowToPrinted;
            g2D.setClip(0, (int)(pageHighForTable * (double)pageIndex), (int)Math.ceil(tableWidOnPage), (int)Math.ceil(oneRowHigh * (double)numOfRowsLeft));
        } else {
            g2D.setClip(0, (int)(pageHighForTable * (double)pageIndex), (int)Math.ceil(tableWidOnPage), (int)Math.ceil(pageHighForTable));
        }
    }

    private int printOther(Graphics g, int pageIndex, PageFormat pageFormat) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (pageIndex >= 1) {
            return 1;
        }
        g2.setFont(new Font("TimesRoman", 1, 24));
        g2.drawString(this.title, 0, 0);
        int fontHeight = g2.getFontMetrics().getHeight();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight + 20.0;
        double pageWid = pageFormat.getImageableWidth();
        double scale = Math.min(pageWid / (double)this.component.getWidth(), pageHeight / (double)this.component.getHeight());
        if (scale > 1.0) {
            scale = 1.0;
        }
        g2.scale(scale, scale);
        g2.setClip(0, 0, this.component.getWidth(), this.component.getHeight());
        this.component.paint(g2);
        g2.drawRect(0, 0, this.component.getWidth() - 1, this.component.getHeight() - 1);
        return 0;
    }

    public boolean print(Graphics g, int pageIndex, JTable table) {
        int spaceBetwRows = 1;
        g.setFont(this.headerFont);
        for (int i = 0; i < this.tableHeaders.size(); ++i) {
            Object tmpObj = this.tableHeaders.get(i);
            Cell cell = (Cell)tmpObj;
            cell.print(g, this.y_position);
        }
        g.setFont(this.tableFont);
        int header = this.y_position;
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getHeight();
        int ascent = fm.getAscent();
        int rowH = h;
        int rowPerPage = (this.hPage - header) / rowH;
        int m_maxNumPage = Math.max((int)Math.ceil((double)this.firstLines.size() / (double)rowPerPage), 1);
        if (pageIndex >= m_maxNumPage) {
            this.firstLines.clear();
            this.tableHeaders.removeAllElements();
            return false;
        }
        TableModel tblModel = table.getModel();
        int iniRow = pageIndex * rowPerPage;
        int endRow = iniRow + rowPerPage - 1;
        int rowToPrint = iniRow;
        this.y_position += ascent;
        for (int firstLineIndex = iniRow; rowToPrint <= endRow && firstLineIndex < this.firstLines.size(); ++rowToPrint, ++firstLineIndex) {
            this.y_position += rowH;
            Object tmpObj = this.arrayToPrint[rowToPrint];
            Line line = (Line)tmpObj;
            if (line.getFirstLine()) {
                this.y_position += 5;
            }
            line.print(g, this.y_position);
            this.y_position = spaceBetwRows + this.y_position;
        }
        return true;
    }

    public void createTableHeaderVector(Graphics g, JTable table) {
        FontMetrics fm = g.getFontMetrics();
        int[] x = new int[this.n_Col];
        this.columnPositions = new int[this.n_Col];
        x[0] = 0;
        this.columnPositions[0] = 20;
        boolean tmpRow = false;
        int tmpCol = 0;
        for (tmpCol = 0; tmpCol < this.n_Col; ++tmpCol) {
            Cell tmpCell;
            TableColumnModel colModel = table.getColumnModel();
            TableColumn tk = colModel.getColumn(tmpCol);
            String title = (String)tk.getIdentifier();
            int columnWidth = tk.getWidth();
            int width = fm.charsWidth(title.toCharArray(), 0, title.length()) + 25;
            if (columnWidth > 0) {
                if (this.columnPositions[tmpCol] + width > this.wPage) {
                    this.n_Col = tmpCol;
                    break;
                }
                if (tmpCol + 1 < this.n_Col) {
                    this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + width;
                }
                if (title.equalsIgnoreCase("Time") || title.equalsIgnoreCase("Date")) {
                    String str = new String("0000000000000000");
                    width = fm.charsWidth(str.toCharArray(), 0, 16);
                    this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + width;
                } else if (title.equals("MO Instance") || title.equalsIgnoreCase("Alarm ID")) {
                    this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + 2 * width;
                } else if (title.length() < 5 && tmpCol + 1 != this.n_Col) {
                    this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + 2 * width;
                }
                tmpCell = new Cell(title, this.columnPositions[tmpCol]);
                this.tableHeaders.addElement(tmpCell);
                continue;
            }
            this.columnPositions[tmpCol] = this.columnPositions[tmpCol - 1];
            tmpCell = new Cell(title, 0);
            this.tableHeaders.addElement(tmpCell);
            TableColumn tk1 = colModel.getColumn(tmpCol - 1);
            String title1 = (String)tk1.getIdentifier();
            int width1 = fm.charsWidth(title1.toCharArray(), 0, title1.length()) + 10;
            if (tmpCol + 1 >= this.n_Col) continue;
            this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + width1;
        }
    }

    public void createTableVector(Graphics g, JTable table) {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int tmpRow = 0; tmpRow < this.n_Row; ++tmpRow) {
            Line firstLine = new Line(this.n_Col);
            lines.add(firstLine);
            for (int tmpCol = 0; tmpCol < this.n_Col; ++tmpCol) {
                FontMetrics fm;
                int stringWidth;
                long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                int cellWidth = 0;
                cellWidth = tmpCol + 1 < this.n_Col ? this.columnPositions[tmpCol + 1] - this.columnPositions[tmpCol] - 10 : this.wPage - this.columnPositions[tmpCol] - 10;
                String content = table.getValueAt(tmpRow, tmpCol).toString();
                if (null == content) {
                    content = "";
                }
                if ((stringWidth = (fm = g.getFontMetrics()).charsWidth(content.toCharArray(), 0, content.length())) <= cellWidth) {
                    Cell tmpCell = new Cell(content, this.columnPositions[tmpCol]);
                    firstLine.addCell(tmpCell, tmpCol);
                    continue;
                }
                int noOfCharsInOneRow = Math.abs(cellWidth / fm.charWidth('0'));
                boolean notTheEnd = true;
                int startOfSubstring = 0;
                int subLineIndex = 1;
                String restOfContent = content;
                boolean firstPart = true;
                String partOfContent = content;
                while (notTheEnd && content.length() >= 0) {
                    if (restOfContent.length() > noOfCharsInOneRow) {
                        int indexOfSpace;
                        int tmpIndexOfSpace = indexOfSpace = restOfContent.indexOf(32);
                        while (restOfContent.indexOf(32, tmpIndexOfSpace + 1) < noOfCharsInOneRow && indexOfSpace >= 0) {
                            indexOfSpace = restOfContent.indexOf(32, tmpIndexOfSpace + 1);
                            if (indexOfSpace > noOfCharsInOneRow || indexOfSpace < 0) continue;
                            tmpIndexOfSpace = indexOfSpace;
                        }
                        indexOfSpace = tmpIndexOfSpace;
                        if (indexOfSpace <= noOfCharsInOneRow && indexOfSpace >= 0) {
                            partOfContent = content.substring(startOfSubstring, startOfSubstring + indexOfSpace);
                            startOfSubstring = startOfSubstring + indexOfSpace + 1;
                        } else {
                            partOfContent = content.length() - startOfSubstring <= noOfCharsInOneRow ? content.substring(startOfSubstring, content.length()) : content.substring(startOfSubstring, startOfSubstring + noOfCharsInOneRow);
                            startOfSubstring += noOfCharsInOneRow;
                        }
                    } else {
                        notTheEnd = false;
                        partOfContent = restOfContent;
                    }
                    Cell tmpCell = new Cell(partOfContent, this.columnPositions[tmpCol]);
                    if (firstPart) {
                        firstLine.addCell(tmpCell, tmpCol);
                        firstLine.setFirstLine(true);
                        firstPart = false;
                    } else {
                        if (subLineIndex < lines.size()) {
                            Object tmpObj = lines.get(subLineIndex);
                            Line line = (Line)tmpObj;
                            line.addCell(tmpCell, tmpCol);
                        } else {
                            Line subLine = new Line(this.n_Col);
                            subLine.addCell(tmpCell, tmpCol);
                            lines.add(subLine);
                        }
                        ++subLineIndex;
                    }
                    if (startOfSubstring >= content.length()) {
                        notTheEnd = false;
                        continue;
                    }
                    restOfContent = content.substring(startOfSubstring, content.length());
                }
            }
            for (int n = 0; n < lines.size(); ++n) {
                this.firstLines.add(lines.get(n));
            }
            lines.clear();
        }
    }

    public class Cell {
        private String theString = null;
        private int X_pos = 0;

        public Cell(String aString, int xPosition) {
            this.theString = aString;
            this.X_pos = xPosition;
        }

        public void print(Graphics g, int aY_pos) {
            if (this.X_pos != 0) {
                g.drawString(this.theString, this.X_pos, aY_pos);
            }
        }
    }

    public class Line {
        private Cell[] theLine;
        private boolean isFirstLine = false;
        private int theNoOfCells = 0;

        public Line(int noOfCells) {
            this.theLine = new Cell[noOfCells];
            this.theNoOfCells = noOfCells;
            Cell emptyCell = new Cell("", 0);
            for (int i = 0; i < noOfCells; ++i) {
                this.theLine[i] = emptyCell;
            }
        }

        public void addCell(Cell aCell, int index) {
            this.theLine[index] = aCell;
        }

        public void setFirstLine(boolean firstLine) {
            this.isFirstLine = firstLine;
        }

        public boolean getFirstLine() {
            return this.isFirstLine;
        }

        public void print(Graphics g, int y_position) {
            for (int i = 0; i < this.theNoOfCells; ++i) {
                this.theLine[i].print(g, y_position);
            }
        }
    }
}

