/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.LogRecord;

public abstract class Formatter {
    protected Formatter() {
    }

    public abstract String format(LogRecord var1);

    public String getHead(Handler handler) {
        return "";
    }

    public String getTail(Handler handler) {
        return "";
    }

    private String getFormatMessage(LogRecord logRecord, String formatMessage) {
        ResourceBundle catalogObject = logRecord.getResourceBundle();
        if (catalogObject != null) {
            try {
                String message = logRecord.getMessage();
                formatMessage = catalogObject.getString(message);
            }
            catch (MissingResourceException ex) {
                formatMessage = logRecord.getMessage();
            }
        }
        return formatMessage;
    }

    private String returnFormatMessage(LogRecord logRecord, String formatMessage) {
        try {
            Object[] recordParameters = logRecord.getParameters();
            if (recordParameters == null || recordParameters.length == 0) {
                return formatMessage;
            }
            if (formatMessage.indexOf("{0") >= 0) {
                return MessageFormat.format(formatMessage, recordParameters);
            }
            return formatMessage;
        }
        catch (Exception exc) {
            return formatMessage;
        }
    }

    public synchronized String formatMessage(LogRecord logRecord) {
        String formatMessage = logRecord.getMessage();
        formatMessage = this.getFormatMessage(logRecord, formatMessage);
        return this.returnFormatMessage(logRecord, formatMessage);
    }
}

