/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.Serializable;
import java.util.ArrayList;

public class Level
implements Serializable {
    private static final long serialVersionUID = 5815062377888870558L;
    private static ArrayList known = new ArrayList();
    private final String nameValue;
    private final int valueable;
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level SEVERE = new Level("SEVERE", 1000);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level CONFIG = new Level("CONFIG", 700);
    public static final Level FINE = new Level("FINE", 500);
    public static final Level FINER = new Level("FINER", 400);
    public static final Level FINEST = new Level("FINEST", 300);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Level(String name, int value) {
        this.nameValue = name;
        this.valueable = value;
        Class<Level> clazz = Level.class;
        synchronized (Level.class) {
            known.add(this);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final String toString() {
        return this.nameValue;
    }

    public final int intValue() {
        return this.valueable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class<Level> clazz = Level.class;
        synchronized (Level.class) {
            for (int k = 0; k < known.size(); ++k) {
                Level other = (Level)known.get(k);
                if (!this.nameValue.equals(other.nameValue) || this.valueable != other.valueable) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return other;
            }
            known.add(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this;
        }
    }

    public static synchronized Level parse(String named) throws IllegalArgumentException {
        named.length();
        for (int k = 0; k < known.size(); ++k) {
            Level l = (Level)known.get(k);
            if (!named.equals(l.nameValue)) continue;
            return l;
        }
        try {
            int p = Integer.parseInt(named);
            for (int j = 0; j < known.size(); ++j) {
                Level l = (Level)known.get(j);
                if (l.valueable != p) continue;
                return l;
            }
            return new Level(named, p);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Bad level \"" + named + "\"");
        }
    }

    public boolean equals(Object ox) {
        try {
            Level lox = (Level)ox;
            return lox.valueable == this.valueable;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.valueable;
    }
}

