/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import javax.swing.SwingUtilities;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.mgr.cellomom.CVCurrentDetailedActivity;
import se.ericsson.cello.support.proxy.MOProxy;

public class RestoreConfirm {
    public static MOProxy configurationVersionMo = null;

    public static void restoreConfirmSlideWizard() {
        String memoryFilePathAndName = RestoreConfirm.getMemoryFilePathAndName();
        boolean rightMemoryFileExists = new File(memoryFilePathAndName).exists();
        if (rightMemoryFileExists) {
            if (RestoreConfirm.nodeIsAwaintingRestoreConfirmation()) {
                Runnable restoreConfirm = new Runnable(){

                    public void run() {
                        Object[][] parameters = new Object[][]{{new String("ACTION"), "confirmRestore"}};
                        MainWindowController mainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
                        mainWindowController.startApplication("se.ericsson.cello.emas.sm.applications.RestoreWizardApplication", parameters, false);
                    }
                };
                SwingUtilities.invokeLater(restoreConfirm);
                RestoreConfirm.deleteMemoryfile();
            } else {
                RestoreConfirm.deleteMemoryfile();
            }
        }
    }

    public static void createRestoreMemoryFile() {
        String memoryFilePathAndName = RestoreConfirm.getMemoryFilePathAndName();
        try {
            FileWriter memoryFile = new FileWriter(memoryFilePathAndName);
            PrintWriter printWriter = new PrintWriter(memoryFile);
            printWriter.println("//This file indicates that a restore/forcedRestore action has been executed from the Element Manager");
            printWriter.println("//If the restore/forcedRestore action succeeded then we will have also cvCurrentDetailedActivity == CVCurrentDetailedActivity.AWAITINGRESTORECONFIRMATION in the MOM");
            printWriter.close();
        }
        catch (IOException e) {
            Log.logError("Problems creating the RestoreMemoryFile for EMAS", e);
        }
    }

    public static String getMemoryFilePathAndName() {
        String node_IP_address = RestoreConfirm.get_node_IP_address();
        node_IP_address = node_IP_address.replace('.', '-');
        String memoryFileName = "emasRestoreMemory_" + node_IP_address;
        String memoryfilePath = System.getProperty("user.home") + File.separator;
        String memoryFilePathAndName = memoryfilePath + memoryFileName;
        return memoryFilePathAndName;
    }

    public static String get_node_IP_address() {
        String ipAddress = "";
        URL anUrl = null;
        try {
            String host = EmasSystemProperties.getProperty("host");
            anUrl = new URL("http://" + host);
            String hostWithNoPort = anUrl.getHost();
            Log.logNotify("Url: " + anUrl.toString());
            Log.logNotify("Supplied host: " + host);
            Log.logNotify("RestoreConfirm: hostWithNoPort: " + hostWithNoPort);
            InetAddress ipAddressTmp = InetAddress.getByName(hostWithNoPort);
            ipAddress = ipAddressTmp.getHostAddress();
        }
        catch (Exception e) {
            Log.logError("Problems getting the IP address of the node from the EMAS applet.", e);
        }
        return ipAddress;
    }

    public static boolean nodeIsAwaintingRestoreConfirmation() {
        boolean awaintingRestoreConfirmation = false;
        try {
            configurationVersionMo = RestoreConfirm.getConfigurationVersionMo();
            Integer currentDetailActivityValue = (Integer)configurationVersionMo.getAttribute("currentDetailedActivity");
            CVCurrentDetailedActivity cvCurrentDetailedActivity = CVCurrentDetailedActivity.get(currentDetailActivityValue);
            if (cvCurrentDetailedActivity == CVCurrentDetailedActivity.AWAITING_RESTORE_CONFIRMATION || cvCurrentDetailedActivity == CVCurrentDetailedActivity.INITIATING_CONFIRM_RESTORE_TIME_SUPERVISION) {
                awaintingRestoreConfirmation = true;
            }
        }
        catch (Exception e) {
            Log.logError("Problems getting attribute.", e);
        }
        return awaintingRestoreConfirmation;
    }

    public static void deleteMemoryfile() {
        new File(RestoreConfirm.getMemoryFilePathAndName()).delete();
    }

    public static MOProxy getConfigurationVersionMo() {
        if (configurationVersionMo == null) {
            MOProxy swManagementMo = new MOProxy("ManagedElement=1,SwManagement=1");
            try {
                MOProxy[] moPxyArray = swManagementMo.getChildren(1, "ConfigurationVersion", "");
                configurationVersionMo = new MOProxy(moPxyArray[0].toString());
            }
            catch (Exception e) {
                Log.logError("Problems getting the ConfigurationVersion Managed Object.", e);
            }
        }
        return configurationVersionMo;
    }
}

