/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy.action;

import javax.swing.SwingUtilities;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.UserException;
import org.omg.CosNotification.StructuredEvent;
import org.threegppsa5.AlarmIRPSystem.AlarmInformationIteratorHolder;
import org.threegppsa5.AlarmIRPSystem.GetAlarmList;
import org.threegppsa5.AlarmIRPSystem.InvalidParameter;
import org.threegppsa5.AlarmIRPSystem.ParameterNotSupported;
import org.threegppsa5.AlarmIRPSystem._AlarmIRPOperations;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractCorbaRequest;
import se.ericsson.cello.support.gui.guilib.infra.AbstractRequest;
import se.ericsson.cello.support.proxy.AlarmCorbaInterface;

public class GetAlarmListCorbaCall
extends AbstractCorbaRequest {
    private _AlarmIRPOperations irpRef;
    private int maxAlarms;
    private boolean maxReached = false;
    private boolean nullAlarms = false;
    private StructuredEvent[] al;
    private AlarmCorbaInterface myCorbaInterface;

    public GetAlarmListCorbaCall(_AlarmIRPOperations irpRef, AlarmCorbaInterface corbaInterface, StructuredEvent[] alarmlist, int maxAlarms, int howMany) {
        this.irpRef = irpRef;
        this.al = alarmlist;
        this.maxAlarms = maxAlarms;
        this.myCorbaInterface = corbaInterface;
        this.setBlockMode(AbstractRequest.BLOCK_THIS_APPLICATION);
    }

    protected void invoke() throws UserException {
        AlarmInformationIteratorHolder iter = new AlarmInformationIteratorHolder();
        Thread.currentThread().setPriority(1);
        this.myCorbaInterface.setRetrievingFinished(false);
        iter.value = null;
        BooleanHolder bh = new BooleanHolder();
        bh.value = true;
        StructuredEvent[] local_result = this.irpRef.get_alarm_list("", bh, iter);
        int nrAlarmsReturned = 0;
        this.maxReached = false;
        boolean more = false;
        if (bh.value) {
            nrAlarmsReturned = local_result.length;
            if (nrAlarmsReturned == 0) {
                this.nullAlarms = true;
            } else if (nrAlarmsReturned <= this.maxAlarms) {
                try {
                    SwingUtilities.invokeAndWait(new UpdateListRunnable(local_result));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error calling SwingUtilities.invokeAndWait");
                }
            } else {
                this.maxReached = true;
            }
        }
        this.al = null;
    }

    protected void handleSuccesful() {
        this.myCorbaInterface.setStatus(0);
        this.myCorbaInterface.setRetrievingFinished(true);
        this.myCorbaInterface.processNewAlarmNotifications();
        if (this.nullAlarms) {
            this.myCorbaInterface.setStatus(5);
        }
        if (this.maxReached) {
            this.myCorbaInterface.showErrorDialog(10);
        } else {
            StructuredEvent[] aList = this.al;
            if (aList != null) {
                this.myCorbaInterface.processAlarmList(aList);
            }
        }
    }

    protected boolean handleAllExceptions(Exception e) {
        this.myCorbaInterface.setRetrievingFinished(true);
        return super.handleAllExceptions(e);
    }

    protected boolean handleUserException(UserException ue) {
        this.myCorbaInterface.setRetrievingFinished(true);
        this.myCorbaInterface.processNewAlarmNotifications();
        this.myCorbaInterface.setStatus(0);
        if (ue instanceof GetAlarmList) {
            Log.logError("GetAlarmList", ue);
            this.myCorbaInterface.showErrorDialog(11);
        } else if (ue instanceof ParameterNotSupported) {
            Log.logError("ParameterNotSupported", ue);
            this.myCorbaInterface.showErrorDialog(12);
        } else if (ue instanceof InvalidParameter) {
            Log.logError("InvalidParameter", ue);
            this.myCorbaInterface.showErrorDialog(13);
        } else {
            Log.logError("get_alarm_list unknown errer", ue);
            this.myCorbaInterface.showErrorDialog(14);
        }
        return false;
    }

    public void handleCancelled() {
        this.myCorbaInterface.setStatus(6);
        this.cancel();
    }

    public void cancel() {
        this.myCorbaInterface.setRetrievingFinished(true);
        this.myCorbaInterface.processNewAlarmNotifications();
    }

    class UpdateListRunnable
    implements Runnable {
        private StructuredEvent[] al;

        UpdateListRunnable(StructuredEvent[] al) {
            this.al = al;
        }

        public void run() {
            GetAlarmListCorbaCall.this.myCorbaInterface.processAlarmList(this.al);
        }
    }
}

