/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.file.base;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.DataConnection;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamConnection;

public class Connection
extends DataConnection
implements CreateConnection,
StreamConnection {
    private File file;
    private int access;
    private boolean append = false;

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
        return this;
    }

    private void setParameters(String spec, String[][] equates, int access, boolean timeout) throws IOException {
        int idx = 0;
        if ((spec = Util.decode(spec, false)).startsWith("//")) {
            boolean found = false;
            int length = spec.length();
            idx = 2;
            while (idx < length) {
                char ch = spec.charAt(idx);
                if (ch == '/' || ch == '\\') {
                    found = true;
                    break;
                }
                if (ch == ':' || ch == ' ') break;
                ++idx;
            }
            if (!found) {
                throw new IllegalArgumentException(spec);
            }
        }
        String name = idx == 2 ? spec.substring(2) : spec;
        this.file = new File(name);
        this.access = access;
        int i = 0;
        while (i < equates.length) {
            String key = equates[i][0].toLowerCase();
            if (key.equals("append") && equates[i][1] != null) {
                String value = equates[i][1].toLowerCase();
                if (value.equals("true")) {
                    this.append = true;
                } else if (!value.equals("false")) {
                    throw new IllegalArgumentException(Msg.getString("K00b5"));
                }
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", equates[i][0]));
            }
            ++i;
        }
        if (access == 1 && !this.file.exists()) {
            throw new ConnectionNotFoundException(name);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (access == 3) {
                sm.checkRead(this.file.getPath());
            }
            if (access == 2 || access == 3) {
                sm.checkWrite(this.file.getPath());
            }
        }
    }

    public void close() throws IOException {
        this.file = null;
    }

    public InputStream openInputStream() throws IOException {
        if (this.file == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 1 && this.access != 3) {
            throw new IOException(Msg.getString("K00a9"));
        }
        return new FileInputStream(this.file);
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.file == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 2 && this.access != 3) {
            throw new IOException(Msg.getString("K00aa"));
        }
        return new FileOutputStream(this.file, this.append);
    }
}

