/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.socket;

import com.ibm.oti.util.Msg;

public class SocketHelper {
    public static final int FLAG_BROKEN_SO_LINGER_SHUTDOWN = 8;

    public static String parseURL(String spec, int[] returnPort, boolean portRequired, boolean allowNoPort) {
        int port;
        if (spec.startsWith("//")) {
            spec = spec.substring(2);
        }
        int index = spec.lastIndexOf(58);
        int endOfIPv6Addr = spec.lastIndexOf(93);
        if (index == -1 || index < endOfIPv6Addr) {
            if (portRequired) {
                throw new IllegalArgumentException(Msg.getString("K00a6"));
            }
            return spec;
        }
        if (-1 != spec.indexOf(47) || -1 != spec.indexOf(64) || index != spec.indexOf(58) || -1 != spec.indexOf(63) || -1 != spec.indexOf(59)) {
            throw new IllegalArgumentException(Msg.getString("K039d"));
        }
        String portString = spec.substring(index + 1, spec.length());
        if (allowNoPort && portString.equals("")) {
            port = 0;
        } else {
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Msg.getString("K00a7", portString));
            }
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException(Msg.getString("K0325", port));
        }
        returnPort[0] = port;
        return spec.substring(0, index);
    }
}

