/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.crypto;

import com.ibm.j9.bluez.crypto.CL3Key;
import com.ibm.oti.crypto.CL3BasedKey;
import com.ibm.oti.crypto.Key;
import com.ibm.oti.crypto.Provider;
import com.ibm.oti.crypto.Util;
import com.ibm.oti.util.Msg;
import java.io.IOException;

public abstract class CL3BasedProvider
extends Provider {
    int mode;
    byte[] iv;

    protected CL3BasedProvider(int algorithm, int keyLength) {
        super(algorithm, keyLength);
    }

    final void destroyKey(Key key) {
        if (key instanceof CL3BasedKey) {
            CL3BasedKey cl3Key = (CL3BasedKey)key;
            cl3Key.workingKey.dispose();
            cl3Key.workingKey = null;
        }
    }

    final void cryptInit(Key key, int operation, int padType, byte[] iv) throws IOException {
        if (this.isInitialized) {
            return;
        }
        super.cryptInit(key, operation, padType, iv);
        if (!(key instanceof CL3BasedKey)) {
            throw new IOException(Msg.getString("K01fa"));
        }
        this.mode = operation;
        if (iv == null || iv.length != this.getIVLength()) {
            throw new IOException(Msg.getString("K01f6"));
        }
        this.iv = new byte[this.getIVLength()];
        System.arraycopy((Object)iv, 0, (Object)this.iv, 0, this.getIVLength());
    }

    byte[] cryptUpdate(Key key, byte[] bytes, int offset, int length, boolean finished) throws IOException {
        if (!(key instanceof CL3BasedKey)) {
            throw new IOException(Msg.getString("K01fa"));
        }
        if (this.mode == 1) {
            return this.encryptImpl((CL3BasedKey)key, bytes, offset, length, finished);
        }
        return this.decryptImpl((CL3BasedKey)key, bytes, offset, length, finished);
    }

    byte[] encryptImpl(CL3BasedKey key, byte[] bytes, int offset, int length, boolean finished) throws IOException {
        int fullBlocks = length / this.getBlockLength();
        int remainderBytes = length % this.getBlockLength();
        int lastBlockIndex = fullBlocks * this.getBlockLength();
        if (!finished && remainderBytes != 0) {
            throw new IOException(Msg.getString("K0170"));
        }
        byte[] outputBuffer = finished ? new byte[(fullBlocks + 1) * this.getBlockLength()] : new byte[lastBlockIndex];
        this.cl3Call(key.workingKey, 0, this.iv, 0, bytes, offset, outputBuffer, 0, lastBlockIndex);
        if (finished) {
            byte[] tempBlock = null;
            switch (this.padType) {
                case 3: {
                    tempBlock = Util.padSSL(bytes, offset + lastBlockIndex, remainderBytes, this.getBlockLength());
                    break;
                }
                case 4: {
                    tempBlock = Util.padTLS10(bytes, offset + lastBlockIndex, remainderBytes, this.getBlockLength());
                    break;
                }
                case 2: {
                    tempBlock = Util.padPKCS5(bytes, offset + lastBlockIndex, remainderBytes, this.getBlockLength());
                }
            }
            this.cl3Call(key.workingKey, 0, this.iv, 0, tempBlock, 0, outputBuffer, lastBlockIndex, this.getBlockLength());
        }
        return outputBuffer;
    }

    abstract void cl3Call(CL3Key var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9);

    byte[] decryptImpl(CL3BasedKey key, byte[] bytes, int offset, int length, boolean finished) throws IOException {
        if (length % this.getBlockLength() != 0) {
            throw new IOException(Msg.getString("K0170"));
        }
        int blockCount = length / this.getBlockLength();
        int lastBlockIndex = (blockCount - 1) * this.getBlockLength();
        if (finished) {
            --blockCount;
        }
        byte[] outputBuffer = new byte[blockCount * this.getBlockLength()];
        this.cl3Call(key.workingKey, 1, this.iv, 0, bytes, offset, outputBuffer, 0, blockCount * this.getBlockLength());
        if (finished) {
            byte[] tempBuf = new byte[this.getBlockLength()];
            this.cl3Call(key.workingKey, 1, this.iv, 0, bytes, offset + lastBlockIndex, tempBuf, 0, this.getBlockLength());
            byte[] unpadded = null;
            switch (this.padType) {
                case 4: {
                    unpadded = Util.unpadTLS10(tempBuf);
                    break;
                }
                case 3: {
                    unpadded = Util.unpadSSL(tempBuf);
                    break;
                }
                case 2: {
                    unpadded = Util.unpadPKCS5(tempBuf);
                }
            }
            return Util.concatenate(outputBuffer, unpadded);
        }
        return outputBuffer;
    }

    public abstract Key createKey(byte[] var1) throws IOException;
}

