/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.lang;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;

class ProcessInputStream
extends InputStream {
    private long handle;
    private FileDescriptor fd = new FileDescriptor();

    static {
        ProcessInputStream.oneTimeInitialization();
    }

    private static native void oneTimeInitialization();

    protected ProcessInputStream(long handle) {
        this.setFDImpl(this.fd, handle);
        this.handle = handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            block4: {
                if (this.handle != -1L) break block4;
                return -1;
            }
            return this.availableImpl();
        }
    }

    private native int availableImpl() throws IOException;

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            if (this.handle == -1L) {
                return;
            }
            this.closeImpl();
            this.handle = -1L;
        }
    }

    private native void closeImpl() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        byte[] buf = new byte[1];
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            block4: {
                if (this.readImpl(buf, 0, 1, this.handle) != -1) break block4;
                return -1;
            }
        }
        return buf[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer) throws IOException {
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            return this.readImpl(buffer, 0, buffer.length, this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int nbytes) throws IOException {
        ProcessInputStream processInputStream = this;
        synchronized (processInputStream) {
            block5: {
                if (this.handle != -1L) break block5;
                return -1;
            }
            if (nbytes < 0 || nbytes > buffer.length || offset < 0 || offset > buffer.length || nbytes + offset > buffer.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.readImpl(buffer, offset, nbytes, this.handle);
        }
    }

    private native int readImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    private native void setFDImpl(FileDescriptor var1, long var2);
}

