/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.net.www.protocol.file;

import com.ibm.oti.util.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class FileURLConnection
extends URLConnection {
    String fileName;
    private InputStream is;
    private int length = -1;
    private boolean isDir = false;
    private FilePermission permission;
    static final String encoding = "UTF8";

    public FileURLConnection(URL url) {
        super(url);
        String host;
        this.fileName = url.getFile();
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((host = url.getHost()) != null && host.length() > 0) {
            this.fileName = "//" + host + this.fileName;
        }
        this.fileName = Util.decode(this.fileName, false, encoding);
    }

    public void connect() throws IOException {
        File f = new File(this.fileName);
        if (f.isDirectory()) {
            this.isDir = true;
            this.is = this.getDirectoryListing(f);
        } else {
            this.is = new BufferedInputStream(new FileInputStream(f));
            this.length = this.is.available();
        }
        this.connected = true;
    }

    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException iOException) {}
        return this.length;
    }

    public String getContentType() {
        try {
            if (!this.connected) {
                this.connect();
            }
        }
        catch (IOException iOException) {
            return "content/unknown";
        }
        if (this.isDir) {
            return "text/plain";
        }
        String result = FileURLConnection.guessContentTypeFromName(this.url.getFile());
        if (result == null) {
            return "content/unknown";
        }
        return result;
    }

    private InputStream getDirectoryListing(File f) {
        String[] fileList = f.list();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        int i = 0;
        while (i < fileList.length) {
            out.print(String.valueOf(fileList[i]) + "\n");
            ++i;
        }
        out.close();
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            String path = this.fileName;
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            this.permission = new FilePermission(path, new String("read"));
        }
        return this.permission;
    }

    public String getHeaderField(String key) {
        if (key == null) {
            return null;
        }
        if ((key = key.toLowerCase()).equals("content-type")) {
            return this.getContentType();
        }
        return null;
    }
}

