/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.net.www.protocol.http;

import com.ibm.oti.net.www.protocol.http.AuthCredential;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;

public class AuthCredentialCache {
    private int HIGH_WATER = 100;
    private int LOW_WATER = 50;
    private Hashtable cache = new Hashtable();
    private static Comparator credentialComparator = new Comparator(){

        public int compare(Object objA, Object objB) {
            long timeStampB;
            long timeStampA = ((AuthCredential)objA).getLastUsedTime();
            if (timeStampA < (timeStampB = ((AuthCredential)objB).getLastUsedTime())) {
                return -1;
            }
            if (timeStampA == timeStampB) {
                return 0;
            }
            return 1;
        }
    };

    public void put(AuthCredential credential) {
        if (credential == null) {
            return;
        }
        if (credential != null) {
            credential.updateLastUsed();
            credential.incrementNonceCount();
            AuthCredential replaced = (AuthCredential)this.cache.put(credential.getKey(), credential);
            if (replaced == null) {
                this.prune();
            }
        }
    }

    private void prune() {
        if (this.cache.size() < this.HIGH_WATER) {
            return;
        }
        ArrayList credentials = new ArrayList(this.cache.values());
        Collections.sort(credentials, credentialComparator);
        int i = 0;
        while (i < this.HIGH_WATER - this.LOW_WATER) {
            AuthCredential credential = (AuthCredential)credentials.get(i);
            this.cache.remove(credential.getKey());
            ++i;
        }
    }

    public AuthCredential get(AuthCredential key) {
        AuthCredential result = (AuthCredential)this.cache.get(key.getKey());
        return result;
    }

    public AuthCredential remove(AuthCredential key) {
        return (AuthCredential)this.cache.remove(key.getKey());
    }
}

