/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.PKCS7;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.Msg;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CertPathX509
extends CertPath {
    static final String PKCS7_ENCODING = "PKCS7";
    static final String PKIPATH_ENCODING = "PkiPath";
    private static String defaultEncoding = "PkiPath";
    private static String[] supportedEncodings = new String[]{"PKCS7", "PkiPath"};
    private List certificates = null;

    public CertPathX509() {
        super("X.509");
        this.certificates = new ArrayList(0);
    }

    CertPathX509(List certificates) {
        super("X.509");
        this.certificates = new ArrayList(certificates);
    }

    public Iterator getEncodings() {
        List encodings = Arrays.asList(supportedEncodings);
        return encodings.iterator();
    }

    public List getCertificates() {
        return Collections.unmodifiableList(this.certificates);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.getEncoded(defaultEncoding);
    }

    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        if (encoding.equals(PKCS7_ENCODING)) {
            return CertPathX509.encodeAsPKCS7(this.certificates);
        }
        if (encoding.equals(PKIPATH_ENCODING)) {
            return CertPathX509.encodeAsPkiPath(this.certificates);
        }
        throw new CertificateEncodingException(Msg.getString("K0300"));
    }

    static String getDefaultEncoding() {
        return defaultEncoding;
    }

    static Iterator getSupportedEncodings() {
        List encodings = Arrays.asList(supportedEncodings);
        return encodings.iterator();
    }

    private static byte[] encodeAsPKCS7(List certList) throws CertificateEncodingException {
        try {
            return PKCS7.encodeCertList(certList);
        }
        catch (ASN1Exception e) {
            throw new CertificateEncodingException(e.getMessage());
        }
    }

    private static byte[] encodeAsPkiPath(List certList) throws CertificateEncodingException {
        Object[] certArray = new Object[certList.size()];
        int i = 0;
        Iterator iter = certList.iterator();
        while (iter.hasNext()) {
            Certificate element = (Certificate)iter.next();
            byte[] certEncoding = element.getEncoded();
            ASN1Decoder.Data newCertNode = new ASN1Decoder.Data(certEncoding);
            certArray[i++] = newCertNode;
        }
        byte[] result = ASN1Encoder.getEncoding(certArray);
        return result;
    }
}

