/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.text;

import com.ibm.oti.text.Utility;
import com.ibm.oti.util.Msg;
import java.lang.reflect.Array;

public final class CompactByteArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private byte[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CompactByteArray() {
        this(0);
    }

    public CompactByteArray(byte defaultValue) {
        this.values = new byte[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        int i = 0;
        while (i < 65536) {
            this.values[i] = defaultValue;
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.indices[i] = (short)(i << 7);
            this.hashes[i] = 0;
            ++i;
        }
        this.isCompact = false;
    }

    public CompactByteArray(short[] indexArray, byte[] newValues) {
        if (indexArray.length != 512) {
            throw new IllegalArgumentException(Msg.getString("K0013"));
        }
        int i = 0;
        while (i < 512) {
            short index = indexArray[i];
            if (index < 0 || index >= newValues.length + 128) {
                throw new IllegalArgumentException(Msg.getString("K0013"));
            }
            ++i;
        }
        this.indices = indexArray;
        this.values = newValues;
        this.isCompact = true;
    }

    public CompactByteArray(String indexArray, String valueArray) {
        this(Utility.RLEStringToShortArray(indexArray), Utility.RLEStringToByteArray(valueArray));
    }

    public byte elementAt(char index) {
        return this.values[(this.indices[index >> 7] & 0xFFFF) + (index & 0x7F)];
    }

    public void setElementAt(char index, byte value) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[index] = value;
        this.touchBlock(index >> 7, value);
    }

    public void setElementAt(char start, char end, byte value) {
        if (this.isCompact) {
            this.expand();
        }
        int i = start;
        while (i <= end) {
            this.values[i] = value;
            this.touchBlock(i >> 7, value);
            ++i;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int limitCompacted = 0;
            int iBlockStart = 0;
            int iUntouched = -1;
            int i = 0;
            while (i < this.indices.length) {
                this.indices[i] = -1;
                boolean touched = this.blockTouched(i);
                if (!touched && iUntouched != -1) {
                    this.indices[i] = iUntouched;
                } else {
                    int jBlockStart = 0;
                    int j = 0;
                    j = 0;
                    while (j < limitCompacted) {
                        if (this.hashes[i] == this.hashes[j] && CompactByteArray.arrayRegionMatches(this.values, iBlockStart, this.values, jBlockStart, 128)) {
                            this.indices[i] = (short)jBlockStart;
                            break;
                        }
                        ++j;
                        jBlockStart += 128;
                    }
                    if (this.indices[i] == -1) {
                        System.arraycopy((Object)this.values, iBlockStart, (Object)this.values, jBlockStart, 128);
                        this.indices[i] = (short)jBlockStart;
                        this.hashes[j] = this.hashes[i];
                        ++limitCompacted;
                        if (!touched) {
                            iUntouched = (short)jBlockStart;
                        }
                    }
                }
                ++i;
                iBlockStart += 128;
            }
            int newSize = limitCompacted * 128;
            this.values = (byte[])Utility.resizeArray(newSize, this.values, 0, newSize);
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(byte[] source, int sourceStart, byte[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (source[i] != target[i + delta]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final void touchBlock(int i, int value) {
        this.hashes[i] = this.hashes[i] + (value << 1) | 1;
    }

    private final boolean blockTouched(int i) {
        return this.hashes[i] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public byte[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactByteArray other = (CompactByteArray)super.clone();
            other.values = (byte[])this.values.clone();
            other.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                other.hashes = (int[])this.hashes.clone();
            }
            return other;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompactByteArray other = (CompactByteArray)obj;
        int i = 0;
        while (i < 65536) {
            if (this.elementAt((char)i) != other.elementAt((char)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        int increment = Math.min(3, this.values.length / 16);
        int i = 0;
        while (i < this.values.length) {
            result = result * 37 + this.values[i];
            i += increment;
        }
        return result;
    }

    private void expand() {
        if (this.isCompact) {
            this.hashes = (int[])Array.newInstance(Integer.TYPE, 512);
            byte[] tempArray = (byte[])Array.newInstance(Byte.TYPE, 65536);
            int i = 0;
            while (i < 65536) {
                byte value;
                tempArray[i] = value = this.elementAt((char)i);
                this.touchBlock(i >> 7, value);
                ++i;
            }
            i = 0;
            while (i < 512) {
                this.indices[i] = (short)(i << 7);
                ++i;
            }
            this.values = null;
            this.values = tempArray;
            this.isCompact = false;
        }
    }

    private byte[] getArray() {
        return this.values;
    }
}

