/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Inet6Util {
    static String hexCharacters = "0123456789ABCDEF";

    public static byte[] createByteArrayFromIPAddressString(String ipAddressString) {
        int i;
        if (Inet6Util.isValidIPV4Address(ipAddressString)) {
            StringTokenizer tokenizer = new StringTokenizer(ipAddressString, ".");
            String token = "";
            int tempInt = 0;
            byte[] byteAddress = new byte[4];
            int i2 = 0;
            while (i2 < 4) {
                token = tokenizer.nextToken();
                tempInt = Integer.parseInt(token);
                byteAddress[i2] = (byte)tempInt;
                ++i2;
            }
            return byteAddress;
        }
        if (ipAddressString.charAt(0) == '[') {
            ipAddressString = ipAddressString.substring(1, ipAddressString.length() - 1);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipAddressString, ":.", true);
        ArrayList hexStrings = new ArrayList();
        ArrayList decStrings = new ArrayList();
        String token = "";
        String prevToken = "";
        int doubleColonIndex = -1;
        while (tokenizer.hasMoreTokens()) {
            prevToken = token;
            token = tokenizer.nextToken();
            if (token.equals(":")) {
                if (prevToken.equals(":")) {
                    doubleColonIndex = hexStrings.size();
                    continue;
                }
                if (prevToken.equals("")) continue;
                hexStrings.add(prevToken);
                continue;
            }
            if (!token.equals(".")) continue;
            decStrings.add(prevToken);
        }
        if (prevToken.equals(":")) {
            if (token.equals(":")) {
                doubleColonIndex = hexStrings.size();
            } else {
                hexStrings.add(token);
            }
        } else if (prevToken.equals(".")) {
            decStrings.add(token);
        }
        int hexStringsLength = 8;
        if (decStrings.size() > 0) {
            hexStringsLength -= 2;
        }
        if (doubleColonIndex != -1) {
            int numberToInsert = hexStringsLength - hexStrings.size();
            i = 0;
            while (i < numberToInsert) {
                hexStrings.add(doubleColonIndex, "0");
                ++i;
            }
        }
        byte[] ipByteArray = new byte[16];
        i = 0;
        while (i < hexStrings.size()) {
            Inet6Util.convertToBytes((String)hexStrings.get(i), ipByteArray, i * 2);
            ++i;
        }
        i = 0;
        while (i < decStrings.size()) {
            ipByteArray[i + 12] = (byte)(Integer.parseInt((String)decStrings.get(i)) & 0xFF);
            ++i;
        }
        boolean ipV4 = true;
        int i3 = 0;
        while (i3 < 10) {
            if (ipByteArray[i3] != 0) {
                ipV4 = false;
                break;
            }
            ++i3;
        }
        if (ipByteArray[10] != -1 || ipByteArray[11] != -1) {
            ipV4 = false;
        }
        if (ipV4) {
            byte[] ipv4ByteArray = new byte[4];
            int i4 = 0;
            while (i4 < 4) {
                ipv4ByteArray[i4] = ipByteArray[i4 + 12];
                ++i4;
            }
            return ipv4ByteArray;
        }
        return ipByteArray;
    }

    public static String createIPAddrStringFromByteArray(byte[] ipByteArray) {
        if (ipByteArray.length == 4) {
            return Inet6Util.addressToString(Inet6Util.bytesToInt(ipByteArray, 0));
        }
        if (ipByteArray.length == 16) {
            if (Inet6Util.isIPv4MappedAddress(ipByteArray)) {
                byte[] ipv4ByteArray = new byte[4];
                int i = 0;
                while (i < 4) {
                    ipv4ByteArray[i] = ipByteArray[i + 12];
                    ++i;
                }
                return Inet6Util.addressToString(Inet6Util.bytesToInt(ipv4ByteArray, 0));
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < ipByteArray.length) {
                int j = (ipByteArray[i] & 0xF0) >>> 4;
                buffer.append(hexCharacters.charAt(j));
                j = ipByteArray[i] & 0xF;
                buffer.append(hexCharacters.charAt(j));
                if (i % 2 != 0 && i + 1 < ipByteArray.length) {
                    buffer.append(":");
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    public static void convertToBytes(String hexWord, byte[] ipByteArray, int byteIndex) {
        int charValue;
        int hexWordLength = hexWord.length();
        int hexWordIndex = 0;
        ipByteArray[byteIndex] = 0;
        ipByteArray[byteIndex + 1] = 0;
        if (hexWordLength > 3) {
            charValue = Inet6Util.getIntValue(hexWord.charAt(hexWordIndex++));
            ipByteArray[byteIndex] = (byte)(ipByteArray[byteIndex] | charValue << 4);
        }
        if (hexWordLength > 2) {
            charValue = Inet6Util.getIntValue(hexWord.charAt(hexWordIndex++));
            ipByteArray[byteIndex] = (byte)(ipByteArray[byteIndex] | charValue);
        }
        if (hexWordLength > 1) {
            charValue = Inet6Util.getIntValue(hexWord.charAt(hexWordIndex++));
            ipByteArray[byteIndex + 1] = (byte)(ipByteArray[byteIndex + 1] | charValue << 4);
        }
        charValue = Inet6Util.getIntValue(hexWord.charAt(hexWordIndex));
        ipByteArray[byteIndex + 1] = (byte)(ipByteArray[byteIndex + 1] | charValue & 0xF);
    }

    static int getIntValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        c = Character.toLowerCase(c);
        switch (c) {
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    private static boolean isIPv4MappedAddress(byte[] ipAddress) {
        int i = 0;
        while (i < 10) {
            if (ipAddress[i] != 0) {
                return false;
            }
            ++i;
        }
        return ipAddress[10] == -1 && ipAddress[11] == -1;
    }

    public static int bytesToInt(byte[] bytes, int start) {
        int value = bytes[start + 3] & 0xFF | (bytes[start + 2] & 0xFF) << 8 | (bytes[start + 1] & 0xFF) << 16 | (bytes[start] & 0xFF) << 24;
        return value;
    }

    public static String addressToString(int value) {
        return String.valueOf(value >> 24 & 0xFF) + "." + (value >> 16 & 0xFF) + "." + (value >> 8 & 0xFF) + "." + (value & 0xFF);
    }

    public static boolean isValidIP6Address(String ipAddress) {
        int length = ipAddress.length();
        boolean doubleColon = false;
        int numberOfColons = 0;
        int numberOfPeriods = 0;
        int numberOfPercent = 0;
        String word = "";
        char c = '\u0000';
        char prevChar = '\u0000';
        int offset = 0;
        if (length < 2) {
            return false;
        }
        int i = 0;
        while (i < length) {
            prevChar = c;
            c = ipAddress.charAt(i);
            switch (c) {
                case '[': {
                    if (i != 0) {
                        return false;
                    }
                    if (ipAddress.charAt(length - 1) != ']') {
                        return false;
                    }
                    offset = 1;
                    if (length >= 4) break;
                    return false;
                }
                case ']': {
                    if (i != length - 1) {
                        return false;
                    }
                    if (ipAddress.charAt(0) == '[') break;
                    return false;
                }
                case '.': {
                    if (++numberOfPeriods > 3) {
                        return false;
                    }
                    if (!Inet6Util.isValidIP4Word(word)) {
                        return false;
                    }
                    if (numberOfColons != 6 && !doubleColon) {
                        return false;
                    }
                    if (numberOfColons == 7 && ipAddress.charAt(0 + offset) != ':' && ipAddress.charAt(1 + offset) != ':') {
                        return false;
                    }
                    word = "";
                    break;
                }
                case ':': {
                    if (++numberOfColons > 7) {
                        return false;
                    }
                    if (numberOfPeriods > 0) {
                        return false;
                    }
                    if (prevChar == ':') {
                        if (doubleColon) {
                            return false;
                        }
                        doubleColon = true;
                    }
                    word = "";
                    break;
                }
                case '%': {
                    if (numberOfColons == 0) {
                        return false;
                    }
                    ++numberOfPercent;
                    if (i + 1 < length) break;
                    return false;
                }
                default: {
                    if (numberOfPercent == 0) {
                        if (word.length() > 3) {
                            return false;
                        }
                        if (!Inet6Util.isValidHexChar(c)) {
                            return false;
                        }
                    }
                    word = String.valueOf(word) + c;
                }
            }
            ++i;
        }
        if (numberOfPeriods > 0) {
            if (numberOfPeriods != 3 || !Inet6Util.isValidIP4Word(word)) {
                return false;
            }
        } else {
            if (numberOfColons != 7 && !doubleColon) {
                return false;
            }
            if (numberOfPercent == 0 && word == "" && ipAddress.charAt(length - 1 - offset) == ':' && ipAddress.charAt(length - 2 - offset) != ':') {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIP4Word(String word) {
        if (word.length() < 1 || word.length() > 3) {
            return false;
        }
        int i = 0;
        while (i < word.length()) {
            char c = word.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return Integer.parseInt(word) <= 255;
    }

    static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isValidIPV4Address(String value) {
        int periods = 0;
        int i = 0;
        int length = value.length();
        if (length > 15) {
            return false;
        }
        char c = '\u0000';
        String word = "";
        i = 0;
        while (i < length) {
            c = value.charAt(i);
            if (c == '.') {
                if (++periods > 3) {
                    return false;
                }
                if (word == "") {
                    return false;
                }
                if (Integer.parseInt(word) > 255) {
                    return false;
                }
                word = "";
            } else {
                if (!Character.isDigit(c)) {
                    return false;
                }
                if (word.length() > 2) {
                    return false;
                }
                word = String.valueOf(word) + c;
            }
            ++i;
        }
        if (word == "" || Integer.parseInt(word) > 255) {
            return false;
        }
        return periods == 3;
    }
}

