/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PasswordProtectedInputStream
extends FilterInputStream {
    private byte[] password;
    private int pwdIndex = 0;

    public PasswordProtectedInputStream(InputStream in, byte[] password) {
        super(in);
        this.password = password;
    }

    public int read() throws IOException {
        int read = this.in.read();
        if (read >= 0) {
            read ^= this.password[this.pwdIndex];
            this.pwdIndex = (this.pwdIndex + 1) % this.password.length;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            int lastIndex = off + read;
            int i = off;
            while (i < lastIndex) {
                int n = i++;
                b[n] = (byte)(b[n] ^ this.password[this.pwdIndex]);
                this.pwdIndex = (this.pwdIndex + 1) % this.password.length;
            }
        }
        return read;
    }

    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        this.pwdIndex = (int)((long)this.pwdIndex + skip);
        return skip;
    }
}

