/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.net.www.protocol.jxe.Handler;
import com.ibm.oti.vm.Jxe;
import com.ibm.oti.vm.JxeException;
import com.ibm.oti.vm.URLSystemClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class URLAppClassLoader
extends URLSystemClassLoader {
    private static URL[] classPath = URLAppClassLoader.getClassPath();

    public URLAppClassLoader() {
        this((ClassLoader)null);
    }

    public URLAppClassLoader(ClassLoader parent) {
        super(classPath, parent);
    }

    URLAppClassLoader(URL[] path, ClassLoader parent) {
        super(path, parent);
    }

    private static URL[] getClassPath() {
        String classPath = System.getProperty("java.class.path", ".");
        int index = 0;
        int count = 0;
        int end = classPath.length();
        while (index < end) {
            int next = classPath.indexOf(File.pathSeparatorChar, index);
            if (next == -1) {
                next = end;
            }
            if (next - index > 0) {
                ++count;
            }
            index = next + 1;
        }
        URL[] urlPath = new URL[count];
        count = 0;
        index = 0;
        while (index < end) {
            int next = classPath.indexOf(File.pathSeparatorChar, index);
            if (next == -1) {
                next = end;
            }
            if (next - index > 0) {
                String path = classPath.substring(index, next);
                try {
                    boolean isInMemoryJxe = path.startsWith("jxe=");
                    boolean isJxeSharedLibrary = path.startsWith("jxesl=");
                    if (path.length() > 4 && (path.substring(path.length() - 4).equalsIgnoreCase(".jxe") || isInMemoryJxe || isJxeSharedLibrary)) {
                        try {
                            Jxe jxe = null;
                            if (isInMemoryJxe) {
                                try {
                                    jxe = Jxe.fromPointer(Long.parseLong(path.substring(4), 16));
                                }
                                catch (NumberFormatException numberFormatException) {}
                            } else {
                                jxe = isJxeSharedLibrary ? Jxe.fromSharedLibrary(path.substring(6)) : Jxe.fromFile(new File(path));
                            }
                            if (jxe != null) {
                                urlPath[count] = new URL("jxe", jxe.getUuid(), -1, "/", new Handler(jxe));
                                ++count;
                                index = next + 1;
                                continue;
                            }
                        }
                        catch (JxeException jxeException) {
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
                    }
                    File f = new File(path);
                    path = f.getCanonicalPath();
                    if (File.separatorChar != '/') {
                        path = path.replace(File.separatorChar, '/');
                    }
                    if (f.isDirectory() && !path.endsWith("/")) {
                        path = new StringBuffer(path.length() + 1).append(path).append('/').toString();
                    }
                    if (!path.startsWith("/")) {
                        path = new StringBuffer(path.length() + 1).append('/').append(path).toString();
                    }
                    if (!path.startsWith("//")) {
                        try {
                            urlPath[count++] = new URL("file", "", -1, path, null);
                        }
                        catch (MalformedURLException malformedURLException) {}
                        index = next + 1;
                        continue;
                    }
                    path = new StringBuffer(path.length() + 5).append("file:").append(path).toString();
                    urlPath[count] = new URL(path);
                    ++count;
                }
                catch (IOException iOException) {}
            }
            index = next + 1;
        }
        if (count < urlPath.length) {
            URL[] paths = new URL[count];
            System.arraycopy((Object)urlPath, 0, (Object)paths, 0, count);
            urlPath = paths;
        }
        return urlPath;
    }

    boolean addExitPermission() {
        return true;
    }
}

