/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;

    public ByteArrayInputStream(byte[] buf) {
        this.mark = 0;
        this.buf = buf;
        this.count = buf.length;
    }

    public ByteArrayInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.mark = this.pos = offset >= buf.length ? buf.length : offset;
        this.count = length + this.pos > buf.length ? buf.length : length + this.pos;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public synchronized int read(byte[] b, int offset, int length) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (b != null) {
            if (offset >= 0 && offset <= b.length && length >= 0 && length <= b.length - offset) {
                if (length == 0) {
                    return 0;
                }
                int copylen = this.count - this.pos < length ? this.count - this.pos : length;
                System.arraycopy((Object)this.buf, this.pos, (Object)b, offset, copylen);
                this.pos += copylen;
                return copylen;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new NullPointerException();
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized long skip(long count) {
        if (count <= 0L) {
            return 0L;
        }
        int temp = this.pos;
        this.pos = (long)(this.count - this.pos) < count ? this.count : (int)((long)this.pos + count);
        return this.pos - temp;
    }
}

