/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.DeleteOnExit;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import com.ibm.oti.util.Util;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.Random;
import java.util.Vector;

public class File
implements Serializable,
Comparable {
    private static final long serialVersionUID = 301077366599181567L;
    private String path;
    byte[] properPath;
    public static final char separatorChar;
    public static final String separator;
    public static final char pathSeparatorChar;
    public static final String pathSeparator;
    private static int counter;
    private static boolean caseSensitive;

    static {
        File.oneTimeInitialization();
        separatorChar = System.getProperty("file.separator", "\\").charAt(0);
        pathSeparatorChar = System.getProperty("path.separator", ";").charAt(0);
        separator = new String(new char[]{separatorChar}, 0, 1);
        pathSeparator = new String(new char[]{pathSeparatorChar}, 0, 1);
        caseSensitive = File.isCaseSensitiveImpl();
    }

    private static native void oneTimeInitialization();

    public File(File dir, String name) {
        if (name != null) {
            this.path = dir == null ? name : this.calculatePath(dir.getPath(), name);
        } else {
            throw new NullPointerException();
        }
    }

    public File(String path) {
        this.path = this.fixSlashes(path);
    }

    public File(String dirPath, String name) {
        if (name != null) {
            this.path = dirPath == null ? name : this.calculatePath(dirPath, name);
        } else {
            throw new NullPointerException();
        }
    }

    private String calculatePath(String dirPath, String name) {
        name = this.fixSlashes(name);
        while (name.length() > 0 && name.charAt(0) == separatorChar) {
            name = name.substring(1, name.length());
        }
        if ((dirPath = this.fixSlashes(dirPath)).length() > 0 && dirPath.charAt(dirPath.length() - 1) == separatorChar) {
            return String.valueOf(dirPath) + name;
        }
        return String.valueOf(dirPath) + separatorChar + name;
    }

    public File(URI uri) {
        this.checkURI(uri);
        this.path = this.fixSlashes(uri.getPath());
    }

    private void checkURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException(Msg.getString("K031a", uri));
        }
        if (!uri.getRawSchemeSpecificPart().startsWith("/")) {
            throw new IllegalArgumentException(Msg.getString("K031b", uri));
        }
        String temp = uri.getScheme();
        if (temp == null || !temp.equals("file")) {
            throw new IllegalArgumentException(Msg.getString("K031c", uri));
        }
        temp = uri.getRawPath();
        if (temp == null || temp.length() == 0) {
            throw new IllegalArgumentException(Msg.getString("K031d", uri));
        }
        if (uri.getRawAuthority() != null) {
            throw new IllegalArgumentException(Msg.getString("K031e", new String[]{"authority", uri.toString()}));
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException(Msg.getString("K031e", new String[]{"query", uri.toString()}));
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException(Msg.getString("K031e", new String[]{"fragment", uri.toString()}));
        }
    }

    private static native byte[][] rootsImpl();

    private static native boolean isCaseSensitiveImpl();

    public static File[] listRoots() {
        byte[][] rootsList = File.rootsImpl();
        if (rootsList == null) {
            return new File[0];
        }
        File[] result = new File[rootsList.length];
        int i = 0;
        while (i < rootsList.length) {
            result[i] = new File(Util.toString(rootsList[i]));
            ++i;
        }
        return result;
    }

    private String fixSlashes(String path) {
        String tempPath;
        int uncIndex = 1;
        int length = path.length();
        int newLength = 0;
        if (separatorChar == '/') {
            uncIndex = 0;
        } else if (length > 2 && path.charAt(1) == ':') {
            uncIndex = 2;
        }
        boolean foundSlash = false;
        char[] newPath = path.toCharArray();
        int i = 0;
        while (i < length) {
            char pathChar = newPath[i];
            if (pathChar == '\\' || pathChar == '/') {
                if (foundSlash && i == uncIndex || !foundSlash) {
                    newPath[newLength++] = separatorChar;
                    foundSlash = true;
                }
            } else {
                if (pathChar == ':' && uncIndex > 0 && (newLength == 2 || newLength == 3 && newPath[1] == separatorChar) && newPath[0] == separatorChar) {
                    newPath[0] = newPath[newLength - 1];
                    newLength = 1;
                    uncIndex = 2;
                }
                newPath[newLength++] = pathChar;
                foundSlash = false;
            }
            ++i;
        }
        if (foundSlash && (newLength > uncIndex + 1 || newLength == 2 && newPath[0] != separatorChar)) {
            --newLength;
        }
        if (!(tempPath = new String(newPath, 0, newLength)).equals(path)) {
            return tempPath;
        }
        return path;
    }

    public boolean canRead() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        return this.exists() && !this.isWriteOnlyImpl(this.properPath(true));
    }

    public boolean canWrite() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        boolean exists = false;
        if (this.path.length() > 0) {
            exists = this.existsImpl(this.properPath(true));
        }
        return exists && !this.isReadOnlyImpl(this.properPath(true));
    }

    public int compareTo(Object another) {
        if (this.getClass() == another.getClass()) {
            return this.getPath().compareTo(((File)another).getPath());
        }
        throw new ClassCastException(Msg.getString("K0069"));
    }

    public int compareTo(File another) {
        if (caseSensitive) {
            return this.getPath().compareTo(another.getPath());
        }
        return this.getPath().compareToIgnoreCase(another.getPath());
    }

    public boolean delete() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkDelete(this.path);
        }
        boolean isDir = false;
        if (this.path.length() > 0) {
            isDir = this.isDirectoryImpl(this.properPath(true));
        }
        return isDir ? this.deleteDirImpl(this.properPath(true)) : this.deleteFileImpl(this.properPath(true));
    }

    private native boolean deleteDirImpl(byte[] var1);

    private native boolean deleteFileImpl(byte[] var1);

    public void deleteOnExit() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkDelete(this.path);
        }
        DeleteOnExit.addFile(Util.toString(this.properPath(true)));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        if (!caseSensitive) {
            return this.path.equalsIgnoreCase(((File)obj).getPath());
        }
        return this.path.equals(((File)obj).getPath());
    }

    public boolean exists() {
        if (this.path.length() == 0) {
            return false;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        return this.existsImpl(this.properPath(true));
    }

    private native boolean existsImpl(byte[] var1);

    public String getAbsolutePath() {
        byte[] absolute = this.properPath(false);
        return Util.toString(absolute);
    }

    public File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public String getCanonicalPath() throws IOException {
        int newLength;
        byte[] resolvedBytes = this.properPath(false);
        if (separatorChar == '/') {
            resolvedBytes = this.resolveLink(resolvedBytes, resolvedBytes.length, false);
            resolvedBytes = this.resolve(resolvedBytes);
        }
        String resolvedPath = Util.toString(resolvedBytes);
        int numSeparators = 1;
        int length = resolvedPath.length();
        int i = 0;
        while (i < length) {
            if (resolvedPath.charAt(i) == separatorChar) {
                ++numSeparators;
            }
            ++i;
        }
        int[] sepLocations = new int[numSeparators];
        int rootLoc = 0;
        if (separatorChar != '/') {
            rootLoc = resolvedPath.charAt(0) == '\\' ? (length > 1 && resolvedPath.charAt(1) == '\\' ? 1 : 0) : 2;
        }
        StringBuffer newResult = new StringBuffer(length + 1);
        int lastSlash = 0;
        int foundDots = 0;
        sepLocations[lastSlash] = rootLoc;
        int i2 = 0;
        while (i2 <= length) {
            if (i2 < rootLoc) {
                newResult.append(resolvedPath.charAt(i2));
            } else {
                char ch = '\u0000';
                if (i2 == length || (ch = resolvedPath.charAt(i2)) == separatorChar) {
                    if (i2 == length && foundDots == 0) break;
                    if (foundDots == 1) {
                        foundDots = 0;
                    } else if (foundDots > 1) {
                        lastSlash = lastSlash > foundDots - 1 ? lastSlash - (foundDots - 1) : 0;
                        newResult.setLength(sepLocations[lastSlash] + 1);
                        foundDots = 0;
                    } else {
                        sepLocations[++lastSlash] = newResult.length();
                        newResult.append(separatorChar);
                    }
                } else if (ch == '.') {
                    ++foundDots;
                } else {
                    if (foundDots > 0) {
                        int j = 0;
                        while (j < foundDots) {
                            newResult.append('.');
                            ++j;
                        }
                    }
                    newResult.append(ch);
                    foundDots = 0;
                }
            }
            ++i2;
        }
        if ((newLength = newResult.length()) > rootLoc + 1 && newResult.charAt(newLength - 1) == separatorChar) {
            newResult.setLength(newLength - 1);
        }
        byte[] canonPath = this.getCanonImpl(Util.getBytes(newResult.toString()));
        return Util.toString(canonPath);
    }

    private byte[] resolve(byte[] newResult) throws IOException {
        int last = 1;
        byte[] linkPath = newResult;
        int i = 1;
        while (i <= newResult.length) {
            if (i == newResult.length || newResult[i] == separatorChar) {
                byte[] bytes;
                boolean done;
                boolean bl = done = i >= newResult.length - 1;
                if (done && linkPath.length == 1) {
                    return newResult;
                }
                boolean inPlace = false;
                if (linkPath == newResult) {
                    bytes = newResult;
                    if (!done) {
                        inPlace = true;
                        newResult[i] = 0;
                    }
                } else {
                    int nextSize = i - last + 1;
                    int linkSize = linkPath.length;
                    if (linkPath[linkSize - 1] == separatorChar) {
                        --linkSize;
                    }
                    bytes = new byte[linkSize + nextSize];
                    System.arraycopy((Object)linkPath, 0, (Object)bytes, 0, linkSize);
                    System.arraycopy((Object)newResult, last - 1, (Object)bytes, linkSize, nextSize);
                }
                if (done) {
                    return bytes;
                }
                linkPath = this.resolveLink(bytes, inPlace ? i : bytes.length, true);
                if (inPlace) {
                    newResult[i] = 47;
                }
                last = i + 1;
            }
            ++i;
        }
        throw new InternalError();
    }

    private byte[] resolveLink(byte[] pathBytes, int length, boolean resolveAbsolute) throws IOException {
        byte[] linkBytes;
        boolean restart = false;
        while ((linkBytes = this.getLinkImpl(pathBytes)) != pathBytes) {
            if (linkBytes[0] == separatorChar) {
                restart = resolveAbsolute;
                pathBytes = linkBytes;
            } else {
                int last = length - 1;
                while (pathBytes[last] != separatorChar) {
                    --last;
                }
                byte[] temp = new byte[++last + linkBytes.length];
                System.arraycopy((Object)pathBytes, 0, (Object)temp, 0, last);
                System.arraycopy((Object)linkBytes, 0, (Object)temp, last, linkBytes.length);
                pathBytes = temp;
            }
            length = pathBytes.length;
            if (this.existsImpl(pathBytes)) continue;
        }
        if (restart) {
            return this.resolve(pathBytes);
        }
        return pathBytes;
    }

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    private native byte[] getCanonImpl(byte[] var1);

    public String getName() {
        int separatorIndex = this.path.lastIndexOf(separator);
        return separatorIndex < 0 ? this.path : this.path.substring(separatorIndex + 1, this.path.length());
    }

    public String getParent() {
        int index;
        int length = this.path.length();
        int firstInPath = 0;
        if (separatorChar == '\\' && length > 2 && this.path.charAt(1) == ':') {
            firstInPath = 2;
        }
        if ((index = this.path.lastIndexOf(separatorChar)) == -1 && firstInPath > 0) {
            index = 2;
        }
        if (index == -1 || this.path.charAt(length - 1) == separatorChar) {
            return null;
        }
        if (this.path.indexOf(separatorChar) == index && this.path.charAt(firstInPath) == separatorChar) {
            return this.path.substring(0, index + 1);
        }
        return this.path.substring(0, index);
    }

    public File getParentFile() {
        String tempParent = this.getParent();
        if (tempParent == null) {
            return null;
        }
        return new File(tempParent);
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        if (caseSensitive) {
            return this.path.hashCode() ^ 0x12D591;
        }
        return this.path.toLowerCase().hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        return this.isAbsoluteImpl(Util.getBytes(this.path));
    }

    private native boolean isAbsoluteImpl(byte[] var1);

    public boolean isDirectory() {
        if (this.path.length() == 0) {
            return false;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        return this.isDirectoryImpl(this.properPath(true));
    }

    private native boolean isDirectoryImpl(byte[] var1);

    public boolean isFile() {
        if (this.path.length() == 0) {
            return false;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        return this.isFileImpl(this.properPath(true));
    }

    private native boolean isFileImpl(byte[] var1);

    public boolean isHidden() {
        if (this.path.length() == 0) {
            return false;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        return this.isHiddenImpl(this.properPath(true));
    }

    private native boolean isHiddenImpl(byte[] var1);

    private native boolean isReadOnlyImpl(byte[] var1);

    private native boolean isWriteOnlyImpl(byte[] var1);

    private native byte[] getLinkImpl(byte[] var1);

    public long lastModified() {
        long result;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if ((result = this.lastModifiedImpl(this.properPath(true))) == -1L || result == 0L) {
            return 0L;
        }
        return result * 1000L;
    }

    private native long lastModifiedImpl(byte[] var1);

    public boolean setLastModified(long time) {
        if (time >= 0L) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this.path);
            }
            return this.setLastModifiedImpl(this.properPath(true), time);
        }
        throw new IllegalArgumentException(Msg.getString("K006a"));
    }

    private native boolean setLastModifiedImpl(byte[] var1, long var2);

    public boolean setReadOnly() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        return this.setReadOnlyImpl(this.properPath(true));
    }

    private native boolean setReadOnlyImpl(byte[] var1);

    public long length() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        return this.lengthImpl(this.properPath(true));
    }

    private native long lengthImpl(byte[] var1);

    public String[] list() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (!this.isDirectory()) {
            return null;
        }
        byte[][] implList = File.listImpl(this.properPath(true));
        if (implList == null) {
            return new String[0];
        }
        String[] result = new String[implList.length];
        int index = 0;
        while (index < implList.length) {
            result[index] = Util.toString(implList[index]);
            ++index;
        }
        return result;
    }

    public File[] listFiles() {
        String[] tempNames = this.list();
        if (tempNames == null) {
            return null;
        }
        int resultLength = tempNames.length;
        File[] results = new File[resultLength];
        int i = 0;
        while (i < resultLength) {
            results[i] = new File(this, tempNames[i]);
            ++i;
        }
        return results;
    }

    public File[] listFiles(FilenameFilter filter) {
        String[] tempNames = this.list(filter);
        if (tempNames == null) {
            return null;
        }
        int resultLength = tempNames.length;
        File[] results = new File[resultLength];
        int i = 0;
        while (i < resultLength) {
            results[i] = new File(this, tempNames[i]);
            ++i;
        }
        return results;
    }

    public File[] listFiles(FileFilter filter) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (!this.isDirectory()) {
            return null;
        }
        byte[][] implList = File.listImpl(this.properPath(true));
        if (implList == null) {
            return new File[0];
        }
        Vector tempResult = new Vector();
        int index = 0;
        while (index < implList.length) {
            String aName = Util.toString(implList[index]);
            File aFile = new File(this, aName);
            if (filter == null || filter.accept(aFile)) {
                tempResult.addElement(aFile);
            }
            ++index;
        }
        Object[] result = new File[tempResult.size()];
        tempResult.copyInto(result);
        return result;
    }

    public String[] list(FilenameFilter filter) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.path);
        }
        if (!this.isDirectory()) {
            return null;
        }
        byte[][] implList = File.listImpl(this.properPath(true));
        if (implList == null) {
            return new String[0];
        }
        Vector tempResult = new Vector();
        int index = 0;
        while (index < implList.length) {
            String aName = Util.toString(implList[index]);
            if (filter == null || filter.accept(this, aName)) {
                tempResult.addElement(aName);
            }
            ++index;
        }
        Object[] result = new String[tempResult.size()];
        tempResult.copyInto(result);
        return result;
    }

    private static synchronized native byte[][] listImpl(byte[] var0);

    public boolean mkdir() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        return this.mkdirImpl(this.properPath(true));
    }

    private native boolean mkdirImpl(byte[] var1);

    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        String parentDir = this.getParent();
        if (parentDir == null) {
            return false;
        }
        return new File(parentDir).mkdirs() && this.mkdir();
    }

    public boolean createNewFile() throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
        }
        int result = this.newFileImpl(this.properPath(true));
        switch (result) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 3: {
                throw new IOException(Msg.getString("K01c1"));
            }
        }
        throw new IOException(Msg.getString("K01c2", this.path));
    }

    private native int newFileImpl(byte[] var1);

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (prefix != null) {
            if (prefix.length() >= 3) {
                File result;
                File tmpDirFile;
                String newSuffix = suffix == null ? ".tmp" : suffix;
                String tmpDir = ".";
                tmpDir = (String)AccessController.doPrivileged(new PriviAction("java.io.tmpdir", "."));
                File file = tmpDirFile = directory == null ? new File(tmpDir) : directory;
                while (!(result = File.genTempFile(prefix, newSuffix, tmpDirFile)).createNewFile()) {
                }
                return result;
            }
            throw new IllegalArgumentException(Msg.getString("K006b"));
        }
        throw new NullPointerException();
    }

    private static File genTempFile(String prefix, String suffix, File directory) {
        if (counter == 0) {
            int newInt = new Random().nextInt();
            counter = (newInt / 65535 & 0xFFFF) + 10000;
        }
        StringBuffer newName = new StringBuffer();
        newName.append(prefix);
        newName.append(counter++);
        newName.append(suffix);
        return new File(directory, newName.toString());
    }

    byte[] properPath(boolean internal) {
        if (this.properPath != null) {
            return this.properPath;
        }
        byte[] pathBytes = Util.getBytes(this.path);
        if (this.isAbsoluteImpl(pathBytes)) {
            this.properPath = pathBytes;
            return pathBytes;
        }
        String userdir = internal ? (String)AccessController.doPrivileged(new PriviAction("user.dir")) : System.getProperty("user.dir");
        this.properPath = File.properPathImpl(pathBytes);
        if (this.properPath != null) {
            return this.properPath;
        }
        if (this.path.length() == 0) {
            this.properPath = Util.getBytes(userdir);
            return this.properPath;
        }
        int length = userdir.length();
        if (this.path.charAt(0) == '\\' && separatorChar != '/') {
            if (length > 1 && userdir.charAt(1) == ':') {
                this.properPath = Util.getBytes(String.valueOf(userdir.substring(0, 2)) + this.path);
                return this.properPath;
            }
            if (length > 0 && userdir.charAt(length - 1) == separatorChar) {
                this.properPath = Util.getBytes(String.valueOf(userdir) + this.path.substring(1));
                return this.properPath;
            }
            this.properPath = Util.getBytes(String.valueOf(userdir) + this.path);
            return this.properPath;
        }
        if (length > 0 && userdir.charAt(length - 1) == separatorChar) {
            this.properPath = Util.getBytes(String.valueOf(userdir) + this.path);
            return this.properPath;
        }
        this.properPath = Util.getBytes(String.valueOf(userdir) + separator + this.path);
        return this.properPath;
    }

    private static native byte[] properPathImpl(byte[] var0);

    public boolean renameTo(File dest) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(this.path);
            security.checkWrite(dest.path);
        }
        return this.renameToImpl(this.properPath(true), dest.properPath(true));
    }

    private native boolean renameToImpl(byte[] var1, byte[] var2);

    public String toString() {
        return this.path.toString();
    }

    public URI toURI() {
        String name = this.getAbsoluteName();
        try {
            if (!name.startsWith("/")) {
                return new URI("file", null, new StringBuffer(name.length() + 1).append('/').append(name).toString(), null, null);
            }
            if (name.startsWith("//")) {
                return new URI("file", name, null);
            }
            return new URI("file", null, name, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URL toURL() throws MalformedURLException {
        String name = this.getAbsoluteName();
        if (!name.startsWith("/")) {
            return new URL("file", "", -1, new StringBuffer(name.length() + 1).append('/').append(name).toString(), null);
        }
        if (name.startsWith("//")) {
            return new URL("file:" + name);
        }
        return new URL("file", "", -1, name, null);
    }

    private String getAbsoluteName() {
        String name = this.getAbsolutePath();
        if (this.isDirectory() && name.charAt(name.length() - 1) != separatorChar) {
            name = new StringBuffer(name.length() + 1).append(name).append('/').toString();
        }
        if (separatorChar != '/') {
            name = name.replace(separatorChar, '/');
        }
        return name;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeChar(separatorChar);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        char inSeparator = stream.readChar();
        this.path = this.path.replace(inSeparator, separatorChar);
    }
}

