/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class InputStream {
    private static byte[] skipBuf;

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public abstract int read() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (offset <= b.length && offset >= 0 && length >= 0 && length <= b.length - offset) {
            int i = 0;
            while (i < length) {
                int c;
                try {
                    c = this.read();
                    if (c == -1) {
                        return i == 0 ? -1 : i;
                    }
                }
                catch (IOException e) {
                    if (i != 0) {
                        return i;
                    }
                    throw e;
                }
                b[offset + i] = (byte)c;
                ++i;
            }
            return length;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    public long skip(long n) throws IOException {
        int toRead;
        if (n <= 0L) {
            return 0L;
        }
        long skipped = 0L;
        int n2 = toRead = n < 4096L ? (int)n : 4096;
        if (skipBuf == null || skipBuf.length < toRead) {
            skipBuf = new byte[toRead];
        }
        while (skipped < n) {
            int read = this.read(skipBuf, 0, toRead);
            if (read == -1) {
                return skipped;
            }
            skipped += (long)read;
            if (read < toRead) {
                return skipped;
            }
            if (n - skipped >= (long)toRead) continue;
            toRead = (int)(n - skipped);
        }
        return skipped;
    }
}

