/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.PriviAction;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.StringTokenizer;

public class SecurityManager {
    private static volatile String[] securePackageList = new String[0];
    private static volatile String packageAccess;
    private PropertyPermission permissionToReadWriteAllProperties = new PropertyPermission("*", "read,write");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SecurityManager() {
        Class clazz;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToCreateSecurityManager);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.security.Security");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public void checkAccept(String host, int port) {
        if (host == null) {
            throw new NullPointerException();
        }
        this.checkPermission(new SocketPermission(String.valueOf(host) + ':' + port, "accept"));
    }

    public void checkAccess(Thread thread) {
        ThreadGroup group = thread.getThreadGroup();
        if (group != null && group.parent == null) {
            this.checkPermission(RuntimePermission.permissionToModifyThread);
        }
    }

    public void checkAccess(ThreadGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        if (group.parent == null) {
            this.checkPermission(RuntimePermission.permissionToModifyThreadGroup);
        }
    }

    public void checkConnect(String host, int port) {
        if (host == null) {
            throw new NullPointerException();
        }
        if (port > 0) {
            this.checkPermission(new SocketPermission(String.valueOf(host) + ':' + port, "connect"));
        } else {
            this.checkPermission(new SocketPermission(host, "resolve"));
        }
    }

    public void checkConnect(String host, int port, Object context) {
        if (port > 0) {
            this.checkPermission(new SocketPermission(String.valueOf(host) + ':' + port, "connect"), context);
        } else {
            this.checkPermission(new SocketPermission(host, "resolve"), context);
        }
    }

    public void checkCreateClassLoader() {
        this.checkPermission(RuntimePermission.permissionToCreateClassLoader);
    }

    public void checkDelete(String file) {
        this.checkPermission(new FilePermission(file, "delete"));
    }

    public void checkExec(String cmd) {
        this.checkPermission(new FilePermission(new File(cmd).isAbsolute() ? cmd : "<<ALL FILES>>", "execute"));
    }

    public void checkExit(int status) {
        this.checkPermission(RuntimePermission.permissionToExitVM);
    }

    public void checkLink(String libName) {
        if (libName == null) {
            throw new NullPointerException();
        }
        this.checkPermission(new RuntimePermission("loadLibrary." + libName));
    }

    public void checkListen(int port) {
        if (port == 0) {
            this.checkPermission(new SocketPermission("localhost:1024-", "listen"));
        } else {
            this.checkPermission(new SocketPermission("localhost:" + port, "listen"));
        }
    }

    public void checkMemberAccess(Class cls, int type) {
        if (cls == null) {
            throw new NullPointerException();
        }
        if (type == 0) {
            return;
        }
        if (ClassLoader.getStackClassLoader(3) == cls.getClassLoaderImpl()) {
            return;
        }
        this.checkPermission(new RuntimePermission("accessDeclaredMembers"));
    }

    public void checkMulticast(InetAddress maddr) {
        this.checkPermission(new SocketPermission(maddr.getHostAddress(), "accept,connect"));
    }

    public void checkMulticast(InetAddress maddr, byte ttl) {
        this.checkPermission(new SocketPermission(maddr.getHostAddress(), "accept,connect"));
    }

    public void checkPackageAccess(String packageName) {
        String[] packageList;
        if (packageName == null) {
            throw new NullPointerException();
        }
        String securePackages = this.getSecurityProperty("package.access");
        if (securePackages != packageAccess) {
            if (securePackages != null) {
                StringTokenizer tokenizer = new StringTokenizer(securePackages, ", ");
                int i = 0;
                packageList = new String[tokenizer.countTokens()];
                while (tokenizer.hasMoreTokens()) {
                    packageList[i++] = tokenizer.nextToken();
                }
                packageAccess = securePackages;
            } else {
                packageList = new String[]{};
            }
            securePackageList = packageList;
        } else {
            packageList = securePackageList;
        }
        int i = 0;
        while (i < packageList.length) {
            if (packageName.startsWith(packageList[i])) {
                this.checkPermission(new RuntimePermission("accessClassInPackage." + packageName));
                return;
            }
            ++i;
        }
    }

    public void checkPackageDefinition(String packageName) {
        if (packageName == null) {
            throw new NullPointerException();
        }
        String securePackages = this.getSecurityProperty("package.definition");
        if (securePackages != null) {
            StringTokenizer tokenizer = new StringTokenizer(securePackages, ", ");
            while (tokenizer.hasMoreTokens()) {
                if (!packageName.startsWith(tokenizer.nextToken())) continue;
                this.checkPermission(new RuntimePermission("defineClassInPackage." + packageName));
                return;
            }
        }
    }

    private String getSecurityProperty(String property) {
        return (String)AccessController.doPrivileged(PriviAction.getSecurityProperty(property));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(this.permissionToReadWriteAllProperties);
    }

    public void checkPropertyAccess(String key) {
        this.checkPermission(new PropertyPermission(key, "read"));
    }

    public void checkRead(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException();
        }
        this.checkPermission(RuntimePermission.permissionToReadFileDescriptor);
    }

    public void checkRead(String file) {
        this.checkPermission(new FilePermission(file, "read"));
    }

    public void checkRead(String file, Object context) {
        this.checkPermission(new FilePermission(file, "read"), context);
    }

    public void checkSecurityAccess(String target) {
        this.checkPermission(new SecurityPermission(target));
    }

    public void checkSetFactory() {
        this.checkPermission(RuntimePermission.permissionToSetFactory);
    }

    public boolean checkTopLevelWindow(Object window) {
        if (window == null) {
            throw new NullPointerException();
        }
        try {
            Class awtPermission = Class.forName("java.awt.AWTPermission");
            Class[] classArray = new Class[1];
            Class clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] args = classArray;
            Constructor constructor = awtPermission.getConstructor(args);
            Object[] constructorArgs = new Object[]{"showWindowWithoutWarningBanner"};
            Permission perm = (Permission)constructor.newInstance(constructorArgs);
            this.checkPermission(perm);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void checkSystemClipboardAccess() {
        try {
            Class awtPermission = Class.forName("java.awt.AWTPermission");
            Class[] classArray = new Class[1];
            Class clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] args = classArray;
            Constructor constructor = awtPermission.getConstructor(args);
            Object[] constructorArgs = new Object[]{"accessClipboard"};
            Permission perm = (Permission)constructor.newInstance(constructorArgs);
            this.checkPermission(perm);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        throw new SecurityException();
    }

    public void checkAwtEventQueueAccess() {
        try {
            Class awtPermission = Class.forName("java.awt.AWTPermission");
            Class[] classArray = new Class[1];
            Class clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] ar = classArray;
            Constructor constructor = awtPermission.getConstructor(ar);
            Object[] constructorArgs = new Object[]{"accessEventQueue"};
            Permission perm = (Permission)constructor.newInstance(constructorArgs);
            this.checkPermission(perm);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        throw new SecurityException();
    }

    public void checkPrintJobAccess() {
        this.checkPermission(RuntimePermission.permissionToQueuePrintJob);
    }

    public void checkWrite(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException();
        }
        this.checkPermission(RuntimePermission.permissionToWriteFileDescriptor);
    }

    public void checkWrite(String file) {
        this.checkPermission(new FilePermission(file, "write"));
    }

    protected Class[] getClassContext() {
        return Class.getStackClasses(-1, false);
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public void checkPermission(Permission permission) {
        AccessController.checkPermission(permission);
    }

    public void checkPermission(Permission permission, Object context) {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException();
        }
        ((AccessControlContext)context).checkPermission(permission);
    }
}

