/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.SystemProperties;
import com.ibm.oti.util.SystemPropertiesHook;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Properties;
import java.util.PropertyPermission;

public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static final Runtime RUNTIME;
    private static Properties systemProperties;
    private static SecurityManager security;
    private static final int InitLocale = 0;
    private static final int PlatformEncoding = 1;
    private static final int FileEncoding = 2;
    private static final int OSEncoding = 3;

    static {
        RUNTIME = Runtime.getRuntime();
        System.ensureProperties();
        err = new String.ConsolePrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)));
        out = new String.ConsolePrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)));
        in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
    }

    static void completeInitialization() {
        String extraLibs = (String)systemProperties.get("com.ibm.util.extralibs.properties");
        if (extraLibs != null) {
            int lastIndex = 0;
            while (lastIndex < extraLibs.length()) {
                int index = extraLibs.indexOf(58, lastIndex);
                if (index == -1) {
                    index = extraLibs.length();
                }
                String libName = extraLibs.substring(lastIndex, index).trim();
                lastIndex = index + 1;
                if (libName.length() == 0) continue;
                try {
                    String extensionName = "com.ibm.oti." + libName + ".SystemPropertyExtension";
                    Class extensionCls = Class.forName(extensionName);
                    Object extension = extensionCls.newInstance();
                    try {
                        if (extension instanceof SystemPropertiesHook) {
                            systemProperties = (Properties)((SystemPropertiesHook)extension).extendSystemProperties(systemProperties);
                            continue;
                        }
                        ((SystemProperties)extension).extendSystemProperties(systemProperties);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        System.installSecurityManager();
    }

    private static void installSecurityManager() {
        String clName;
        if (System.getSecurityManager() == null && (clName = System.getProperty("java.security.manager")) != null) {
            SecurityManager sm = null;
            if (clName.length() == 0) {
                sm = new SecurityManager();
            } else {
                try {
                    Class cl = Class.forName(clName);
                    sm = (SecurityManager)cl.newInstance();
                }
                catch (Exception exception) {
                    throw new InternalError(Msg.getString("K00e3", clName));
                }
            }
            System.setSecurityManager(sm);
        }
    }

    public static void setIn(InputStream newIn) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("in", newIn);
    }

    public static void setOut(PrintStream newOut) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("out", newOut);
    }

    public static void setErr(PrintStream newErr) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("err", newErr);
    }

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void arraycopy(Object[] A1, int offset1, Object[] A2, int offset2, int length) {
        if (A1 == null || A2 == null) {
            throw new NullPointerException();
        }
        if (offset1 >= 0 && offset2 >= 0 && length >= 0 && length <= A1.length - offset1 && length <= A2.length - offset2) {
            if (A1 != A2 || offset1 > offset2 || offset1 + length <= offset2) {
                int i = 0;
                while (i < length) {
                    A2[offset2 + i] = A1[offset1 + i];
                    ++i;
                }
            } else {
                int i = length - 1;
                while (i >= 0) {
                    A2[offset2 + i] = A1[offset1 + i];
                    --i;
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static native long currentTimeMillis();

    private static void ensureProperties() {
        String fileEncoding;
        systemProperties = new Properties();
        String platformEncoding = null;
        String osEncoding = null;
        String definedFileEncoding = System.getEncoding(2);
        String definedOSEncoding = System.getEncoding(3);
        if (definedFileEncoding != null) {
            fileEncoding = definedFileEncoding;
            if (definedOSEncoding == null) {
                osEncoding = platformEncoding = System.getEncoding(1);
            } else {
                System.getEncoding(0);
            }
        } else {
            fileEncoding = platformEncoding = System.getEncoding(1);
        }
        if (osEncoding == null) {
            osEncoding = definedOSEncoding;
        }
        if (osEncoding != null) {
            systemProperties.put("os.encoding", osEncoding);
        }
        systemProperties.put("file.encoding", fileEncoding);
        systemProperties.put("microedition.commports", System.getCommPortList());
        systemProperties.put("java.specification.vendor", "Sun Microsystems Inc.");
        systemProperties.put("java.specification.name", "J2ME Foundation Specification");
        systemProperties.put("java.specification.version", "1.1");
        systemProperties.put("java.version", "J2ME Foundation Specification v1.1");
        systemProperties.put("com.ibm.oti.configuration", "foun11");
        systemProperties.put("com.ibm.oti.configuration.dir", "jclFoundation11");
        String[] list = System.getPropertyList();
        int i = 0;
        while (i < list.length) {
            String key = list[i];
            if (key == null) break;
            systemProperties.put(key, list[i + 1]);
            i += 2;
        }
        String consoleEncoding = (String)systemProperties.get("console.encoding");
        if (consoleEncoding == null) {
            if (platformEncoding == null) {
                platformEncoding = System.getEncoding(1);
            }
            consoleEncoding = platformEncoding;
            systemProperties.put("console.encoding", consoleEncoding);
        }
        systemProperties.put("com.ibm.oti.jcl.build", "20120518_0913");
    }

    public static void exit(int code) {
        RUNTIME.exit(code);
    }

    public static void gc() {
        RUNTIME.gc();
    }

    public static Properties getProperties() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        return systemProperties;
    }

    static Properties internalGetProperties() {
        return systemProperties;
    }

    public static String getProperty(String prop) {
        return System.getProperty(prop, null);
    }

    public static String getProperty(String prop, String defaultValue) {
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertyAccess(prop);
        }
        return systemProperties.getProperty(prop, defaultValue);
    }

    public static String setProperty(String prop, String value) {
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(prop, "write"));
        }
        return (String)systemProperties.setProperty(prop, value);
    }

    private static native String[] getPropertyList();

    private static native String getCommPortList();

    private static native String getEncoding(int var0);

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native int identityHashCode(Object var0);

    public static void load(String pathName) {
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkLink(pathName);
        }
        ClassLoader.loadLibraryWithPath(pathName, ClassLoader.callerClassLoader(), null);
    }

    public static void loadLibrary(String libName) {
        ClassLoader.loadLibraryWithClassLoader(libName, ClassLoader.callerClassLoader());
    }

    public static void runFinalization() {
        RUNTIME.runFinalization();
    }

    public static void setProperties(Properties p) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        if (p == null) {
            System.ensureProperties();
        } else {
            systemProperties = p;
        }
    }

    public static void setSecurityManager(final SecurityManager s) {
        final SecurityManager currentSecurity = security;
        if (s != null) {
            try {
                s.checkPackageAccess("java.lang");
            }
            catch (Exception exception) {}
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ProtectionDomain newDomain;
                        ProtectionDomain oldDomain = null;
                        if (currentSecurity != null) {
                            oldDomain = currentSecurity.getClass().getPDImpl();
                        }
                        if ((newDomain = s.getClass().getPDImpl()) != null && newDomain != oldDomain) {
                            Msg.getString("K002c");
                            newDomain.implies(new AllPermission());
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {}
        }
        if (currentSecurity != null) {
            currentSecurity.checkPermission(RuntimePermission.permissionToSetSecurityManager);
        }
        security = s;
    }

    public static native String mapLibraryName(String var0);

    private static native void setFieldImpl(String var0, Object var1);
}

