/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.ibm.oti.util.Msg;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ReflectPermission;

public class AccessibleObject {
    private static final ReflectPermission suppressAccessChecksPermission = new ReflectPermission("suppressAccessChecks");
    static final Object[] emptyArgs = new Object[0];
    private int vm1;

    protected AccessibleObject() {
    }

    public boolean isAccessible() {
        return this.getAccessibleImpl();
    }

    public static void setAccessible(AccessibleObject[] objects, boolean flag) throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(suppressAccessChecksPermission);
        }
        int i = 0;
        while (i < objects.length) {
            objects[i].setAccessibleImpl(flag);
            ++i;
        }
    }

    public void setAccessible(boolean flag) throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(suppressAccessChecksPermission);
        }
        this.setAccessibleImpl(flag);
    }

    static Object[] marshallArguments(Class[] parameterTypes, Object[] args) throws IllegalArgumentException {
        if (parameterTypes.length != args.length) {
            throw new IllegalArgumentException(Msg.getString("K01b3"));
        }
        Object[] marshalledArgs = args;
        int i = args.length - 1;
        while (i >= 0) {
            Object arg = args[i];
            Class type = parameterTypes[i];
            Object marshalledArg = AccessibleObject.marshallArgument(arg, type);
            if (marshalledArg != arg) {
                if (marshalledArgs == args) {
                    marshalledArgs = (Object[])args.clone();
                }
                marshalledArgs[i] = marshalledArg;
            }
            --i;
        }
        return marshalledArgs;
    }

    private static Object marshallArgument(Object arg, Class type) throws IllegalArgumentException {
        if (type.isPrimitive()) {
            if (arg instanceof Boolean) {
                if (type == Boolean.TYPE) {
                    return arg;
                }
            } else if (arg instanceof Character) {
                if (type == Character.TYPE) {
                    return arg;
                }
                char charValue = ((Character)arg).charValue();
                if (type == Integer.TYPE) {
                    return new Integer(charValue);
                }
                if (type == Long.TYPE) {
                    return new Long(charValue);
                }
                if (type == Double.TYPE) {
                    return new Double(charValue);
                }
                if (type == Float.TYPE) {
                    return new Float(charValue);
                }
            } else if (arg instanceof Byte) {
                if (type == Byte.TYPE) {
                    return arg;
                }
                if (type == Short.TYPE) {
                    return arg;
                }
                if (type == Integer.TYPE) {
                    return arg;
                }
                Number result = AccessibleObject.coerce((Number)arg, type);
                if (result != null) {
                    return result;
                }
            } else if (arg instanceof Short) {
                if (type == Short.TYPE) {
                    return arg;
                }
                if (type == Integer.TYPE) {
                    return arg;
                }
                Number result = AccessibleObject.coerce((Number)arg, type);
                if (result != null) {
                    return result;
                }
            } else if (arg instanceof Integer) {
                if (type == Integer.TYPE) {
                    return arg;
                }
                Number result = AccessibleObject.coerce((Number)arg, type);
                if (result != null) {
                    return result;
                }
            } else if (arg instanceof Long) {
                if (type == Long.TYPE) {
                    return arg;
                }
                Number result = AccessibleObject.coerce((Number)arg, type);
                if (result != null) {
                    return result;
                }
            } else if (arg instanceof Float) {
                if (type == Float.TYPE) {
                    return arg;
                }
                if (type == Double.TYPE) {
                    return new Double(((Number)arg).doubleValue());
                }
            } else if (arg instanceof Double) {
                if (type == Double.TYPE) {
                    return arg;
                }
            } else if (arg == null) {
                throw new NullPointerException();
            }
        } else if (arg == null || type.isInstance(arg)) {
            return arg;
        }
        String className = null;
        if (arg != null) {
            className = arg.getClass().getName();
        }
        throw new IllegalArgumentException(Msg.getString("K01b4", className, type.getName()));
    }

    private static Number coerce(Number source, Class primitiveType) {
        if (primitiveType == Double.TYPE) {
            return new Double(source.doubleValue());
        }
        if (primitiveType == Float.TYPE) {
            return new Float(source.floatValue());
        }
        if (primitiveType == Long.TYPE) {
            return new Long(source.longValue());
        }
        return null;
    }

    void invokeV(Object receiver, Object[] args) throws InvocationTargetException {
        try {
            this.invokeImpl(receiver, args, (Void)null);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    Object invokeL(Object receiver, Object[] args) throws InvocationTargetException {
        try {
            return this.invokeImpl(receiver, args, (Object)null);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    int invokeI(Object receiver, Object[] args) throws InvocationTargetException {
        try {
            return this.invokeImpl(receiver, args, (Integer)null);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    long invokeJ(Object receiver, Object[] args) throws InvocationTargetException {
        try {
            return this.invokeImpl(receiver, args, (Long)null);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    float invokeF(Object receiver, Object[] args) throws InvocationTargetException {
        try {
            return this.invokeImpl(receiver, args, (Float)null);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    double invokeD(Object receiver, Object[] args) throws InvocationTargetException {
        try {
            return this.invokeImpl(receiver, args, (Double)null);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    private native boolean getAccessibleImpl();

    private native void setAccessibleImpl(boolean var1);

    native Class[] getParameterTypesImpl();

    native int getModifiers();

    native Class[] getExceptionTypesImpl();

    native String getSignature();

    native boolean checkAccessibility(Class var1, Object var2);

    private native Object invokeImpl(Object var1, Object[] var2, Object var3) throws Throwable;

    private native double invokeImpl(Object var1, Object[] var2, Double var3) throws Throwable;

    private native float invokeImpl(Object var1, Object[] var2, Float var3) throws Throwable;

    private native int invokeImpl(Object var1, Object[] var2, Integer var3) throws Throwable;

    private native long invokeImpl(Object var1, Object[] var2, Long var3) throws Throwable;

    private native void invokeImpl(Object var1, Object[] var2, Void var3) throws Throwable;

    static native void initializeClass(Class var0) throws Throwable;

    static final native Class getStackClass(int var0);
}

