/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainServerSocketImpl;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public class ServerSocket {
    SocketImpl impl;
    static SocketImplFactory factory;
    private volatile boolean isCreated = false;
    private boolean isBound = false;
    private boolean isClosed = false;

    public ServerSocket() throws IOException {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainServerSocketImpl();
    }

    public ServerSocket(int aport) throws IOException {
        this(aport, ServerSocket.defaultBacklog(), InetAddress.ANY);
    }

    public ServerSocket(int aport, int backlog) throws IOException {
        this(aport, backlog, InetAddress.ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket(int aport, int backlog, InetAddress localAddr) throws IOException {
        this.checkListen(aport);
        this.impl = factory != null ? factory.createSocketImpl() : new PlainServerSocketImpl();
        InetAddress addr = localAddr == null ? InetAddress.ANY : localAddr;
        ServerSocket serverSocket = this;
        synchronized (serverSocket) {
            this.impl.create(true);
            this.isCreated = true;
            try {
                this.impl.bind(addr, aport);
                this.isBound = true;
                this.impl.listen(backlog > 0 ? backlog : ServerSocket.defaultBacklog());
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() throws IOException {
        this.checkClosedAndCreate(false);
        if (!this.isBound()) {
            throw new SocketException(Msg.getString("K031f"));
        }
        if (PlainSocketImpl.usingSocks()) {
            if (this.impl instanceof PlainSocketImpl) {
                try {
                    SecurityManager security = System.getSecurityManager();
                    if (security != null) {
                        security.checkAccept(this.getInetAddress().getHostAddress(), this.getLocalPort());
                    }
                }
                catch (SecurityException e) {
                    this.close();
                    throw e;
                }
                ((PlainSocketImpl)this.impl).socksAccept();
                return new Socket(this.impl);
            }
            throw new IOException(Msg.getString("K0041"));
        }
        Socket aSocket = new Socket();
        try {
            ServerSocket serverSocket = this;
            synchronized (serverSocket) {
                this.implAccept(aSocket);
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkAccept(aSocket.getInetAddress().getHostAddress(), aSocket.getPort());
            }
        }
        catch (SecurityException e) {
            aSocket.close();
            throw e;
        }
        catch (IOException e) {
            aSocket.close();
            throw e;
        }
        return aSocket;
    }

    void checkListen(int aPort) {
        if (aPort < 0 || aPort > 65535) {
            throw new IllegalArgumentException(Msg.getString("K0325", aPort));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkListen(aPort);
        }
    }

    public void close() throws IOException {
        this.isClosed = true;
        this.impl.close();
    }

    static int defaultBacklog() {
        return 50;
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.impl.getInetAddress();
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.impl.getLocalPort();
    }

    public synchronized int getSoTimeout() throws IOException {
        this.checkClosedAndCreate(true);
        return (Integer)this.impl.getOption(4102);
    }

    protected final void implAccept(Socket aSocket) throws IOException {
        this.impl.accept(aSocket.impl);
        aSocket.accepted();
    }

    public static synchronized void setSocketFactory(SocketImplFactory aFactory) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        if (factory != null) {
            throw new SocketException(Msg.getString("K0042"));
        }
        factory = aFactory;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.checkClosedAndCreate(true);
        if (timeout < 0) {
            throw new IllegalArgumentException(Msg.getString("K0036"));
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public String toString() {
        StringBuffer result = new StringBuffer(64);
        result.append("ServerSocket[");
        if (!this.isBound()) {
            return result.append("unbound]").toString();
        }
        return result.append("addr=").append(this.getInetAddress()).append(",port=0,localport=").append(this.getLocalPort()).append("]").toString();
    }

    public void bind(SocketAddress localAddr) throws IOException {
        this.bind(localAddr, ServerSocket.defaultBacklog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress localAddr, int backlog) throws IOException {
        SecurityManager security;
        this.checkClosedAndCreate(true);
        if (this.isBound()) {
            throw new BindException(Msg.getString("K0315"));
        }
        int port = 0;
        InetAddress addr = InetAddress.ANY;
        if (localAddr != null) {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException(Msg.getString("K0316", localAddr.getClass()));
            }
            InetSocketAddress inetAddr = (InetSocketAddress)localAddr;
            addr = inetAddr.getAddress();
            if (addr == null) {
                throw new SocketException(Msg.getString("K0317", inetAddr.getHostName()));
            }
            port = inetAddr.getPort();
        }
        if ((security = System.getSecurityManager()) != null) {
            security.checkListen(port);
        }
        ServerSocket serverSocket = this;
        synchronized (serverSocket) {
            try {
                this.impl.bind(addr, port);
                this.isBound = true;
                this.impl.listen(backlog > 0 ? backlog : ServerSocket.defaultBacklog());
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClosedAndCreate(boolean create) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException(Msg.getString("K003d"));
        }
        if (!create || this.isCreated) {
            return;
        }
        ServerSocket serverSocket = this;
        synchronized (serverSocket) {
            if (this.isCreated) {
                return;
            }
            try {
                this.impl.create(true);
            }
            catch (SocketException e) {
                throw e;
            }
            catch (IOException e) {
                throw new SocketException(e.toString());
            }
            this.isCreated = true;
        }
    }

    public void setReuseAddress(boolean reuse) throws SocketException {
        this.checkClosedAndCreate(true);
        this.impl.setOption(4, reuse ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getReuseAddress() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Boolean)this.impl.getOption(4);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.checkClosedAndCreate(true);
        if (size < 1) {
            throw new IllegalArgumentException(Msg.getString("K0035"));
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public int getReceiveBufferSize() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Integer)this.impl.getOption(4098);
    }
}

