/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;

class URIEncoderDecoder {
    static final String digits = "0123456789ABCDEF";
    static final String encoding = "UTF8";

    URIEncoderDecoder() {
    }

    static void validate(String s, String legal) throws URISyntaxException {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '%') {
                do {
                    if (i + 2 >= s.length()) {
                        throw new URISyntaxException(s, Msg.getString("K0313"), i);
                    }
                    int d1 = Character.digit(s.charAt(i + 1), 16);
                    int d2 = Character.digit(s.charAt(i + 2), 16);
                    if (d1 != -1 && d2 != -1) continue;
                    throw new URISyntaxException(s, Msg.getString("K0314", s.substring(i, i + 3)), i);
                } while ((i += 3) < s.length() && s.charAt(i) == '%');
                continue;
            }
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || legal.indexOf(ch) > -1 || ch > '\u007f' && !Character.isSpaceChar(ch) && !Character.isISOControl(ch))) {
                throw new URISyntaxException(s, Msg.getString("K00c1"), i);
            }
            ++i;
        }
    }

    static void validateSimple(String s, String legal) throws URISyntaxException {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || legal.indexOf(ch) > -1)) {
                throw new URISyntaxException(s, Msg.getString("K00c1"), i);
            }
            ++i;
        }
    }

    static String quoteIllegal(String s, String legal) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || legal.indexOf(ch) > -1 || ch > '\u007f' && !Character.isSpaceChar(ch) && !Character.isISOControl(ch)) {
                buf.append(ch);
            } else {
                byte[] bytes = new String(new char[]{ch}).getBytes(encoding);
                int j = 0;
                while (j < bytes.length) {
                    buf.append('%');
                    buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
                    buf.append(digits.charAt(bytes[j] & 0xF));
                    ++j;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    static String encodeOthers(String s) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                buf.append(ch);
            } else {
                byte[] bytes = new String(new char[]{ch}).getBytes(encoding);
                int j = 0;
                while (j < bytes.length) {
                    buf.append('%');
                    buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
                    buf.append(digits.charAt(bytes[j] & 0xF));
                    ++j;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    static String decode(String s) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= s.length()) {
                        throw new IllegalArgumentException(Msg.getString("K01fe", i));
                    }
                    int d1 = Character.digit(s.charAt(i + 1), 16);
                    int d2 = Character.digit(s.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException(Msg.getString("K01ff", s.substring(i, i + 3), String.valueOf(i)));
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < s.length() && s.charAt(i) == '%');
                result.append(out.toString(encoding));
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }
}

