/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class URL
implements Serializable {
    private static final long serialVersionUID = -7627629688361524110L;
    private static final NetPermission specifyStreamHandlerPermission = new NetPermission("specifyStreamHandler");
    private int hashCode;
    private String file;
    private String protocol = null;
    private String host;
    private int port = -1;
    private String authority = null;
    private transient String userInfo = null;
    private transient String path = null;
    private transient String query = null;
    private String ref = null;
    private static Hashtable streamHandlers = new Hashtable();
    transient URLStreamHandler strmHandler;
    private static URLStreamHandlerFactory streamHandlerFactory;

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory streamFactory) {
        if (streamHandlerFactory != null) {
            throw new Error(Msg.getString("K004b"));
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        streamHandlers.clear();
        streamHandlerFactory = streamFactory;
    }

    public URL(String spec) throws MalformedURLException {
        this((URL)null, spec, (URLStreamHandler)null);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        int index;
        if (handler != null) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(specifyStreamHandlerPermission);
            }
            this.strmHandler = handler;
        }
        if (spec == null) {
            throw new MalformedURLException();
        }
        spec = spec.trim();
        try {
            index = spec.indexOf(58);
        }
        catch (NullPointerException e) {
            throw new MalformedURLException(e.toString());
        }
        int startIPv6Addr = spec.indexOf(91);
        if (index >= 0 && (startIPv6Addr == -1 || index < startIPv6Addr)) {
            this.protocol = spec.substring(0, index);
            if (this.protocol.indexOf(47) >= 0) {
                this.protocol = null;
                index = -1;
            } else {
                this.protocol = this.protocol.toLowerCase();
            }
        }
        if (this.protocol != null) {
            if (context != null && this.protocol.equals(context.getProtocol())) {
                String cPath = context.getPath();
                if (cPath != null && cPath.startsWith("/")) {
                    this.set(this.protocol, context.getHost(), context.getPort(), context.getAuthority(), context.getUserInfo(), cPath, context.getQuery(), null);
                }
                if (this.strmHandler == null) {
                    this.strmHandler = context.strmHandler;
                }
            }
        } else {
            if (context == null) {
                throw new MalformedURLException(Msg.getString("K00b3", spec));
            }
            this.set(context.getProtocol(), context.getHost(), context.getPort(), context.getAuthority(), context.getUserInfo(), context.getPath(), context.getQuery(), null);
            if (this.strmHandler == null) {
                this.strmHandler = context.strmHandler;
            }
        }
        if (this.strmHandler == null) {
            this.setupStreamHandler();
            if (this.strmHandler == null) {
                throw new MalformedURLException(Msg.getString("K00b3", this.protocol));
            }
        }
        try {
            this.strmHandler.parseURL(this, spec, ++index, spec.length());
        }
        catch (Exception e) {
            throw new MalformedURLException(e.toString());
        }
        if (this.port < -1) {
            throw new MalformedURLException(Msg.getString("K0325", this.port));
        }
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file, null);
    }

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        if (port < -1) {
            throw new MalformedURLException(Msg.getString("K0325", port));
        }
        if (host != null && host.indexOf(":") != -1 && host.charAt(0) != '[') {
            host = "[" + host + "]";
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        int index = -1;
        index = file.indexOf("#", file.lastIndexOf("/"));
        if (index >= 0) {
            this.file = file.substring(0, index);
            this.ref = file.substring(index + 1);
        } else {
            this.file = file;
        }
        this.fixURL(false);
        if (handler == null) {
            this.setupStreamHandler();
            if (this.strmHandler == null) {
                throw new MalformedURLException(Msg.getString("K00b3", protocol));
            }
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(specifyStreamHandlerPermission);
            }
            this.strmHandler = handler;
        }
    }

    void fixURL(boolean fixHost) {
        int index;
        if (this.host != null && this.host.length() > 0) {
            this.authority = this.host;
            if (this.port != -1) {
                this.authority = String.valueOf(this.authority) + ":" + this.port;
            }
        }
        if (fixHost) {
            if (this.host != null && (index = this.host.lastIndexOf(64)) > -1) {
                this.userInfo = this.host.substring(0, index);
                this.host = this.host.substring(index + 1);
            } else {
                this.userInfo = null;
            }
        }
        if (this.file != null && (index = this.file.indexOf(63)) > -1) {
            this.query = this.file.substring(index + 1);
            this.path = this.file.substring(0, index);
        } else {
            this.query = null;
            this.path = this.file;
        }
    }

    protected void set(String protocol, String host, int port, String file, String ref) {
        if (this.protocol == null) {
            this.protocol = protocol;
        }
        this.host = host;
        this.file = file;
        this.port = port;
        this.ref = ref;
        this.hashCode = 0;
        this.fixURL(true);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.strmHandler.equals(this, (URL)o);
    }

    public boolean sameFile(URL otherURL) {
        return this.strmHandler.sameFile(this, otherURL);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.strmHandler.hashCode(this);
        }
        return this.hashCode;
    }

    void setupStreamHandler() {
        String packageList;
        this.strmHandler = (URLStreamHandler)streamHandlers.get(this.protocol);
        if (this.strmHandler != null) {
            return;
        }
        if (streamHandlerFactory != null) {
            this.strmHandler = streamHandlerFactory.createURLStreamHandler(this.protocol);
            if (this.strmHandler != null) {
                streamHandlers.put(this.protocol, this.strmHandler);
                return;
            }
        }
        if ((packageList = (String)AccessController.doPrivileged(new PriviAction("java.protocol.handler.pkgs"))) != null) {
            StringTokenizer st = new StringTokenizer(packageList, "|");
            while (st.hasMoreTokens()) {
                String className = String.valueOf(st.nextToken()) + "." + this.protocol + ".Handler";
                try {
                    this.strmHandler = (URLStreamHandler)Class.forName(className, true, ClassLoader.getSystemClassLoader()).newInstance();
                    streamHandlers.put(this.protocol, this.strmHandler);
                    return;
                }
                catch (Exception exception) {}
            }
        }
        try {
            String className = "com.ibm.oti.net.www.protocol." + this.protocol + ".Handler";
            this.strmHandler = (URLStreamHandler)Class.forName(className).newInstance();
            streamHandlers.put(this.protocol, this.strmHandler);
        }
        catch (Exception exception) {}
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] types) throws IOException {
        return this.openConnection().getContent(types);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public URLConnection openConnection() throws IOException {
        return this.strmHandler.openConnection(this);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        if (this.strmHandler == null) {
            return "unknown protocol(" + this.protocol + ")://" + this.host + this.file;
        }
        return this.strmHandler.toExternalForm(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            stream.defaultReadObject();
            if (this.host != null && this.authority == null) {
                this.fixURL(true);
            } else if (this.authority != null) {
                int index = this.authority.lastIndexOf(64);
                if (index > -1) {
                    this.userInfo = this.authority.substring(0, index);
                }
                if (this.file != null && (index = this.file.indexOf(63)) > -1) {
                    this.query = this.file.substring(index + 1);
                    this.path = this.file.substring(0, index);
                } else {
                    this.path = this.file;
                }
            }
            this.setupStreamHandler();
            if (this.strmHandler == null) {
                throw new IOException(Msg.getString("K00b3", this.protocol));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.toString());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getAuthority() {
        return this.authority;
    }

    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        String file = path;
        if (query != null && !query.equals("")) {
            file = file != null ? String.valueOf(file) + "?" + query : "?" + query;
        }
        this.set(protocol, host, port, file, ref);
        this.authority = authority;
        this.userInfo = userInfo;
        this.path = path;
        this.query = query;
    }

    URLStreamHandler getStreamHandler() {
        return this.strmHandler;
    }

    public int getDefaultPort() {
        return this.strmHandler.getDefaultPort();
    }
}

