/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.PriviAction;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;

public class ProtectionDomain {
    private CodeSource cs;
    private PermissionCollection pc;
    private ClassLoader classLoader;
    private Principal[] principals;
    private boolean dynamicPermissionChecking = false;

    public ProtectionDomain(CodeSource codesource, PermissionCollection permissions) {
        this.cs = codesource;
        this.pc = permissions;
        if (this.pc != null) {
            this.pc.setReadOnly();
        }
    }

    public ProtectionDomain(CodeSource codesource, PermissionCollection permissions, ClassLoader classloader, Principal[] principals) {
        this.cs = codesource;
        this.pc = permissions;
        if (this.pc != null) {
            this.pc.setReadOnly();
        }
        this.dynamicPermissionChecking = true;
        this.classLoader = classloader;
        this.principals = principals;
    }

    public final CodeSource getCodeSource() {
        return this.cs;
    }

    public final PermissionCollection getPermissions() {
        return this.pc;
    }

    public final Principal[] getPrincipals() {
        if (this.principals == null) {
            return new Principal[0];
        }
        Principal[] result = new Principal[this.principals.length];
        System.arraycopy((Object)this.principals, 0, (Object)result, 0, this.principals.length);
        return result;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean implies(Permission perm) {
        if (this.dynamicPermissionChecking) {
            PermissionCollection perms = Policy.getPolicyImpl().getPermissions(this);
            return this.pc != null && this.pc.implies(perm) || perms != null && perms.implies(perm);
        }
        return this.pc != null && this.pc.implies(perm);
    }

    public String toString() {
        StringBuffer answer = new StringBuffer("ProtectionDomain ");
        if (this.cs == null) {
            answer.append("null");
        } else {
            answer.append(this.cs.toString());
        }
        String crlf = (String)AccessController.doPrivileged(new PriviAction("line.separator"));
        answer.append(crlf);
        if (this.pc == null) {
            answer.append("null");
        } else {
            answer.append(this.pc.toString());
        }
        return answer.toString();
    }
}

