/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Hashtable;

public class SecureClassLoader
extends ClassLoader {
    private Hashtable domainForCodeSource = new Hashtable(10);

    protected SecureClassLoader() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
    }

    protected SecureClassLoader(ClassLoader parentLoader) {
        super(parentLoader);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
    }

    protected final Class defineClass(String className, byte[] classRep, int offset, int length, CodeSource cs) {
        ProtectionDomain pd = null;
        if (cs != null && (pd = (ProtectionDomain)this.domainForCodeSource.get(cs)) == null) {
            pd = new ProtectionDomain(cs, this.getPermissions(cs), this, null);
            this.domainForCodeSource.put(cs, pd);
        }
        return this.defineClass(className, classRep, offset, length, pd);
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        return new Permissions();
    }
}

