/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Random;

public class SecureRandom
extends Random {
    private static final long serialVersionUID = 4940670005562187L;
    private static final String DEFAULT_ALGORITHM_NAME = "SHA1PRNG";
    private static final String KEY_PREFIX = "SecureRandom.";
    private static SecureRandom DEFAULT = null;
    private Provider provider;
    private SecureRandomSpi secureRandomSpi;
    private byte[] state;
    private MessageDigest digest;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[7];
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.security.Provider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("provider", clazz);
        Class clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.security.SecureRandomSpi");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[1] = new ObjectStreamField("secureRandomSpi", clazz2);
        Class clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[2] = new ObjectStreamField("state", clazz3);
        Class clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.security.MessageDigest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[3] = new ObjectStreamField("digest", clazz4);
        Class clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[4] = new ObjectStreamField("randomBytes", clazz5);
        objectStreamFieldArray[5] = new ObjectStreamField("randomBytesUsed", Integer.TYPE);
        objectStreamFieldArray[6] = new ObjectStreamField("counter", Long.TYPE);
        serialPersistentFields = objectStreamFieldArray;
    }

    public SecureRandom() {
        try {
            SecureRandom sr = SecureRandom.getInstance(DEFAULT_ALGORITHM_NAME);
            this.secureRandomSpi = sr.secureRandomSpi;
            this.provider = sr.provider;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e.toString());
        }
    }

    public SecureRandom(byte[] seed) {
        this();
        this.setSeed(seed);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.provider = provider;
        this.secureRandomSpi = secureRandomSpi;
    }

    private static SecureRandom createSecureRandom(Provider provider, Class algorithmClass, String algName) throws NoSuchAlgorithmException {
        try {
            SecureRandomSpi secureRandomSpi = (SecureRandomSpi)algorithmClass.newInstance();
            SecureRandom result = new SecureRandom(secureRandomSpi, provider);
            return result;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        throw new NoSuchAlgorithmException(algName);
    }

    public byte[] generateSeed(int numBytes) {
        return this.secureRandomSpi.engineGenerateSeed(numBytes);
    }

    public static SecureRandom getInstance(String algorithmName) throws NoSuchAlgorithmException {
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        return SecureRandom.toSecureRandomImplementation(algorithmName);
    }

    public static SecureRandom getInstance(String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return SecureRandom.toSecureRandomImplementation(algorithmName, provider);
    }

    public static SecureRandom getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (algorithm == null || provider == null) {
            throw new IllegalArgumentException();
        }
        return SecureRandom.toSecureRandomImplementation(algorithm, provider);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public static byte[] getSeed(int numBytes) {
        if (DEFAULT == null) {
            DEFAULT = new SecureRandom();
        }
        byte[] result = new byte[numBytes];
        DEFAULT.nextBytes(result);
        return result;
    }

    protected final int next(int numBits) {
        if (numBits == 0) {
            return 0;
        }
        int need = numBits / 8;
        int extra = numBits - need * 8;
        if (extra > 0) {
            ++need;
        }
        byte[] data = new byte[need];
        this.nextBytes(data);
        int result = data[0] & 0xFF;
        if (extra > 0) {
            result >>= 8 - extra;
        }
        int i = 1;
        while (i < need) {
            result = result << 8 | data[i] & 0xFF;
            ++i;
        }
        return result;
    }

    public void nextBytes(byte[] bytes) {
        this.secureRandomSpi.engineNextBytes(bytes);
    }

    public void setSeed(byte[] seed) {
        this.secureRandomSpi.engineSetSeed(seed);
    }

    public void setSeed(long seed) {
        if (this.secureRandomSpi == null) {
            return;
        }
        byte[] representation = new byte[8];
        int i = 7;
        while (i >= 0) {
            representation[i] = (byte)(seed & 0xFFL);
            seed >>>= 8;
            --i;
        }
        this.setSeed(representation);
    }

    private static SecureRandom toSecureRandomImplementation(String algorithmName) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return SecureRandom.toSecureRandomImplementation(algorithmName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithmName);
    }

    private static SecureRandom toSecureRandomImplementation(String algorithmName, Provider provider) throws NoSuchAlgorithmException {
        String secureRandomClassName;
        try {
            secureRandomClassName = provider.getProperty(KEY_PREFIX + algorithmName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        if (secureRandomClassName == null) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        try {
            Class secureRandomClass = Class.forName(secureRandomClassName, true, provider.getClass().getClassLoader());
            return SecureRandom.createSecureRandom(provider, secureRandomClass, algorithmName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("provider", this.provider);
        fields.put("secureRandomSpi", this.secureRandomSpi);
        stream.writeFields();
    }
}

