/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.util.Msg;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class AttributedString {
    String text;
    Map attributeMap;

    public AttributedString(AttributedCharacterIterator iterator) {
        StringBuffer buffer = new StringBuffer();
        while (iterator.current() != '\uffff') {
            buffer.append(iterator.current());
            iterator.next();
        }
        this.text = buffer.toString();
        Set attributes = iterator.getAllAttributeKeys();
        this.attributeMap = new HashMap(attributes.size() * 4 / 3 + 1);
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)it.next();
            iterator.setIndex(0);
            while (iterator.current() != '\uffff') {
                int start = iterator.getRunStart(attribute);
                int limit = iterator.getRunLimit(attribute);
                Object value = iterator.getAttribute(attribute);
                if (value != null) {
                    this.addAttribute(attribute, value, start, limit);
                }
                iterator.setIndex(limit);
            }
        }
    }

    private AttributedString(AttributedCharacterIterator iterator, int start, int end, Set attributes) {
        if (start < iterator.getBeginIndex() || end > iterator.getEndIndex() || start > end) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        iterator.setIndex(start);
        while (iterator.getIndex() < end) {
            buffer.append(iterator.current());
            iterator.next();
        }
        this.text = buffer.toString();
        this.attributeMap = new HashMap(attributes.size() * 4 / 3 + 1);
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)it.next();
            iterator.setIndex(start);
            while (iterator.getIndex() < end) {
                Object value = iterator.getAttribute(attribute);
                int runStart = iterator.getRunStart(attribute);
                int limit = iterator.getRunLimit(attribute);
                if (value instanceof Annotation && runStart >= start && limit <= end || value != null && !(value instanceof Annotation)) {
                    this.addAttribute(attribute, value, (runStart < start ? start : runStart) - start, (limit > end ? end : limit) - start);
                }
                iterator.setIndex(limit);
            }
        }
    }

    public AttributedString(AttributedCharacterIterator iterator, int start, int end) {
        this(iterator, start, end, iterator.getAllAttributeKeys());
    }

    public AttributedString(AttributedCharacterIterator iterator, int start, int end, AttributedCharacterIterator.Attribute[] attributes) {
        this(iterator, start, end, new HashSet(Arrays.asList(attributes)));
    }

    public AttributedString(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.text = value;
        this.attributeMap = new HashMap(11);
    }

    public AttributedString(String value, Map attributes) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.length() == 0 && !attributes.isEmpty()) {
            throw new IllegalArgumentException(Msg.getString("K000e"));
        }
        this.text = value;
        this.attributeMap = new HashMap(attributes.size() * 4 / 3 + 1);
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            ArrayList ranges = new ArrayList(1);
            ranges.add(new Range(0, this.text.length(), entry.getValue()));
            this.attributeMap.put(entry.getKey(), ranges);
        }
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        if (this.text.length() == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList ranges = (ArrayList)this.attributeMap.get(attribute);
        if (ranges == null) {
            ranges = new ArrayList(1);
            this.attributeMap.put(attribute, ranges);
        } else {
            ranges.clear();
        }
        ranges.add(new Range(0, this.text.length(), value));
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value, int start, int end) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        if (start < 0 || end > this.text.length() || start >= end) {
            throw new IllegalArgumentException();
        }
        ArrayList ranges = (ArrayList)this.attributeMap.get(attribute);
        if (ranges == null) {
            ranges = new ArrayList(1);
            ranges.add(new Range(start, end, value));
            this.attributeMap.put(attribute, ranges);
            return;
        }
        ListIterator it = ranges.listIterator();
        while (it.hasNext()) {
            Range range = (Range)it.next();
            if (end <= range.start) {
                it.previous();
                break;
            }
            if (start >= range.end && (start != range.end || !(value == null ? range.value == null : value.equals(range.value)))) continue;
            Range r1 = null;
            it.remove();
            r1 = new Range(range.start, start, range.value);
            Range r3 = new Range(end, range.end, range.value);
            while (end > range.end && it.hasNext()) {
                range = (Range)it.next();
                if (end <= range.end) {
                    if (end <= range.start && (end != range.start || !(value == null ? range.value == null : value.equals(range.value)))) continue;
                    it.remove();
                    r3 = new Range(end, range.end, range.value);
                    break;
                }
                it.remove();
            }
            if (value == null ? r1.value == null : value.equals(r1.value)) {
                if (value == null ? r3.value == null : value.equals(r3.value)) {
                    it.add(new Range(r1.start < start ? r1.start : start, r3.end > end ? r3.end : end, r1.value));
                } else {
                    it.add(new Range(r1.start < start ? r1.start : start, end, r1.value));
                    if (r3.start < r3.end) {
                        it.add(r3);
                    }
                }
            } else if (value == null ? r3.value == null : value.equals(r3.value)) {
                if (r1.start < r1.end) {
                    it.add(r1);
                }
                it.add(new Range(start, r3.end > end ? r3.end : end, r3.value));
            } else {
                if (r1.start < r1.end) {
                    it.add(r1);
                }
                it.add(new Range(start, end, value));
                if (r3.start < r3.end) {
                    it.add(r3);
                }
            }
            return;
        }
        it.add(new Range(start, end, value));
    }

    public void addAttributes(Map attributes, int start, int end) {
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            this.addAttribute((AttributedCharacterIterator.Attribute)entry.getKey(), entry.getValue(), start, end);
        }
    }

    public AttributedCharacterIterator getIterator() {
        return new AttributedIterator(this);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes) {
        return new AttributedIterator(this, attributes, 0, this.text.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes, int start, int end) {
        return new AttributedIterator(this, attributes, start, end);
    }

    static class Range {
        int start;
        int end;
        Object value;

        Range(int s, int e, Object v) {
            this.start = s;
            this.end = e;
            this.value = v;
        }
    }

    static class AttributedIterator
    implements AttributedCharacterIterator {
        private int begin;
        private int end;
        private int offset;
        private AttributedString attrString;
        private HashSet attributesAllowed;
        private static Object marker = new Object();

        AttributedIterator(AttributedString attrString) {
            this.attrString = attrString;
            this.begin = 0;
            this.end = attrString.text.length();
            this.offset = 0;
        }

        AttributedIterator(AttributedString attrString, AttributedCharacterIterator.Attribute[] attributes, int begin, int end) {
            if (begin < 0 || end > attrString.text.length() || begin > end) {
                throw new IllegalArgumentException();
            }
            this.begin = begin;
            this.end = end;
            this.offset = begin;
            this.attrString = attrString;
            if (attributes != null) {
                HashSet set = new HashSet(attributes.length * 4 / 3 + 1);
                int i = attributes.length;
                while (--i >= 0) {
                    set.add(attributes[i]);
                }
                this.attributesAllowed = set;
            }
        }

        public Object clone() {
            try {
                AttributedIterator clone = (AttributedIterator)super.clone();
                if (this.attributesAllowed != null) {
                    clone.attributesAllowed = (HashSet)this.attributesAllowed.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public char current() {
            if (this.offset == this.end) {
                return '\uffff';
            }
            return this.attrString.text.charAt(this.offset);
        }

        public char first() {
            if (this.begin == this.end) {
                return '\uffff';
            }
            this.offset = this.begin;
            return this.attrString.text.charAt(this.offset);
        }

        public int getBeginIndex() {
            return this.begin;
        }

        public int getEndIndex() {
            return this.end;
        }

        public int getIndex() {
            return this.offset;
        }

        private boolean inRange(Range range) {
            if (!(range.value instanceof Annotation)) {
                return true;
            }
            return range.start >= this.begin && range.start < this.end && range.end > this.begin && range.end <= this.end;
        }

        private boolean inRange(ArrayList ranges) {
            Iterator it = ranges.iterator();
            while (it.hasNext()) {
                Range range = (Range)it.next();
                if (range.start >= this.begin && range.start < this.end) {
                    return !(range.value instanceof Annotation) || range.end > this.begin && range.end <= this.end;
                }
                if (range.end <= this.begin || range.end > this.end) continue;
                return !(range.value instanceof Annotation) || range.start >= this.begin && range.start < this.end;
            }
            return false;
        }

        public Set getAllAttributeKeys() {
            if (this.begin == 0 && this.end == this.attrString.text.length() && this.attributesAllowed == null) {
                return this.attrString.attributeMap.keySet();
            }
            HashSet result = new HashSet(this.attrString.attributeMap.size() * 4 / 3 + 1);
            Iterator it = this.attrString.attributeMap.entrySet().iterator();
            while (it.hasNext()) {
                ArrayList ranges;
                Map.Entry entry = (Map.Entry)it.next();
                if (this.attributesAllowed != null && !this.attributesAllowed.contains(entry.getKey()) || !this.inRange(ranges = (ArrayList)entry.getValue())) continue;
                result.add(entry.getKey());
            }
            return result;
        }

        private Object currentValue(ArrayList ranges, boolean check) {
            Iterator it = ranges.iterator();
            while (it.hasNext()) {
                Range range = (Range)it.next();
                if (this.offset < range.start || this.offset >= range.end) continue;
                return this.inRange(range) ? range.value : (check ? marker : null);
            }
            return check ? marker : null;
        }

        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return null;
            }
            ArrayList ranges = (ArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return null;
            }
            return this.currentValue(ranges, false);
        }

        public Map getAttributes() {
            HashMap result = new HashMap(this.attrString.attributeMap.size() * 4 / 3 + 1);
            Iterator it = this.attrString.attributeMap.entrySet().iterator();
            while (it.hasNext()) {
                Object value;
                Map.Entry entry = (Map.Entry)it.next();
                if (this.attributesAllowed != null && !this.attributesAllowed.contains(entry.getKey()) || (value = this.currentValue((ArrayList)entry.getValue(), true)) == marker) continue;
                result.put(entry.getKey(), value);
            }
            return result;
        }

        public int getRunLimit() {
            return this.getRunLimit(this.getAllAttributeKeys());
        }

        private int runLimit(ArrayList ranges) {
            int result = this.end;
            ListIterator it = ranges.listIterator(ranges.size());
            while (it.hasPrevious()) {
                Range range = (Range)it.previous();
                if (range.value == null) continue;
                if (range.end <= this.begin) break;
                if (this.offset >= range.start && this.offset < range.end) {
                    return this.inRange(range) ? range.end : result;
                }
                if (this.offset >= range.end) break;
                result = range.start;
            }
            return result;
        }

        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return this.end;
            }
            ArrayList ranges = (ArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return this.end;
            }
            return this.runLimit(ranges);
        }

        public int getRunLimit(Set attributes) {
            int limit = this.end;
            Iterator it = attributes.iterator();
            while (it.hasNext()) {
                AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)it.next();
                int newLimit = this.getRunLimit(attribute);
                if (newLimit >= limit) continue;
                limit = newLimit;
            }
            return limit;
        }

        public int getRunStart() {
            return this.getRunStart(this.getAllAttributeKeys());
        }

        private int runStart(ArrayList ranges) {
            int result = this.begin;
            Iterator it = ranges.iterator();
            while (it.hasNext()) {
                Range range = (Range)it.next();
                if (range.start >= this.end) break;
                if (this.offset >= range.start && this.offset < range.end) {
                    return this.inRange(range) ? range.start : result;
                }
                if (this.offset < range.start) break;
                result = range.end;
            }
            return result;
        }

        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (this.attributesAllowed != null && !this.attributesAllowed.contains(attribute)) {
                return this.begin;
            }
            ArrayList ranges = (ArrayList)this.attrString.attributeMap.get(attribute);
            if (ranges == null) {
                return this.begin;
            }
            return this.runStart(ranges);
        }

        public int getRunStart(Set attributes) {
            int start = this.begin;
            Iterator it = attributes.iterator();
            while (it.hasNext()) {
                AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)it.next();
                int newStart = this.getRunStart(attribute);
                if (newStart <= start) continue;
                start = newStart;
            }
            return start;
        }

        public char last() {
            if (this.begin == this.end) {
                return '\uffff';
            }
            this.offset = this.end - 1;
            return this.attrString.text.charAt(this.offset);
        }

        public char next() {
            if (this.offset >= this.end - 1) {
                this.offset = this.end;
                return '\uffff';
            }
            return this.attrString.text.charAt(++this.offset);
        }

        public char previous() {
            if (this.offset == this.begin) {
                return '\uffff';
            }
            return this.attrString.text.charAt(--this.offset);
        }

        public char setIndex(int location) {
            if (location < this.begin || location > this.end) {
                throw new IllegalArgumentException();
            }
            this.offset = location;
            if (this.offset == this.end) {
                return '\uffff';
            }
            return this.attrString.text.charAt(this.offset);
        }
    }
}

