/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.locale.Locale;
import com.ibm.oti.util.ExtendedResourceBundle;
import com.ibm.oti.util.PriviAction;
import java.security.AccessController;
import java.text.CollationKey;
import java.text.CollationRules;
import java.text.Format;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.MissingResourceException;
import java.util.Vector;

public abstract class Collator
implements Comparator,
Cloneable {
    static final int EQUAL = 0;
    static final int GREATER = 1;
    static final int LESS = -1;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    private static int CACHE_SIZE;
    private static Vector cache;
    private int strength = 2;
    private int decomposition = 1;

    static {
        cache = new Vector();
        String cacheSize = (String)AccessController.doPrivileged(new PriviAction("collator.cache"));
        if (cacheSize != null) {
            try {
                CACHE_SIZE = Integer.parseInt(cacheSize);
            }
            catch (NumberFormatException numberFormatException) {
                CACHE_SIZE = 6;
            }
        } else {
            CACHE_SIZE = 6;
        }
    }

    protected Collator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int compare(Object object1, Object object2) {
        return this.compare((String)object1, (String)object2);
    }

    public abstract int compare(String var1, String var2);

    public boolean equals(Object object) {
        if (!(object instanceof Collator)) {
            return false;
        }
        Collator collator = (Collator)object;
        return this.strength == collator.strength && this.decomposition == collator.decomposition;
    }

    public boolean equals(String string1, String string2) {
        return this.compare(string1, string2) == 0;
    }

    public static java.util.Locale[] getAvailableLocales() {
        return java.util.Locale.getAvailableLocales();
    }

    public abstract CollationKey getCollationKey(String var1);

    public int getDecomposition() {
        return this.decomposition;
    }

    public static Collator getInstance() {
        return Collator.getInstance(java.util.Locale.getDefault());
    }

    public static Collator getInstance(java.util.Locale locale) {
        String key = locale.toString();
        int i = cache.size() - 1;
        while (i >= 0) {
            if (cache.elementAt(i).equals(key)) {
                return (Collator)((Collator)cache.elementAt(i - 1)).clone();
            }
            i -= 2;
        }
        ExtendedResourceBundle bundle = (ExtendedResourceBundle)Format.getCollationBundle(locale);
        String rules = (String)bundle.getObject(Locale.COLLATION);
        try {
            int decomp = 1;
            try {
                Object decompProp = bundle.getObject(Locale.COLLATIONDECOMP);
                decomp = (Integer)decompProp;
            }
            catch (MissingResourceException missingResourceException) {}
            RuleBasedCollator collator = new RuleBasedCollator(String.valueOf(CollationRules.DEFAULTRULES) + rules, decomp);
            collator.setDecomposition(0);
            if (CACHE_SIZE > 0) {
                if (cache.size() >= CACHE_SIZE) {
                    cache.removeElementAt(0);
                    cache.removeElementAt(0);
                }
                cache.addElement(((Collator)collator).clone());
                cache.addElement(key);
            }
            return collator;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int getStrength() {
        return this.strength;
    }

    public abstract int hashCode();

    public void setDecomposition(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.decomposition = value;
    }

    public void setStrength(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.strength = value;
    }
}

