/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount = 0;

    protected AbstractList() {
    }

    public void add(int location, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    public boolean addAll(int location, Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.add(location++, it.next());
        }
        return !collection.isEmpty();
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() != this.size()) {
                return false;
            }
            Iterator it1 = this.iterator();
            Iterator it2 = list.iterator();
            while (it1.hasNext()) {
                Object e1 = it1.next();
                Object e2 = it2.next();
                if (!(e1 == null ? e2 != null : !e1.equals(e2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public abstract Object get(int var1);

    public int hashCode() {
        int result = 1;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            result = 31 * result + (object == null ? 0 : object.hashCode());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public int indexOf(Object object) {
        block2: {
            it = this.listIterator();
            if (object == null) ** GOTO lbl9
            while (it.hasNext()) {
                if (!object.equals(it.next())) continue;
                return it.previousIndex();
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (it.next() != null) continue;
                return it.previousIndex();
lbl9:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return new SimpleListIterator();
    }

    /*
     * Unable to fully structure code
     */
    public int lastIndexOf(Object object) {
        block2: {
            it = this.listIterator(this.size());
            if (object == null) ** GOTO lbl9
            while (it.hasPrevious()) {
                if (!object.equals(it.previous())) continue;
                return it.nextIndex();
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (it.previous() != null) continue;
                return it.nextIndex();
lbl9:
                // 2 sources

                ** while (it.hasPrevious())
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int location) {
        return new FullListIterator(location);
    }

    public Object remove(int location) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int start, int end) {
        ListIterator it = this.listIterator(start);
        int i = start;
        while (i < end) {
            it.next();
            it.remove();
            ++i;
        }
    }

    public Object set(int location, Object object) {
        throw new UnsupportedOperationException();
    }

    public List subList(int start, int end) {
        if (start >= 0 && end <= this.size()) {
            if (start <= end) {
                if (this instanceof RandomAccess) {
                    return new SubAbstractListRandomAccess(this, start, end);
                }
                return new SubAbstractList(this, start, end);
            }
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    private class SimpleListIterator
    implements Iterator {
        int pos = -1;
        int expectedModCount;
        int lastPosition = -1;

        SimpleListIterator() {
            this.expectedModCount = AbstractList.this.modCount;
        }

        public boolean hasNext() {
            return this.pos + 1 < AbstractList.this.size();
        }

        public Object next() {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    Object result = AbstractList.this.get(this.pos + 1);
                    this.lastPosition = ++this.pos;
                    return result;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    AbstractList.this.remove(this.lastPosition);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalStateException();
                }
                if (AbstractList.this.modCount != this.expectedModCount) {
                    ++this.expectedModCount;
                }
                if (this.pos == this.lastPosition) {
                    --this.pos;
                }
            } else {
                throw new ConcurrentModificationException();
            }
            this.lastPosition = -1;
        }
    }

    private final class FullListIterator
    extends SimpleListIterator
    implements ListIterator {
        FullListIterator(int start) {
            if (start < 0 || start > AbstractList.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.pos = start - 1;
        }

        public void add(Object object) {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    AbstractList.this.add(this.pos + 1, object);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
                ++this.pos;
                this.lastPosition = -1;
                if (AbstractList.this.modCount != this.expectedModCount) {
                    ++this.expectedModCount;
                }
            } else {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasPrevious() {
            return this.pos >= 0;
        }

        public int nextIndex() {
            return this.pos + 1;
        }

        public Object previous() {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    Object result = AbstractList.this.get(this.pos);
                    this.lastPosition = this.pos--;
                    return result;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }
            throw new ConcurrentModificationException();
        }

        public int previousIndex() {
            return this.pos;
        }

        public void set(Object object) {
            if (this.expectedModCount == AbstractList.this.modCount) {
                try {
                    AbstractList.this.set(this.lastPosition, object);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalStateException();
                }
            } else {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static final class SubAbstractListRandomAccess
    extends SubAbstractList
    implements RandomAccess {
        SubAbstractListRandomAccess(AbstractList list, int start, int end) {
            super(list, start, end);
        }
    }

    private static class SubAbstractList
    extends AbstractList {
        private final AbstractList fullList;
        private int offset;
        private int size;

        SubAbstractList(AbstractList list, int start, int end) {
            this.fullList = list;
            this.modCount = this.fullList.modCount;
            this.offset = start;
            this.size = end - start;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void add(int location, Object object) {
            if (this.modCount != this.fullList.modCount) throw new ConcurrentModificationException();
            if (location < 0 || location > this.size) throw new IndexOutOfBoundsException();
            this.fullList.add(location + this.offset, object);
            ++this.size;
            this.modCount = this.fullList.modCount;
        }

        public boolean addAll(int location, Collection collection) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location <= this.size) {
                    boolean result = this.fullList.addAll(location + this.offset, collection);
                    if (result) {
                        this.size += collection.size();
                        this.modCount = this.fullList.modCount;
                    }
                    return result;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        public boolean addAll(Collection collection) {
            if (this.modCount == this.fullList.modCount) {
                boolean result = this.fullList.addAll(this.size, collection);
                if (result) {
                    this.size += collection.size();
                    this.modCount = this.fullList.modCount;
                }
                return result;
            }
            throw new ConcurrentModificationException();
        }

        public Object get(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location <= this.size) {
                    return this.fullList.get(location + this.offset);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        public Iterator iterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location <= this.size) {
                    return new SubAbstractListIterator(this.fullList.listIterator(location + this.offset), this, this.offset, this.size);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        public Object remove(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location <= this.size) {
                    Object result = this.fullList.remove(location + this.offset);
                    --this.size;
                    this.modCount = this.fullList.modCount;
                    return result;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        protected void removeRange(int start, int end) {
            if (start != end) {
                if (this.modCount == this.fullList.modCount) {
                    this.fullList.removeRange(start + this.offset, end + this.offset);
                    this.size -= end - start;
                    this.modCount = this.fullList.modCount;
                } else {
                    throw new ConcurrentModificationException();
                }
            }
        }

        public Object set(int location, Object object) {
            if (this.modCount == this.fullList.modCount) {
                if (location >= 0 && location <= this.size) {
                    return this.fullList.set(location + this.offset, object);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new ConcurrentModificationException();
        }

        public int size() {
            return this.size;
        }

        void sizeChanged(boolean increment) {
            this.size = increment ? ++this.size : --this.size;
            this.modCount = this.fullList.modCount;
        }

        private static final class SubAbstractListIterator
        implements ListIterator {
            private final SubAbstractList subList;
            private final ListIterator iterator;
            private int start;
            private int end;

            SubAbstractListIterator(ListIterator it, SubAbstractList list, int offset, int length) {
                this.iterator = it;
                this.subList = list;
                this.start = offset;
                this.end = this.start + length;
            }

            public void add(Object object) {
                this.iterator.add(object);
                this.subList.sizeChanged(true);
                ++this.end;
            }

            public boolean hasNext() {
                return this.iterator.nextIndex() < this.end;
            }

            public boolean hasPrevious() {
                return this.iterator.previousIndex() >= this.start;
            }

            public Object next() {
                if (this.iterator.nextIndex() < this.end) {
                    return this.iterator.next();
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.iterator.nextIndex() - this.start;
            }

            public Object previous() {
                if (this.iterator.previousIndex() >= this.start) {
                    return this.iterator.previous();
                }
                throw new NoSuchElementException();
            }

            public int previousIndex() {
                int previous = this.iterator.previousIndex();
                if (previous >= this.start) {
                    return previous - this.start;
                }
                return -1;
            }

            public void remove() {
                this.iterator.remove();
                this.subList.sizeChanged(false);
                --this.end;
            }

            public void set(Object object) {
                this.iterator.set(object);
            }
        }
    }
}

