/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1421746759512286392L;
    transient int elementCount;
    transient Entry[] elementData;
    private float loadFactor;
    private int threshold;
    transient int firstSlot = 0;
    transient int lastSlot = -1;
    transient int modCount = 0;
    private static final Enumeration emptyEnumerator = new Hashtable(0).getEmptyEnumerator();

    private static Entry newEntry(Object key, Object value, int hash) {
        return new Entry(key, value);
    }

    public Hashtable() {
        this(11);
    }

    public Hashtable(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = new Entry[capacity == 0 ? 1 : capacity];
        this.firstSlot = this.elementData.length;
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.firstSlot = capacity;
        this.elementData = new Entry[capacity == 0 ? 1 : capacity];
        this.loadFactor = loadFactor;
        this.computeMaxSize();
    }

    public Hashtable(Map map) {
        this(map.size() < 6 ? 11 : map.size() * 4 / 3 + 11);
        this.putAll(map);
    }

    private HashEnumerator getEmptyEnumerator() {
        return new HashEnumerator(false);
    }

    public synchronized void clear() {
        this.elementCount = 0;
        Arrays.fill(this.elementData, null);
        ++this.modCount;
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.elementData = new Entry[this.elementData.length];
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry entry = this.elementData[i];
                if (entry == null) continue;
                hashtable.elementData[i] = (Entry)entry.clone();
            }
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public synchronized boolean contains(Object value) {
        if (value != null) {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry entry = this.elementData[i];
                while (entry != null) {
                    if (value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
            return false;
        }
        throw new NullPointerException();
    }

    public synchronized boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public synchronized Enumeration elements() {
        if (this.elementCount == 0) {
            return emptyEnumerator;
        }
        return new HashEnumerator(false);
    }

    public Set entrySet() {
        return new Collections.SynchronizedSet(new AbstractSet(){

            public int size() {
                return Hashtable.this.elementCount;
            }

            public void clear() {
                Hashtable.this.clear();
            }

            public boolean remove(Object object) {
                if (this.contains(object)) {
                    Hashtable.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Entry entry = Hashtable.this.getEntry(((Map.Entry)object).getKey());
                    return object.equals(entry);
                }
                return false;
            }

            public Iterator iterator() {
                return new HashIterator(new MapEntry.Type(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object get(MapEntry entry) {
                        return entry;
                    }
                });
            }
        }, (Object)this);
    }

    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            Set objectSet = map.entrySet();
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                if (objectSet.contains(it.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized Object get(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry entry = this.elementData[index];
        while (entry != null) {
            if (entry.equalsKey(key, hash)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry getEntry(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry entry = this.elementData[index];
        while (entry != null) {
            if (entry.equalsKey(key, hash)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized int hashCode() {
        int result = 0;
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            int hash = (key != this ? key.hashCode() : 0) ^ (value != this ? (value != null ? value.hashCode() : 0) : 0);
            result += hash;
        }
        return result;
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Enumeration keys() {
        if (this.elementCount == 0) {
            return emptyEnumerator;
        }
        return new HashEnumerator(true);
    }

    public Set keySet() {
        return new Collections.SynchronizedSet(new AbstractSet(){

            public boolean contains(Object object) {
                return Hashtable.this.containsKey(object);
            }

            public int size() {
                return Hashtable.this.elementCount;
            }

            public void clear() {
                Hashtable.this.clear();
            }

            public boolean remove(Object key) {
                if (Hashtable.this.containsKey(key)) {
                    Hashtable.this.remove(key);
                    return true;
                }
                return false;
            }

            public Iterator iterator() {
                return new HashIterator(new MapEntry.Type(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object get(MapEntry entry) {
                        return entry.key;
                    }
                });
            }
        }, (Object)this);
    }

    public synchronized Object put(Object key, Object value) {
        if (key != null && value != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            Entry entry = this.elementData[index];
            while (entry != null && !entry.equalsKey(key, hash)) {
                entry = entry.next;
            }
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    index = (hash & Integer.MAX_VALUE) % this.elementData.length;
                }
                if (index < this.firstSlot) {
                    this.firstSlot = index;
                }
                if (index > this.lastSlot) {
                    this.lastSlot = index;
                }
                entry = Hashtable.newEntry(key, value, hash);
                entry.next = this.elementData[index];
                this.elementData[index] = entry;
                return null;
            }
            Object result = entry.value;
            entry.value = value;
            return result;
        }
        throw new NullPointerException();
    }

    public synchronized void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected void rehash() {
        int length = (this.elementData.length << 1) + 1;
        if (length == 0) {
            length = 1;
        }
        int newFirst = length;
        int newLast = -1;
        Entry[] newData = new Entry[length];
        int i = this.lastSlot + 1;
        while (--i >= this.firstSlot) {
            Entry entry = this.elementData[i];
            while (entry != null) {
                int index = (entry.getKeyHash() & Integer.MAX_VALUE) % length;
                if (index < newFirst) {
                    newFirst = index;
                }
                if (index > newLast) {
                    newLast = index;
                }
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.firstSlot = newFirst;
        this.lastSlot = newLast;
        this.elementData = newData;
        this.computeMaxSize();
    }

    public synchronized Object remove(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry last = null;
        Entry entry = this.elementData[index];
        while (entry != null && !entry.equalsKey(key, hash)) {
            last = entry;
            entry = entry.next;
        }
        if (entry != null) {
            ++this.modCount;
            if (last == null) {
                this.elementData[index] = entry.next;
            } else {
                last.next = entry.next;
            }
            --this.elementCount;
            Object result = entry.value;
            entry.value = null;
            return result;
        }
        return null;
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer(this.size() * 28);
        buffer.append('{');
        int i = this.lastSlot;
        while (i >= this.firstSlot) {
            Entry entry = this.elementData[i];
            while (entry != null) {
                if (entry.key != this) {
                    buffer.append(entry.key);
                } else {
                    buffer.append("(this Map)");
                }
                buffer.append('=');
                if (entry.value != this) {
                    buffer.append(entry.value);
                } else {
                    buffer.append("(this Map)");
                }
                buffer.append(", ");
                entry = entry.next;
            }
            --i;
        }
        if (this.elementCount > 0) {
            buffer.setLength(buffer.length() - 2);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public Collection values() {
        return new Collections.SynchronizedCollection(new AbstractCollection(){

            public boolean contains(Object object) {
                return Hashtable.this.contains(object);
            }

            public int size() {
                return Hashtable.this.elementCount;
            }

            public void clear() {
                Hashtable.this.clear();
            }

            public Iterator iterator() {
                return new HashIterator(new MapEntry.Type(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object get(MapEntry entry) {
                        return entry.value;
                    }
                });
            }
        }, this);
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elementData.length);
        stream.writeInt(this.elementCount);
        int i = this.elementData.length;
        while (--i >= 0) {
            Entry entry = this.elementData[i];
            while (entry != null) {
                stream.writeObject(entry.key);
                stream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int length = stream.readInt();
        this.elementData = new Entry[length];
        int i = this.elementCount = stream.readInt();
        while (--i >= 0) {
            Object key = stream.readObject();
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % length;
            if (index < this.firstSlot) {
                this.firstSlot = index;
            }
            if (index > this.lastSlot) {
                this.lastSlot = index;
            }
            Entry entry = Hashtable.newEntry(key, stream.readObject(), hash);
            entry.next = this.elementData[index];
            this.elementData[index] = entry;
        }
    }

    private static class Entry
    extends MapEntry {
        Entry next;

        Entry(Object theKey, Object theValue) {
            super(theKey, theValue);
        }

        public Object clone() {
            Entry entry = (Entry)super.clone();
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object result = this.value;
            this.value = object;
            return result;
        }

        public int getKeyHash() {
            return this.key.hashCode();
        }

        public boolean equalsKey(Object aKey, int hash) {
            return this.key.equals(aKey);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private final class HashIterator
    implements Iterator {
        private int position;
        private int expectedModCount;
        private MapEntry.Type type;
        private Entry lastEntry;
        private int lastPosition;
        private boolean canRemove = false;

        HashIterator(MapEntry.Type value) {
            this.type = value;
            this.position = Hashtable.this.lastSlot;
            this.expectedModCount = Hashtable.this.modCount;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.lastEntry == null || this.lastEntry.next == null) ** GOTO lbl7
            return true;
lbl-1000:
            // 1 sources

            {
                if (Hashtable.this.elementData[this.position] == null) {
                    --this.position;
                    continue;
                }
                return true;
lbl7:
                // 2 sources

                ** while (this.position >= Hashtable.this.firstSlot)
            }
lbl8:
            // 1 sources

            return false;
        }

        public Object next() {
            if (this.expectedModCount == Hashtable.this.modCount) {
                if (this.lastEntry != null) {
                    this.lastEntry = this.lastEntry.next;
                }
                if (this.lastEntry == null) {
                    while (this.position >= Hashtable.this.firstSlot && (this.lastEntry = Hashtable.this.elementData[this.position]) == null) {
                        --this.position;
                    }
                    if (this.lastEntry != null) {
                        this.lastPosition = this.position--;
                    }
                }
                if (this.lastEntry != null) {
                    this.canRemove = true;
                    return this.type.get(this.lastEntry);
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void remove() {
            if (this.expectedModCount != Hashtable.this.modCount) throw new ConcurrentModificationException();
            if (!this.canRemove) throw new IllegalStateException();
            this.canRemove = false;
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                boolean removed = false;
                Entry entry = Hashtable.this.elementData[this.lastPosition];
                if (entry == this.lastEntry) {
                    Hashtable.this.elementData[this.lastPosition] = entry.next;
                    removed = true;
                } else {
                    while (true) {
                        if (entry == null || entry.next == this.lastEntry) {
                            if (entry == null) break;
                            entry.next = this.lastEntry.next;
                            removed = true;
                            break;
                        }
                        entry = entry.next;
                    }
                }
                if (!removed) throw new ConcurrentModificationException();
                ++Hashtable.this.modCount;
                --Hashtable.this.elementCount;
                ++this.expectedModCount;
                return;
            }
        }
    }

    private final class HashEnumerator
    implements Enumeration {
        boolean key;
        int start;
        Entry entry;

        HashEnumerator(boolean isKey) {
            this.key = isKey;
            this.start = Hashtable.this.lastSlot + 1;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.entry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                if (Hashtable.this.elementData[this.start] == null) continue;
                this.entry = Hashtable.this.elementData[this.start];
                return true;
lbl6:
                // 2 sources

                ** while (--this.start >= Hashtable.this.firstSlot)
            }
lbl7:
            // 1 sources

            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                Object result = this.key ? this.entry.key : this.entry.value;
                this.entry = this.entry.next;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

