/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.locale.Country;
import com.ibm.oti.locale.Language;
import com.ibm.oti.util.PriviAction;
import com.ibm.oti.vm.JxeUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Locale
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9149081749638150636L;
    private transient String countryCode;
    private transient String languageCode;
    private transient String variantCode;
    private static Locale[] availableLocales;
    private static Locale defaultLocale;
    public static final Locale CANADA;
    public static final Locale CANADA_FRENCH;
    public static final Locale CHINA;
    public static final Locale CHINESE;
    public static final Locale ENGLISH;
    public static final Locale FRANCE;
    public static final Locale FRENCH;
    public static final Locale GERMAN;
    public static final Locale GERMANY;
    public static final Locale ITALIAN;
    public static final Locale ITALY;
    public static final Locale JAPAN;
    public static final Locale JAPANESE;
    public static final Locale KOREA;
    public static final Locale KOREAN;
    public static final Locale PRC;
    public static final Locale SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN;
    public static final Locale TRADITIONAL_CHINESE;
    public static final Locale UK;
    public static final Locale US;
    private static final PropertyPermission setLocalePermission;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;

    static {
        defaultLocale = new Locale();
        CANADA = new Locale("en", "CA");
        CANADA_FRENCH = new Locale("fr", "CA");
        CHINA = new Locale("zh", "CN");
        CHINESE = new Locale("zh", "");
        ENGLISH = new Locale("en", "");
        FRANCE = new Locale("fr", "FR");
        FRENCH = new Locale("fr", "");
        GERMAN = new Locale("de", "");
        GERMANY = new Locale("de", "DE");
        ITALIAN = new Locale("it", "");
        ITALY = new Locale("it", "IT");
        JAPAN = new Locale("ja", "JP");
        JAPANESE = new Locale("ja", "");
        KOREA = new Locale("ko", "KR");
        KOREAN = new Locale("ko", "");
        PRC = new Locale("zh", "CN");
        SIMPLIFIED_CHINESE = new Locale("zh", "CN");
        TAIWAN = new Locale("zh", "TW");
        TRADITIONAL_CHINESE = new Locale("zh", "TW");
        UK = new Locale("en", "GB");
        US = new Locale("en", "US");
        setLocalePermission = new PropertyPermission("user.language", "write");
        String language = (String)AccessController.doPrivileged(new PriviAction("user.language", "en"));
        String region = (String)AccessController.doPrivileged(new PriviAction("user.country", "US"));
        String variant = (String)AccessController.doPrivileged(new PriviAction("user.variant", ""));
        defaultLocale = new Locale(language, region, variant);
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[4];
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("country", clazz);
        objectStreamFieldArray[1] = new ObjectStreamField("hashcode", Integer.TYPE);
        Class clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[2] = new ObjectStreamField("language", clazz2);
        Class clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[3] = new ObjectStreamField("variant", clazz3);
        serialPersistentFields = objectStreamFieldArray;
    }

    private Locale() {
        this.languageCode = "en";
        this.countryCode = "US";
        this.variantCode = "";
    }

    public Locale(String language) {
        this(language, "", "");
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language, String country, String variant) {
        this.languageCode = language.toLowerCase();
        if (this.languageCode.equals("he")) {
            this.languageCode = "iw";
        } else if (this.languageCode.equals("id")) {
            this.languageCode = "in";
        } else if (this.languageCode.equals("yi")) {
            this.languageCode = "ji";
        }
        this.countryCode = country.toUpperCase();
        if (variant == null) {
            throw new NullPointerException();
        }
        this.variantCode = variant;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Locale) {
            Locale o = (Locale)object;
            return this.languageCode.equals(o.languageCode) && this.countryCode.equals(o.countryCode) && this.variantCode.equals(o.variantCode);
        }
        return false;
    }

    static Locale[] find(String prefix) {
        int last = prefix.lastIndexOf(47);
        String thePackage = prefix.substring(0, last + 1);
        final String classPrefix = prefix.substring(last + 1, prefix.length());
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(classPrefix);
            }
        };
        Vector result = new Vector();
        StringTokenizer paths = new StringTokenizer(System.getProperty("com.ibm.oti.system.class.path", ""), System.getProperty("path.separator", ";"));
        while (paths.hasMoreTokens()) {
            String nextToken = paths.nextToken();
            String[] classList = JxeUtil.getClassList(nextToken);
            if (classList != null && classList.length > 0) {
                int i = 0;
                while (i < classList.length) {
                    String name = String.valueOf(classList[i]) + ".class";
                    if (name.startsWith(prefix)) {
                        result.addElement(name);
                    }
                    ++i;
                }
                continue;
            }
            File directory = new File(nextToken);
            if (!directory.exists()) continue;
            if (directory.isDirectory()) {
                try {
                    String path = directory.getCanonicalPath();
                    File newDir = path.charAt(path.length() - 1) == File.separatorChar ? new File(String.valueOf(path) + thePackage) : new File(String.valueOf(path) + File.separatorChar + thePackage);
                    if (!newDir.isDirectory()) continue;
                    String[] list = newDir.list(filter);
                    int j = 0;
                    while (j < list.length) {
                        result.addElement(list[j]);
                        ++j;
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            try {
                ZipFile zip = new ZipFile(directory);
                Enumeration entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String name = ((ZipEntry)entries.nextElement()).getName();
                    if (!name.startsWith(prefix) || !name.endsWith(".class")) continue;
                    result.addElement(name);
                }
                zip.close();
            }
            catch (IOException iOException) {}
        }
        Locale[] locales = new Locale[result.size()];
        int i = 0;
        while (i < result.size()) {
            int index;
            String name = (String)result.elementAt(i);
            int nextIndex = (name = name.substring(0, name.length() - 6)).indexOf(95, (index = name.indexOf(95)) + 1);
            if (nextIndex == -1) {
                locales[i] = new Locale(name.substring(index + 1, name.length()), "");
            } else {
                String variant;
                String language = name.substring(index + 1, nextIndex);
                index = name.indexOf(95, nextIndex + 1);
                if (index == -1) {
                    variant = "";
                    index = name.length();
                } else {
                    variant = name.substring(index + 1, name.length());
                }
                String country = name.substring(nextIndex + 1, index);
                locales[i] = new Locale(language, country, variant);
            }
            ++i;
        }
        return locales;
    }

    public static Locale[] getAvailableLocales() {
        if (availableLocales == null) {
            availableLocales = (Locale[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Locale.find("com/ibm/oti/locale/Locale_");
                }
            });
        }
        return (Locale[])availableLocales.clone();
    }

    public String getCountry() {
        return this.countryCode;
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        if (this.countryCode.length() == 0) {
            return this.countryCode;
        }
        try {
            ResourceBundle bundle = Locale.getBundle("Country", locale);
            String result = (String)bundle.handleGetObject(this.countryCode);
            if (result != null) {
                return result;
            }
            if (locale.getVariant().length() > 0 && (result = (String)(bundle = Locale.getBundle("Country", new Locale(locale.languageCode, locale.countryCode))).handleGetObject(this.countryCode)) != null) {
                return result;
            }
            if (locale.getCountry().length() > 0 && (result = (String)(bundle = Locale.getBundle("Country", new Locale(locale.languageCode, ""))).handleGetObject(this.countryCode)) != null) {
                return result;
            }
            if (locale != Locale.getDefault()) {
                bundle = Locale.getBundle("Country", Locale.getDefault());
            }
            return bundle.getString(this.countryCode);
        }
        catch (MissingResourceException missingResourceException) {
            return this.countryCode;
        }
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        if (this.languageCode.length() == 0) {
            return this.languageCode;
        }
        try {
            ResourceBundle bundle = Locale.getBundle("Language", locale);
            String result = (String)bundle.handleGetObject(this.languageCode);
            if (result != null) {
                return result;
            }
            if (locale.getVariant().length() > 0 && (result = (String)(bundle = Locale.getBundle("Language", new Locale(locale.languageCode, locale.countryCode))).handleGetObject(this.languageCode)) != null) {
                return result;
            }
            if (locale.getCountry().length() > 0 && (result = (String)(bundle = Locale.getBundle("Language", new Locale(locale.languageCode, ""))).handleGetObject(this.languageCode)) != null) {
                return result;
            }
            if (locale != Locale.getDefault()) {
                bundle = Locale.getBundle("Language", Locale.getDefault());
            }
            return bundle.getString(this.languageCode);
        }
        catch (MissingResourceException missingResourceException) {
            return this.languageCode;
        }
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        int count = 0;
        StringBuffer buffer = new StringBuffer();
        if (this.languageCode.length() > 0) {
            buffer.append(this.getDisplayLanguage(locale));
            ++count;
        }
        if (this.countryCode.length() > 0) {
            if (count == 1) {
                buffer.append(" (");
            }
            buffer.append(this.getDisplayCountry(locale));
            ++count;
        }
        if (this.variantCode.length() > 0) {
            if (count == 1) {
                buffer.append(" (");
            } else if (count == 2) {
                buffer.append(",");
            }
            buffer.append(this.getDisplayVariant(locale));
            ++count;
        }
        if (count > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        ResourceBundle bundle;
        if (this.variantCode.length() == 0) {
            return this.variantCode;
        }
        try {
            bundle = Locale.getBundle("Variant", locale);
        }
        catch (MissingResourceException missingResourceException) {
            return this.variantCode.replace('_', ',');
        }
        StringBuffer result = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(this.variantCode, "_");
        while (tokens.hasMoreTokens()) {
            String code;
            String variant = tokens.nextToken();
            try {
                code = (String)bundle.handleGetObject(variant);
                if (code == null) {
                    if (locale.getVariant().length() > 0) {
                        bundle = Locale.getBundle("Variant", new Locale(locale.languageCode, locale.countryCode));
                        code = (String)bundle.handleGetObject(variant);
                    }
                    if (code == null && locale.getCountry().length() > 0) {
                        bundle = Locale.getBundle("Variant", new Locale(locale.languageCode, ""));
                        code = (String)bundle.handleGetObject(variant);
                    }
                }
                if (code == null) {
                    bundle = Locale.getBundle("Variant", Locale.getDefault());
                    code = bundle.getString(variant);
                }
            }
            catch (MissingResourceException missingResourceException) {
                code = variant;
            }
            result.append(code);
            if (!tokens.hasMoreTokens()) continue;
            result.append(',');
        }
        return result.toString();
    }

    public String getISO3Country() throws MissingResourceException {
        if (this.countryCode.length() == 0) {
            return "";
        }
        ResourceBundle bundle = Locale.getBundle("ISO3Countries", this);
        return bundle.getString(this.countryCode);
    }

    public String getISO3Language() throws MissingResourceException {
        if (this.languageCode.length() == 0) {
            return "";
        }
        ResourceBundle bundle = Locale.getBundle("ISO3Languages", this);
        return bundle.getString(this.languageCode);
    }

    public static String[] getISOCountries() {
        Country bundle = new Country();
        Enumeration keys = bundle.getKeys();
        int size = bundle.table.size();
        String[] result = new String[size];
        int index = 0;
        while (keys.hasMoreElements()) {
            String element = (String)keys.nextElement();
            result[index++] = element;
        }
        return result;
    }

    public static String[] getISOLanguages() {
        Language bundle = new Language();
        Enumeration keys = bundle.getKeys();
        String[] result = new String[bundle.table.size()];
        int index = 0;
        while (keys.hasMoreElements()) {
            result[index++] = (String)keys.nextElement();
        }
        return result;
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public String getVariant() {
        return this.variantCode;
    }

    public synchronized int hashCode() {
        return this.countryCode.hashCode() + this.languageCode.hashCode() + this.variantCode.hashCode();
    }

    public static synchronized void setDefault(Locale locale) {
        if (locale != null) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(setLocalePermission);
            }
        } else {
            throw new NullPointerException();
        }
        defaultLocale = locale;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.languageCode);
        if (this.countryCode.length() > 0) {
            result.append('_');
            result.append(this.countryCode);
        }
        if (this.variantCode.length() > 0 && result.length() > 0) {
            if (this.countryCode.length() == 0) {
                result.append("__");
            } else {
                result.append('_');
            }
            result.append(this.variantCode);
        }
        return result.toString();
    }

    static ResourceBundle getBundle(String clName, Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PriviAction("com.ibm.oti.locale." + clName, locale));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("country", this.countryCode);
        fields.put("hashcode", -1);
        fields.put("language", this.languageCode);
        fields.put("variant", this.variantCode);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.countryCode = (String)fields.get("country", "");
        this.languageCode = (String)fields.get("language", "");
        this.variantCode = (String)fields.get("variant", "");
    }
}

