/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

class TimeZoneTable
extends TimeZone {
    private static final long serialVersionUID = 1486479620294421434L;
    private int rawOffset;
    private SimpleTimeZone[] timezones;
    private int[][] dateOffsets;
    private long[] longOffsets;

    public TimeZoneTable(SimpleTimeZone[] timezones, int[][] dateOffsets, long[] longOffsets) {
        this.timezones = timezones;
        this.dateOffsets = dateOffsets;
        this.longOffsets = longOffsets;
        this.setID(timezones[0].getID());
        this.rawOffset = timezones[timezones.length - 1].getRawOffset();
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int time) {
        if (era == 1) {
            int i = this.dateOffsets.length - 1;
            while (i >= 0) {
                if (year >= this.dateOffsets[i][0] && (year != this.dateOffsets[i][0] || month >= this.dateOffsets[i][1] && (month != this.dateOffsets[i][1] || day >= this.dateOffsets[i][2] && (day != this.dateOffsets[i][2] || time >= this.dateOffsets[i][3])))) {
                    return this.timezones[i + 1].getOffset(era, year, month, day, dayOfWeek, time);
                }
                --i;
            }
        }
        return this.timezones[0].getOffset(era, year, month, day, dayOfWeek, time);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeZoneTable)) {
            return false;
        }
        TimeZoneTable table = (TimeZoneTable)object;
        if (this.getRawOffset() != table.getRawOffset() || !this.getID().equals(table.getID()) || this.timezones.length != table.timezones.length) {
            return false;
        }
        int i = 0;
        while (i < this.timezones.length) {
            if (!this.timezones[i].equals(table.timezones[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.dateOffsets.length) {
            int j = 0;
            while (j < this.dateOffsets[0].length) {
                if (this.dateOffsets[i][j] != table.dateOffsets[i][j]) {
                    return false;
                }
                ++j;
            }
            if (this.longOffsets[i] != table.longOffsets[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        int i = 0;
        while (i < this.timezones.length) {
            hashcode += this.timezones[i].hashCode();
            ++i;
        }
        return hashcode;
    }

    public boolean hasSameRules(TimeZone zone) {
        if (!(zone instanceof TimeZoneTable)) {
            return false;
        }
        TimeZoneTable table = (TimeZoneTable)zone;
        if (this.getRawOffset() != table.getRawOffset() || this.timezones.length != table.timezones.length) {
            return false;
        }
        int i = 0;
        while (i < this.timezones.length) {
            if (!this.timezones[i].hasSameRules(table.timezones[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.dateOffsets.length) {
            int j = 0;
            while (j < this.dateOffsets[0].length) {
                if (this.dateOffsets[i][j] != table.dateOffsets[i][j]) {
                    return false;
                }
                ++j;
            }
            if (this.longOffsets[i] != table.longOffsets[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean useDaylightTime() {
        return this.timezones[this.timezones.length - 1].useDaylightTime();
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int offset) {
        this.rawOffset = offset;
        int i = 0;
        while (i < this.timezones.length) {
            this.timezones[i].setRawOffset(offset);
            ++i;
        }
    }

    public boolean inDaylightTime(Date time) {
        long millis = time.getTime();
        int i = this.longOffsets.length - 1;
        while (i >= 0) {
            if (millis >= this.longOffsets[i]) {
                return this.timezones[i + 1].inDaylightTime(time);
            }
            --i;
        }
        return this.timezones[0].inDaylightTime(time);
    }

    public int getOffset(long time) {
        int i = this.longOffsets.length - 1;
        while (i >= 0) {
            if (time >= this.longOffsets[i]) {
                return this.timezones[i + 1].getOffset(time);
            }
            --i;
        }
        return this.timezones[0].getOffset(time);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getClass().getName());
        buffer.append('[');
        int i = 0;
        while (i < this.timezones.length) {
            if (i != 0) {
                buffer.append("\n");
                buffer.append(this.longOffsets[i - 1]);
                buffer.append(" : ");
            }
            buffer.append(this.timezones[i]);
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public int getDSTSavings() {
        int i = this.longOffsets.length - 1;
        while (i >= 0) {
            if (this.timezones[i].useDaylightTime()) {
                return this.timezones[i].getDSTSavings();
            }
            --i;
        }
        return 0;
    }

    public Object clone() {
        TimeZoneTable zone = (TimeZoneTable)super.clone();
        zone.timezones = new SimpleTimeZone[this.timezones.length];
        int i = 0;
        while (i < this.timezones.length) {
            zone.timezones[i] = (SimpleTimeZone)this.timezones[i].clone();
            ++i;
        }
        return zone;
    }
}

