/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap
extends AbstractMap
implements Map {
    private final ReferenceQueue referenceQueue;
    int elementCount;
    Entry[] elementData;
    private final int loadFactor;
    private int threshold;
    transient int modCount = 0;
    private static final int DEFAULT_SIZE = 16;

    public WeakHashMap() {
        this(16);
    }

    public WeakHashMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = new Entry[capacity == 0 ? 1 : capacity];
        this.loadFactor = 7500;
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public WeakHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = new Entry[capacity == 0 ? 1 : capacity];
        this.loadFactor = (int)(loadFactor * 10000.0f);
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public WeakHashMap(Map map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        this.putAll(map);
    }

    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
            while (this.referenceQueue.poll() != null) {
            }
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)this.elementData.length * (long)this.loadFactor / 10000L);
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public Set entrySet() {
        this.poll();
        return new AbstractSet(){

            public int size() {
                return WeakHashMap.this.size();
            }

            public void clear() {
                WeakHashMap.this.clear();
            }

            public boolean remove(Object object) {
                if (this.contains(object)) {
                    WeakHashMap.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            public boolean contains(Object object) {
                Object key;
                Entry entry;
                if (object instanceof Map.Entry && (entry = WeakHashMap.this.getEntry(((Map.Entry)object).getKey())) != null && ((key = entry.get()) != null || entry.isNull)) {
                    return object.equals(entry);
                }
                return false;
            }

            public Iterator iterator() {
                return new HashIterator(new Entry.Type(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object get(Map.Entry entry) {
                        return entry;
                    }
                });
            }
        };
    }

    public Set keySet() {
        this.poll();
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public boolean contains(Object object) {
                    return WeakHashMap.this.containsKey(object);
                }

                public int size() {
                    return WeakHashMap.this.size();
                }

                public void clear() {
                    WeakHashMap.this.clear();
                }

                public boolean remove(Object key) {
                    if (WeakHashMap.this.containsKey(key)) {
                        WeakHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return new HashIterator(new Entry.Type(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(Map.Entry entry) {
                            return entry.getKey();
                        }
                    });
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        this.poll();
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection(){

                public int size() {
                    return WeakHashMap.this.size();
                }

                public void clear() {
                    WeakHashMap.this.clear();
                }

                public boolean contains(Object object) {
                    return WeakHashMap.this.containsValue(object);
                }

                public Iterator iterator() {
                    return new HashIterator(new Entry.Type(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(Map.Entry entry) {
                            return entry.getValue();
                        }
                    });
                }
            };
        }
        return this.valuesCollection;
    }

    public Object get(Object key) {
        this.poll();
        if (key != null) {
            int index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            Entry entry = this.elementData[index];
            while (entry != null) {
                if (key.equals(entry.get())) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry getEntry(Object key) {
        this.poll();
        if (key != null) {
            int index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            Entry entry = this.elementData[index];
            while (entry != null) {
                if (key.equals(entry.get())) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsValue(Object value) {
        this.poll();
        if (value != null) {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry entry = this.elementData[i];
                while (entry != null) {
                    Object key = entry.get();
                    if ((key != null || entry.isNull) && value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry entry = this.elementData[i];
                while (entry != null) {
                    Object key = entry.get();
                    if ((key != null || entry.isNull) && entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    void poll() {
        Entry toRemove;
        while ((toRemove = (Entry)this.referenceQueue.poll()) != null) {
            this.removeEntry(toRemove);
        }
    }

    void removeEntry(Entry toRemove) {
        Entry last = null;
        int index = (toRemove.hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry entry = this.elementData[index];
        while (entry != null) {
            if (toRemove == entry) {
                ++this.modCount;
                if (last == null) {
                    this.elementData[index] = entry.next;
                } else {
                    last.next = entry.next;
                }
                --this.elementCount;
                break;
            }
            last = entry;
            entry = entry.next;
        }
    }

    public Object put(Object key, Object value) {
        Entry entry;
        this.poll();
        int index = 0;
        if (key != null) {
            index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && !key.equals(entry.get())) {
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                entry = entry.next;
            }
        }
        if (entry == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = key == null ? 0 : (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = new Entry(key, value, this.referenceQueue);
            entry.next = this.elementData[index];
            this.elementData[index] = entry;
            return null;
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    private void rehash() {
        int length = this.elementData.length << 1;
        if (length == 0) {
            length = 1;
        }
        Entry[] newData = new Entry[length];
        int i = 0;
        while (i < this.elementData.length) {
            Entry entry = this.elementData[i];
            while (entry != null) {
                int index = entry.isNull ? 0 : (entry.hash & Integer.MAX_VALUE) % length;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
            ++i;
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    public Object remove(Object key) {
        Entry entry;
        this.poll();
        int index = 0;
        Entry last = null;
        if (key != null) {
            index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && !key.equals(entry.get())) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry != null) {
            ++this.modCount;
            if (last == null) {
                this.elementData[index] = entry.next;
            } else {
                last.next = entry.next;
            }
            --this.elementCount;
            return entry.value;
        }
        return null;
    }

    public int size() {
        this.poll();
        return this.elementCount;
    }

    private static final class Entry
    extends WeakReference
    implements Map.Entry {
        int hash;
        boolean isNull;
        Object value;
        Entry next;

        Entry(Object key, Object object, ReferenceQueue queue) {
            super(key, queue);
            this.isNull = key == null;
            this.hash = this.isNull ? 0 : key.hashCode();
            this.value = object;
        }

        public Object getKey() {
            return super.get();
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object result = this.value;
            this.value = object;
            return result;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)other;
            Object key = super.get();
            return (key == null ? key == entry.getKey() : key.equals(entry.getKey())) && (this.value == null ? this.value == entry.getValue() : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return this.hash + (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return super.get() + "=" + this.value;
        }

        static interface Type {
            public Object get(Map.Entry var1);
        }
    }

    class HashIterator
    implements Iterator {
        private int position = 0;
        private int expectedModCount;
        private Entry currentEntry;
        private Entry nextEntry;
        private Object nextKey;
        final Entry.Type type;

        HashIterator(Entry.Type type) {
            this.type = type;
            this.expectedModCount = WeakHashMap.this.modCount;
        }

        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            while (true) {
                if (this.nextEntry == null) {
                    while (this.position < WeakHashMap.this.elementData.length) {
                        if ((this.nextEntry = WeakHashMap.this.elementData[this.position++]) != null) break;
                    }
                    if (this.nextEntry == null) {
                        return false;
                    }
                }
                this.nextKey = this.nextEntry.get();
                if (this.nextKey != null || this.nextEntry.isNull) {
                    return true;
                }
                this.nextEntry = this.nextEntry.next;
            }
        }

        public Object next() {
            if (this.expectedModCount == WeakHashMap.this.modCount) {
                if (this.hasNext()) {
                    this.currentEntry = this.nextEntry;
                    this.nextEntry = this.currentEntry.next;
                    Object result = this.type.get(this.currentEntry);
                    this.nextKey = null;
                    return result;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            if (this.expectedModCount != WeakHashMap.this.modCount) throw new ConcurrentModificationException();
            if (this.currentEntry == null) throw new IllegalStateException();
            WeakHashMap.this.removeEntry(this.currentEntry);
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }
}

