/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class CheckedInputStream
extends FilterInputStream {
    private Checksum check;

    public CheckedInputStream(InputStream is, Checksum csum) {
        super(is);
        this.check = csum;
    }

    public int read() throws IOException {
        int x = this.in.read();
        if (x != -1) {
            this.check.update(x);
        }
        return x;
    }

    public int read(byte[] buf, int off, int nbytes) throws IOException {
        int x = this.in.read(buf, off, nbytes);
        if (x != -1) {
            this.check.update(buf, off, x);
        }
        return x;
    }

    public Checksum getChecksum() {
        return this.check;
    }

    public long skip(long nbytes) throws IOException {
        if (nbytes < 1L) {
            return 0L;
        }
        long skipped = 0L;
        byte[] b = new byte[2048];
        while (skipped != nbytes) {
            int v = (int)(nbytes - skipped);
            int x = this.in.read(b, 0, v > b.length ? b.length : v);
            if (x == -1) {
                return skipped;
            }
            this.check.update(b, 0, x);
            skipped += (long)x;
        }
        return skipped;
    }
}

