/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import com.ibm.oti.jce.support.JCEClassValidator;
import com.ibm.oti.jce.support.Msg;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class KeyAgreement {
    private final KeyAgreementSpi implementation;
    private final Provider provider;
    private final String algorithm;
    private boolean isInitialised = false;
    private static final String KEY_AGREEMENT_SERVICE_PREFIX = "KeyAgreement.";

    protected KeyAgreement(KeyAgreementSpi implementation, Provider provider, String algorithm) {
        this.implementation = implementation;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyAgreement getInstance(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException();
        }
        Provider[] providers = null;
        try {
            providers = Security.getProviders(KEY_AGREEMENT_SERVICE_PREFIX + algorithm);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NoSuchAlgorithmException();
        }
        if (providers == null) {
            throw new NoSuchAlgorithmException();
        }
        return KeyAgreement.getInstance(algorithm, providers[0]);
    }

    public static final KeyAgreement getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException();
        }
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(Msg.getString("JCE003", provider));
        }
        return KeyAgreement.getInstance(algorithm, p);
    }

    public static final KeyAgreement getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        if (algorithm == null) {
            throw new NoSuchAlgorithmException();
        }
        String className = provider.getProperty(KEY_AGREEMENT_SERVICE_PREFIX + algorithm);
        if (className == null) {
            throw new NoSuchAlgorithmException();
        }
        Class keyAgreementClass = null;
        try {
            keyAgreementClass = Class.forName(className, true, provider.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        JCEClassValidator validator = new JCEClassValidator(keyAgreementClass);
        try {
            validator.validateJCEProviderClass();
        }
        catch (SecurityException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        KeyAgreementSpi implementationClass = null;
        try {
            implementationClass = (KeyAgreementSpi)keyAgreementClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return new KeyAgreement(implementationClass, provider, algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.implementation.engineInit(key, new SecureRandom());
        this.isInitialised = true;
    }

    public final void init(Key key, SecureRandom random) throws InvalidKeyException {
        this.implementation.engineInit(key, random);
        this.isInitialised = true;
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.implementation.engineInit(key, params, new SecureRandom());
        this.isInitialised = true;
    }

    public final void init(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.implementation.engineInit(key, params, random);
        this.isInitialised = true;
    }

    public final Key doPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        return this.implementation.engineDoPhase(key, lastPhase);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        return this.implementation.engineGenerateSecret();
    }

    public final int generateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        return this.implementation.engineGenerateSecret(sharedSecret, offset);
    }

    public final SecretKey generateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        return this.implementation.engineGenerateSecret(algorithm);
    }
}

