/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import com.ibm.oti.jce.support.JCEClassValidator;
import com.ibm.oti.jce.support.Msg;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public class SecretKeyFactory {
    private SecretKeyFactorySpi implementation = null;
    private Provider provider = null;
    private String algorithm = null;
    private static String KEY_FACT_SERVICE_PREFIX = "SecretKeyFactory.";

    protected SecretKeyFactory(SecretKeyFactorySpi implementation, Provider provider, String algorithm) {
        this.implementation = implementation;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static final SecretKeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new IllegalArgumentException();
        }
        Provider[] providers = Security.getProviders(String.valueOf(KEY_FACT_SERVICE_PREFIX) + algorithm);
        if (providers == null) {
            throw new NoSuchAlgorithmException();
        }
        return SecretKeyFactory.getInstance(algorithm, providers[0]);
    }

    public static final SecretKeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(Msg.getString("JCE003", provider));
        }
        return SecretKeyFactory.getInstance(algorithm, p);
    }

    public static final SecretKeyFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        String className = provider.getProperty(String.valueOf(KEY_FACT_SERVICE_PREFIX) + algorithm);
        if (className == null) {
            throw new NoSuchAlgorithmException();
        }
        Class factoryClass = null;
        try {
            factoryClass = Class.forName(className, true, provider.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        JCEClassValidator validator = new JCEClassValidator(factoryClass);
        try {
            validator.validateJCEProviderClass();
        }
        catch (SecurityException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        SecretKeyFactorySpi implementationClass = null;
        try {
            implementationClass = (SecretKeyFactorySpi)factoryClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return new SecretKeyFactory(implementationClass, provider, algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final SecretKey generateSecret(KeySpec spec) throws InvalidKeySpecException {
        return this.implementation.engineGenerateSecret(spec);
    }

    public final KeySpec getKeySpec(SecretKey key, Class keySpecClass) throws InvalidKeySpecException {
        return this.implementation.engineGetKeySpec(key, keySpecClass);
    }

    public final SecretKey translateKey(SecretKey key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException();
        }
        return this.implementation.engineTranslateKey(key);
    }
}

