/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import com.ibm.oti.jce.support.Util;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    private byte[] keyMaterial;
    public static final int DES_KEY_LEN = 8;
    private static byte[][] weakKeys = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {31, 31, 31, 31, 14, 14, 14, 14}, {-32, -32, -32, -32, -15, -15, -15, -15}, {-2, -2, -2, -2, -2, -2, -2, -2}};
    private static byte[][] semiWeakKeys = new byte[][]{{1, -2, 1, -2, 1, -2, 1, -2}, {-2, 1, -2, 1, -2, 1, -2, 1}, {31, -32, 31, -32, 14, -15, 14, -15}, {-32, 31, -32, 31, -15, 14, -15, 14}, {1, -32, 1, -32, 1, -15, 1, -15}, {-32, 1, -32, 1, -15, 1, -15, 1}, {31, -2, 31, -2, 14, -2, 14, -2}, {-2, 31, -2, 31, -2, 14, -2, 14}, {1, 31, 1, 31, 1, 14, 1, 14}, {31, 1, 31, 1, 14, 1, 14, 1}, {-32, -2, -32, -2, -15, -2, -15, -2}, {-2, -32, -2, -32, -2, -15, -2, -15}};

    public DESKeySpec(byte[] key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length < 8) {
            throw new InvalidKeyException();
        }
        this.keyMaterial = new byte[8];
        System.arraycopy((Object)key, 0, (Object)this.keyMaterial, 0, 8);
    }

    public DESKeySpec(byte[] key, int offset) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length - offset < 8) {
            throw new InvalidKeyException();
        }
        this.keyMaterial = new byte[8];
        System.arraycopy((Object)key, offset, (Object)this.keyMaterial, 0, 8);
    }

    public byte[] getKey() {
        byte[] keyCopy = new byte[8];
        System.arraycopy((Object)this.keyMaterial, 0, (Object)keyCopy, 0, 8);
        return keyCopy;
    }

    public static boolean isParityAdjusted(byte[] keyMaterial, int offset) throws InvalidKeyException {
        if (keyMaterial == null || keyMaterial.length - offset < 8) {
            throw new InvalidKeyException();
        }
        return Util.isParityAdjusted(keyMaterial, offset, 8);
    }

    public static boolean isWeak(byte[] key, int offset) throws InvalidKeyException {
        if (key == null || key.length - offset < 8) {
            throw new InvalidKeyException();
        }
        byte[] keyMaterial = new byte[8];
        System.arraycopy((Object)key, offset, (Object)keyMaterial, 0, 8);
        int i = 0;
        while (i < weakKeys.length) {
            byte[] weakKey = weakKeys[i];
            if (DESKeySpec.keysEqual(weakKey, keyMaterial)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < semiWeakKeys.length) {
            byte[] semiWeakKey = semiWeakKeys[i];
            if (DESKeySpec.keysEqual(semiWeakKey, keyMaterial)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean keysEqual(byte[] key1, byte[] key2) {
        int i = 0;
        while (i < key1.length) {
            if (key1[i] != key2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

