/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.aueframework.common.AueContextImpl;
import se.ericsson.crbs.omf.aue.common.ConversionActionListener;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.ModificationXmlExecutorHelper;
import se.ericsson.crbs.omf.aue.common.actions.ConversionAction;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.ModificationXmlHandler;
import se.ericsson.crbs.omf.aue.common.xml.ModificationXmlHandlerFactory;

public class ModificationXmlExecutorHelperImpl
implements ConversionActionListener,
ModificationXmlExecutorHelper {
    private static final Class THIS_CLASS = ModificationXmlExecutorHelperImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    protected static final CrbsAueException AUE_EXCEPTION_NOT_SET = new CrbsAueException("No exception received");
    protected static final AueContext CONVERTER_CONTEXT_NOT_SET = new AueContextImpl();
    protected final String fromRevision;
    protected final String toRevision;
    protected final XmlHolder xmlHolder;
    protected AueContext aueContext = CONVERTER_CONTEXT_NOT_SET;
    protected CrbsAueException aueException = AUE_EXCEPTION_NOT_SET;

    public ModificationXmlExecutorHelperImpl(String fromRevision, String toRevision, XmlHolder xmlHolder) {
        this.fromRevision = fromRevision;
        this.toRevision = toRevision;
        this.xmlHolder = xmlHolder;
    }

    public void parseModificationXmlFile(AueContext anAueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        this.aueContext = anAueContext;
        anAueContext.setAttribute("fromVersion", (Object)this.fromRevision);
        anAueContext.setAttribute("toVersion", (Object)this.toRevision);
        this.aueException = AUE_EXCEPTION_NOT_SET;
        ModificationXmlHandler handler = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            handler = ModificationXmlHandlerFactory.getModificationXmlHandler(anAueContext);
            parser.setContentHandler(handler);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.xmlHolder.getContents().getBytes());
            InputSource inputSource = new InputSource(inputStream);
            handler.addMoConversionActionsCollectedListener(this);
            parser.parse(inputSource);
        }
        catch (SAXException se) {
            if (!((Object)((Object)this.aueException)).equals((Object)AUE_EXCEPTION_NOT_SET)) {
                throw this.aueException;
            }
            String msg = THIS_CLASS + ": Parse error: " + se.getMessage() + " when parsing file: " + this.xmlHolder.getPath();
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(msg, se));
            throw new CrbsAueException(msg, se);
        }
        catch (IOException ioe) {
            String msg = THIS_CLASS + ": Cannot read modification file: " + this.xmlHolder.getPath();
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(msg, ioe));
            throw new CrbsAueException(msg, ioe);
        }
        finally {
            try {
                handler.removeMoConversionActionsCollectedListener(this);
            }
            catch (Exception ignore) {}
        }
        this.aueContext = CONVERTER_CONTEXT_NOT_SET;
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    public String getFromRevision() {
        return this.fromRevision;
    }

    public String getToRevision() {
        return this.toRevision;
    }

    public void moConversionActionsCollected(String moName, List conversionActionList) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "moConversionActionsCollected()");
        Iterator iter = conversionActionList.iterator();
        while (iter.hasNext()) {
            ConversionAction action = (ConversionAction)iter.next();
            logger.traceDebug(THIS_CLASS, "Calling convert on " + action.getClass().getName());
            try {
                action.convert(this.aueContext);
            }
            catch (NoSuchTableException nste) {
                logger.traceGeneral(THIS_CLASS, "No instance of MO, " + AueUtil.doubleQuote(moName) + ", found");
            }
            catch (TableAlreadyExistsException taee) {
                logger.traceGeneral(THIS_CLASS, "Table ending with the from MOM version already exists for " + AueUtil.doubleQuote(moName) + ", skipping it.");
            }
            catch (CrbsAueException ae) {
                this.aueException = ae;
                throw ae;
            }
        }
        logger.traceReturn(THIS_CLASS, "moConversionActionsCollected()");
    }
}

